/*
 * Decompiled with CFR 0.152.
 */
package org.jrt.impl;

import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jrt.impl.Configuration;
import org.jrt.impl.JRTStatistic;
import org.jrt.impl.LogWriter;
import org.jrt.internal.latencyutils.LatencyStats;
import org.jrt.socket.api.CodeWriter;
import org.jrt.socket.api.JRTHic;
import org.jrt.socket.api.Transformer;
import org.jrt.socket.nio.NioSocketCodeWrapper;
import org.jrt.socket.regular.JavaNetSocketCodeWrapper;

public class JRT {
    public static volatile boolean initialized = false;
    public static volatile boolean finishByError = false;
    public static long jrtInstances = 0L;
    private static final String title = "";
    public long startTime;
    public LatencyStats i2oLS;
    public LatencyStats o2iLS;
    public boolean isAlive = true;
    public Configuration configuration = new Configuration();
    public JRTStatistic jrtStat;
    public Map<Object, JRTHic> sockRTs = new ConcurrentHashMap<Object, JRTHic>(new WeakHashMap());
    public static ConcurrentHashMap<String, JRT> jRTWorkers = new ConcurrentHashMap();
    private static final String[] remoteaddr = new String[]{"-raddr", "remote-addr"};
    private static final String[] loginterval = new String[]{"-si", "sample-interval"};
    private static final String[] remoteport = new String[]{"-rport", "remote-port"};
    private static final String[] localport = new String[]{"-lport", "local-port"};
    private static final String[] filterentry = new String[]{"-f", "filter-entry"};
    private static final String[] help = new String[]{"-h", "--help", "help", "h"};
    private static final String[] startdelaying = new String[]{"-start", "start"};
    private static final String[] workingtime = new String[]{"-fin", "finish-after"};
    private static final String[] logprefix = new String[]{"-lp", "log-prefix"};
    private static final String[] uuid = new String[]{"-id", "uuid"};
    private static final String[] ioMode = new String[]{"-mode"};
    private static final String[] i2oenabling = new String[]{"-i2o"};
    private static final String[] o2ienabling = new String[]{"-o2i"};

    public static void main(String[] args) {
        System.out.println("jRT.jar doesn't have now functional main method. Please rerun your application as:\n\tjava -javaagent:jRT.jar -jar yourapp.jar");
        System.exit(1);
    }

    private static String printKeys(String[] keys) {
        StringBuilder sb = new StringBuilder();
        for (String s : keys) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static String printKeys(String[] keys, int align) {
        String st = JRT.printKeys(keys);
        return st + String.format("%0" + Math.max(1, align - st.length()) + "d", 0).replace('0', ' ');
    }

    public static void printHelpAndExit() {
        System.out.println("Usage:");
        System.out.println("\tjava -jar jRT.jar[=<args>]  -jar yourapp.jar\n");
        JRT.printHelpParameters();
        System.out.println("\n");
        System.out.println("Please rerun application with proper CLI options.\n");
        finishByError = true;
        System.exit(1);
    }

    public static void printHelpParameters() {
        System.out.println("\t\twhere <args> is an comma separated list of arguments like arg1,arg2=val2 e.t.c\n");
        System.out.println("\t\tARGUMENTS:");
        System.out.println("\t\t  " + JRT.printKeys(help, 40) + " to print help");
        System.out.println("\t\t  " + JRT.printKeys(remoteaddr, 40) + " to add filter by remote address");
        System.out.println("\t\t  " + JRT.printKeys(remoteport, 40) + " to add filter by remote port");
        System.out.println("\t\t  " + JRT.printKeys(localport, 40) + " to add filter by local port");
        System.out.println("\t\t  " + JRT.printKeys(filterentry, 40) + " to add filter by entry: <Local port>:<Remote address>:<Remote port> any part can be empty");
        System.out.println("\t\t  " + JRT.printKeys(loginterval, 40) + " to set log sampling interval");
        System.out.println("\t\t  " + JRT.printKeys(startdelaying, 40) + " to specify time delay to start jRT");
        System.out.println("\t\t  " + JRT.printKeys(workingtime, 40) + " to specify how long jRT will work");
        System.out.println("\t\t  " + JRT.printKeys(logprefix, 40) + " to specify jRT log prefix");
        System.out.println("\t\t  " + JRT.printKeys(uuid, 40) + " to specify jRT inner ID (take <string>)");
        System.out.println("\t\t  " + JRT.printKeys(ioMode, 40) + " to specify jRT mode. Expects one of i2o, o2i, both. Both by default");
    }

    public void premain(String agentArgument, Instrumentation instrumentation) {
        this.jrtStat = new JRTStatistic();
        this.startTime = System.currentTimeMillis();
        this.parseArguments(agentArgument);
        jRTWorkers.put(this.configuration.uuid, this);
        if (this.configuration.i2oEnabled) {
            this.i2oLS = new LatencyStats();
        }
        if (this.configuration.o2iEnabled) {
            this.o2iLS = new LatencyStats();
        }
        this.instrument(agentArgument, instrumentation);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string = JRT.title;
                synchronized (JRT.title) {
                    if (finishByError) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    System.out.println(JRT.title);
                    System.out.println("***************************************************************");
                    System.out.println("jRT configuration: ");
                    System.out.println("jRT uid " + JRT.this.configuration.uuid);
                    System.out.println("log files " + JRT.this.configuration.logPrefix + ".*");
                    System.out.println("---------------------------------------------------------------");
                    System.out.println("jRT Statistic: ");
                    System.out.println(" " + JRT.this.jrtStat.processedSocket + " sockets was processed");
                    System.out.println("***************************************************************");
                    System.out.flush();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        LogWriter jRTLogWriter = new LogWriter(this);
        jRTLogWriter.start();
    }

    public void parseArguments(String agentArgument) throws NumberFormatException {
        if (null != agentArgument) {
            for (String v : agentArgument.split(",")) {
                String[] vArr = v.split("=");
                if (vArr.length > 2) {
                    System.out.println("Wrong format jRT arguments.\n");
                    JRT.printHelpAndExit();
                }
                if (JRT.hasKey(help, vArr[0])) {
                    JRT.printHelpAndExit();
                }
                if (JRT.hasKey(remoteaddr, vArr[0])) {
                    this.configuration.filterEntries.add(new Configuration.IOFilterEntry(null, vArr[1], null));
                }
                if (JRT.hasKey(localport, vArr[0])) {
                    this.configuration.filterEntries.add(new Configuration.IOFilterEntry(vArr[1], null, null));
                }
                if (JRT.hasKey(remoteport, vArr[0])) {
                    this.configuration.filterEntries.add(new Configuration.IOFilterEntry(null, null, vArr[1]));
                }
                if (JRT.hasKey(filterentry, vArr[0]) && vArr.length == 2) {
                    boolean isCorrect = true;
                    String localPort = null;
                    String remoteAddr = null;
                    String remotePort = null;
                    String[] ports = vArr[1].split(":");
                    if (ports.length > 0 && ports[0].length() > 0) {
                        localPort = ports[0];
                    }
                    if (ports.length > 1 && ports[1].length() > 0) {
                        remoteAddr = ports[1];
                    }
                    if (ports.length > 2 && ports[2].length() > 0) {
                        remotePort = ports[2];
                    }
                    if (ports.length < 2 || ports.length > 3) {
                        isCorrect = false;
                    }
                    if (!isCorrect) {
                        System.err.println("Wrong " + JRT.printKeys(filterentry) + " format\n\n");
                        JRT.printHelpAndExit();
                    }
                    this.configuration.filterEntries.add(new Configuration.IOFilterEntry(localPort, remoteAddr, remotePort));
                }
                if (JRT.hasKey(loginterval, vArr[0])) {
                    this.configuration.logWriterInterval = Long.valueOf(vArr[1]);
                }
                if (JRT.hasKey(startdelaying, vArr[0])) {
                    this.configuration.startDelaying = Long.valueOf(vArr[1]);
                }
                if (JRT.hasKey(workingtime, vArr[0])) {
                    this.configuration.workingTime = Long.valueOf(vArr[1]);
                }
                if (JRT.hasKey(logprefix, vArr[0])) {
                    this.configuration.setLogNamePattern(vArr[1]);
                }
                if (JRT.hasKey(uuid, vArr[0])) {
                    this.configuration.uuid = vArr[1];
                }
                if (JRT.hasKey(i2oenabling, vArr[0])) {
                    this.configuration.i2oEnabled = Boolean.valueOf(vArr[1]);
                }
                if (JRT.hasKey(o2ienabling, vArr[0])) {
                    this.configuration.o2iEnabled = Boolean.valueOf(vArr[1]);
                }
                if (!JRT.hasKey(ioMode, vArr[0])) continue;
                if ("i2o".equals(vArr[1])) {
                    this.configuration.i2oEnabled = true;
                    this.configuration.o2iEnabled = false;
                    continue;
                }
                if ("o2i".equals(vArr[1])) {
                    this.configuration.i2oEnabled = false;
                    this.configuration.o2iEnabled = true;
                    continue;
                }
                if ("both".equals(vArr[1])) {
                    this.configuration.i2oEnabled = true;
                    this.configuration.o2iEnabled = true;
                    continue;
                }
                System.err.println("Parameter " + vArr[0] + " expects one of i2o, o2i, both argument. But " + vArr[1] + " has been got.");
                JRT.printHelpAndExit();
            }
        }
    }

    public void instrument(String agentArgument, Instrumentation instrumentation) {
        instrumentation.addTransformer(new Transformer(this, new JavaNetSocketCodeWrapper()), true);
        instrumentation.addTransformer(new Transformer(this, new NioSocketCodeWrapper()), true);
        this.redeclare(instrumentation, new JavaNetSocketCodeWrapper());
        this.redeclare(instrumentation, new NioSocketCodeWrapper());
    }

    private void redeclare(Instrumentation instrumentation, CodeWriter cw) {
        ArrayList<Class> ac = new ArrayList<Class>();
        for (Class c : instrumentation.getAllLoadedClasses()) {
            String className = c.getName().replace(".", "/");
            if (!cw.needInstrument(className)) continue;
            ac.add(c);
            try {
                instrumentation.retransformClasses(c);
            }
            catch (UnmodifiableClassException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static JRT premain0(String agentArgument, Instrumentation instrumentation) {
        if (initialized) {
            System.out.println("WARNING: multiple instances of jRT was ran. (It's not well tested yet)");
        }
        JRT jRT = new JRT();
        jRT.premain(agentArgument, instrumentation);
        initialized = true;
        return jRT;
    }

    private static boolean hasKey(String[] list, String key) {
        for (String s : list) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }
}

