/*
 * Decompiled with CFR 0.152.
 */
package org.jrt.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jrt.impl.JRT;
import org.jrt.internal.hdrhistogram.Histogram;
import org.jrt.internal.hdrhistogram.HistogramLogWriter;

public class LogWriter
extends Thread {
    private final JRT jRT;

    public LogWriter(JRT jRT) {
        this.setDaemon(true);
        this.jRT = jRT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HistogramLogWriter i2olog = null;
        HistogramLogWriter o2ilog = null;
        try {
            if (null != this.jRT.i2oLS) {
                i2olog = new HistogramLogWriter(new File(this.jRT.configuration.logPrefix + ".i2o.hlog"));
            }
            if (null != this.jRT.o2iLS) {
                o2ilog = new HistogramLogWriter(new File(this.jRT.configuration.logPrefix + ".o2i.hlog"));
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JRT.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(1);
        }
        try {
            Histogram intervalHistogram2;
            Histogram intervalHistogram;
            if (null != this.jRT.i2oLS) {
                i2olog.outputLegend();
                i2olog.outputStartTime(this.jRT.startTime);
            }
            if (null != this.jRT.o2iLS) {
                o2ilog.outputLegend();
                o2ilog.outputStartTime(this.jRT.startTime);
            }
            while (System.currentTimeMillis() - this.jRT.startTime < this.jRT.configuration.startDelaying) {
                if (null != this.jRT.i2oLS) {
                    intervalHistogram = this.jRT.i2oLS.getIntervalHistogram();
                }
                if (null != this.jRT.o2iLS) {
                    intervalHistogram2 = this.jRT.o2iLS.getIntervalHistogram();
                }
                Thread.sleep(this.jRT.configuration.logWriterInterval);
            }
            while (System.currentTimeMillis() - this.jRT.startTime < this.jRT.configuration.workingTime && this.jRT.isAlive && !Thread.interrupted()) {
                if (null != this.jRT.i2oLS) {
                    intervalHistogram = this.jRT.i2oLS.getIntervalHistogram();
                    intervalHistogram.setStartTimeStamp(intervalHistogram.getStartTimeStamp() - this.jRT.startTime);
                    intervalHistogram.setEndTimeStamp(intervalHistogram.getEndTimeStamp() - this.jRT.startTime);
                    i2olog.outputIntervalHistogram(intervalHistogram);
                }
                if (null != this.jRT.o2iLS) {
                    intervalHistogram2 = this.jRT.o2iLS.getIntervalHistogram();
                    intervalHistogram2.setStartTimeStamp(intervalHistogram2.getStartTimeStamp() - this.jRT.startTime);
                    intervalHistogram2.setEndTimeStamp(intervalHistogram2.getEndTimeStamp() - this.jRT.startTime);
                    o2ilog.outputIntervalHistogram(intervalHistogram2);
                }
                Thread.sleep(this.jRT.configuration.logWriterInterval);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (null != this.jRT.i2oLS) {
                this.jRT.i2oLS.stop();
            }
            if (null != this.jRT.o2iLS) {
                this.jRT.o2iLS.stop();
            }
        }
    }
}

