/*
 * Decompiled with CFR 0.152.
 */
package org.jrt.socket.api;

import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.jrt.impl.JRT;
import org.jrt.internal.javassist.ClassPool;
import org.jrt.internal.javassist.CtBehavior;
import org.jrt.internal.javassist.CtClass;
import org.jrt.internal.javassist.CtField;
import org.jrt.internal.javassist.Modifier;
import org.jrt.socket.api.CodeWriter;

public class Transformer
implements ClassFileTransformer {
    private static boolean traceClasses = false;
    private static boolean traceMethods = false;
    private final JRT jrt;
    private final CodeWriter codeWriter;

    public Transformer(JRT jrt, CodeWriter codeWriter) {
        this.jrt = jrt;
        this.codeWriter = codeWriter;
        codeWriter.init(jrt);
    }

    public byte[] transform(ClassLoader loader, String className, Class clazz, ProtectionDomain domain, byte[] bytes) {
        if (traceClasses) {
            System.out.println(">> " + className);
        }
        if (!this.codeWriter.needInstrument(className)) {
            return bytes;
        }
        if (traceClasses) {
            System.out.println(">> " + className + " will be instrumented!");
        }
        return this.doClass(className, clazz, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doClass(String className, Class clazz, byte[] b) {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass cl = null;
            String code = null;
            String methodDescription = null;
            try {
                cl = pool.makeClass(new ByteArrayInputStream(b));
                if (!cl.isInterface()) {
                    CtBehavior[] methods;
                    for (String varDeclaration : this.codeWriter.classNewFields(className)) {
                        Object[] var;
                        if (traceClasses) {
                            System.out.println(">> " + className + " will have new field " + varDeclaration);
                        }
                        if ((var = varDeclaration.split(" ")).length != 2) {
                            code = null;
                            throw new Exception("Check your codeWriter implementation: var declaration array size != 2, ==" + var.length);
                        }
                        CtClass typeClass = pool.get(var[0]);
                        code = "adding field " + Arrays.deepToString(var);
                        CtField field = new CtField(typeClass, (String)var[1], cl);
                        cl.addField(field);
                    }
                    for (CtBehavior method : methods = cl.getDeclaredBehaviors()) {
                        if (traceMethods) {
                            System.out.println(">>> " + className + " go over method " + method.getLongName());
                        }
                        if (method.isEmpty() || Modifier.isNative(method.getModifiers())) continue;
                        String pre = this.codeWriter.preCode(method.getLongName());
                        String post = this.codeWriter.postCode(method.getLongName());
                        if (pre != null && pre.length() > 0) {
                            code = pre;
                            methodDescription = "insert before method " + method.getLongName();
                            method.insertBefore(pre);
                        }
                        if (post != null && post.length() > 0) {
                            code = post;
                            methodDescription = "insert before method " + method.getLongName();
                            method.insertAfter(post);
                        }
                        if (!traceMethods || (pre == null || pre.length() <= 0) && (post == null || post.length() <= 0)) continue;
                        System.out.println(">>> " + className + " method " + method.getLongName() + " will be instrumented.");
                    }
                    code = null;
                    methodDescription = null;
                    b = cl.toBytecode();
                }
            }
            catch (Exception e) {
                System.err.println("Could not instrument class=" + className + " (" + methodDescription + ")" + "\n, code = " + code + "\n, exception : " + e.getMessage() + "\n:" + e);
                System.err.flush();
                e.printStackTrace();
            }
            finally {
                if (cl != null) {
                    cl.detach();
                }
            }
            return b;
        }
        catch (RuntimeException e) {
            System.err.println("Transformation failed with : " + e);
            throw e;
        }
        catch (Throwable t) {
            System.err.println("Transformation failed with : " + t);
            System.exit(1);
            return null;
        }
    }
}

