/*
 * Decompiled with CFR 0.152.
 */
package azulinspector;

import azulinspector.output.PrefixedWriter;
import azulinspector.utils.Utilities;
import azulinspector.utils.Version;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;

public final class Agent {
    private static final PrefixedWriter out = new PrefixedWriter(System.out);

    public static void main(String[] args) {
        out.println("AzulInspector (" + Version.VERSION + ")");
        Utilities.outResourceFile(out, "agent_usage.txt");
    }

    public static void premain(String args, Instrumentation inst) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        out.println("Starting agent - " + Version.VERSION);
        String home = "";
        String aid = "";
        MBeanServer jmxc = ManagementFactory.getPlatformMBeanServer();
        RuntimeMXBean remoteRuntime = ManagementFactory.newPlatformMXBeanProxy(jmxc, "java.lang:type=Runtime", RuntimeMXBean.class);
        Map<String, String> sysprop = remoteRuntime.getSystemProperties();
        for (String key : sysprop.keySet()) {
            out.println(key + " = " + sysprop.get(key));
            if (key.matches("java.home")) {
                home = sysprop.get(key);
                out.println("Java Home is " + home);
            }
            if (!key.matches("java.class.path")) continue;
            String jcp = sysprop.get(key);
            String[] temp1 = jcp.split(":");
            for (int a = 0; a < temp1.length; ++a) {
                if (!temp1[a].contains("AzulInspector.jar")) continue;
                aid = temp1[a].replace("/AzulInspector.jar", "");
            }
            out.println("AzulInspector Location is " + aid);
        }
        List<String> jvmargs = remoteRuntime.getInputArguments();
        String[] port = null;
        for (String jvmarg : jvmargs) {
            if (!jvmarg.contains("ARTAPort")) continue;
            port = jvmarg.split("=");
            out.println("Located ARTAPort " + port[1]);
        }
        out.println("Name: " + remoteRuntime.getName());
        String jvmpid = remoteRuntime.getName();
        String[] temp = jvmpid.split("@");
        jvmpid = temp[0];
        out.println("pid for this process " + jvmpid);
        Class<?> cls = Class.forName("azulinspector.Main");
        Method meth = cls.getMethod("main", String[].class);
        String[] params = new String[]{"127.0.0.1", "0", "Agent", jvmpid, home};
        meth.invoke(null, new Object[]{params});
        if (args != null && args.contains("MonitorMode")) {
            out.println("Starting seperate AzulInspector JVM in Monitor Mode");
            ProcessBuilder pb = new ProcessBuilder("bash", "runAgentMode.sh");
            Map<String, String> env = pb.environment();
            if (port != null) {
                env.put("ZVROBOTPort", port[1]);
                out.println("Starting seperate ZVRobot JVM using port " + port[1]);
            }
            env.remove("_JAVA_OPTIONS");
            pb.directory(new File(aid));
            Process p = pb.start();
            out.println("New process started ");
        }
        out.println("End of Agent execution");
    }

    static {
        out.setPrefix("[AzulInspector] ");
    }
}

