/*
 * Decompiled with CFR 0.152.
 */
package azulinspector;

import azulinspector.actions.AzulInspectorAction;
import azulinspector.actions.DumpEnvironmentAction;
import azulinspector.actions.PrintVMDetailsAction;
import azulinspector.actions.SafetyCheckAction;
import azulinspector.commands.CommandsGroup;
import azulinspector.commands.CommandsGroupRunAction;
import azulinspector.mbeans.MBeansList;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.mbeans.PrintMBeansAction;
import azulinspector.monitor.AzulInspectorMonitor;
import azulinspector.monitor.GCMonitor;
import azulinspector.monitor.LatencyMonitor;
import azulinspector.monitor.MBeansMonitor;
import azulinspector.monitor.PerformanceMonitor;
import azulinspector.output.PrefixedWriter;
import azulinspector.process.ProcessInfo;
import azulinspector.process.ProcessUtils;
import azulinspector.utils.Globals;
import azulinspector.utils.ScriptWriterSupport;
import azulinspector.utils.Utilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AzulInspector {
    public static final PrefixedWriter out = new PrefixedWriter(System.out);
    public static final PrefixedWriter err = new PrefixedWriter(System.err);
    private static boolean printMBeansFromConfigFile;
    private static boolean dumpAllMBeans;
    private static RunMode runMode;
    private final List<AzulInspectorAction> actions;

    private AzulInspector(List<AzulInspectorAction> actions) {
        this.actions = actions;
    }

    static AzulInspector initMain(String[] args) throws IOException {
        Globals env = AzulInspector.processMainArguments(args);
        List<AzulInspectorAction> actions = AzulInspector.initActions(env);
        return new AzulInspector(actions);
    }

    public void start() {
        block4: for (AzulInspectorAction action : this.actions) {
            switch (runMode) {
                case EXECUTE: {
                    this.runAction(action);
                    continue block4;
                }
                case DUMP_SCRIPT: {
                    this.dumpAction(action);
                    continue block4;
                }
            }
            throw new InternalError();
        }
    }

    static void run_check(Globals globals, boolean run_oscmds) {
        try {
            runMode = RunMode.EXECUTE;
            CommandsGroup.CommandCategory.reset();
            CommandsGroup.CommandCategory.activate(CommandsGroup.CommandCategory.ospid);
            System.setProperty("JCMD", globals.getMBeansSupport() == null ? "true" : "false");
            AzulInspector.setupMetaMode(run_oscmds ? MetaMode.EnvCheck : MetaMode.JVMCheck);
            new AzulInspector(AzulInspector.initActions(globals)).start();
        }
        catch (IOException ex) {
            Logger.getLogger(AzulInspector.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static Globals processMainArguments(String[] args) throws IOException {
        if (args.length == 1) {
            Utilities.outResourceFile(out, "main_usage.txt");
            System.exit(1);
        }
        boolean autodetectJava = Boolean.getBoolean("MonitorJava");
        boolean autodetectZing = Boolean.getBoolean("MonitorZing");
        MBeansSupport mbs = null;
        ProcessInfo javaProcessInfo = null;
        if (args.length > 0) {
            if (autodetectJava || autodetectZing) {
                out.warning("JMX parameters are specified in the command-line -- will NOT perform autodetection");
            }
            mbs = MBeansSupport.init(args[0], args[1]);
        } else {
            boolean usejmx = true;
            boolean jcmd = Boolean.getBoolean("JCMD");
            if (jcmd) {
                usejmx = false;
                String jcmdpid = System.getProperty("JCMDPid");
                if (jcmdpid != null) {
                    javaProcessInfo = ProcessUtils.getLocalProcessInfo(jcmdpid);
                } else if (autodetectJava || autodetectZing) {
                    out.warning("JCMDPid is not specified, will try to autodetect");
                } else {
                    err.println("JCMD mode is enabled, but none of JCMDPid, MonitorJava/MonitorZing was specified. Exiting.");
                    System.exit(1);
                }
            }
            if (javaProcessInfo == null) {
                javaProcessInfo = AzulInspector.autodetectIfRequested();
            }
            if (usejmx) {
                if (javaProcessInfo != null) {
                    Pattern p = Pattern.compile(".*com\\.sun\\.management\\.jmxremote\\.port=([0-9]+).*");
                    Matcher m = p.matcher(javaProcessInfo.getCommandLine());
                    if (m.matches()) {
                        mbs = MBeansSupport.init("localhost", m.group(1));
                    }
                } else {
                    mbs = MBeansSupport.init();
                }
            }
        }
        if (mbs != null && javaProcessInfo == null) {
            String java_pid;
            if (args.length > 3) {
                java_pid = args[3];
            } else {
                String vmName = mbs.getRuntimeBean().getName();
                java_pid = vmName.substring(0, vmName.indexOf(64));
            }
            javaProcessInfo = ProcessUtils.getLocalProcessInfo(java_pid);
        }
        if (javaProcessInfo == null) {
            throw new InternalError("Target java process is not defined!");
        }
        if (args.length > 2) {
            AzulInspector.setupMetaMode(MetaMode.valueOf(args[2]));
        }
        runMode = Boolean.parseBoolean(System.getProperty("GenerateScript", "false")) ? RunMode.DUMP_SCRIPT : RunMode.EXECUTE;
        Globals env = new Globals(javaProcessInfo, mbs);
        if (runMode.equals((Object)RunMode.DUMP_SCRIPT) && !env.isLocal()) {
            throw new IllegalArgumentException("Cannot use DUMP_SCRIPT in non-local environment");
        }
        return env;
    }

    private static void setupMetaMode(MetaMode metaMode) throws UnsupportedOperationException {
        boolean sysQualification = Boolean.getBoolean("SystemQualification");
        printMBeansFromConfigFile = Boolean.getBoolean("PrintMBeans");
        dumpAllMBeans = Boolean.getBoolean("GenerateMBeans");
        switch (metaMode) {
            case Agent: {
                break;
            }
            case JVMCheck: {
                sysQualification = true;
                break;
            }
            case MonitorMode: {
                sysQualification = true;
                CommandsGroup.CommandCategory.activate(CommandsGroup.CommandCategory.osnet, CommandsGroup.CommandCategory.ospid);
                break;
            }
            case EnvCheck: 
            case JDKCheck: {
                sysQualification = true;
                CommandsGroup.CommandCategory.activate(CommandsGroup.CommandCategory.oscalls, CommandsGroup.CommandCategory.oshost, CommandsGroup.CommandCategory.osenv, CommandsGroup.CommandCategory.osnet);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled mode: " + (Object)((Object)metaMode));
            }
        }
        if (sysQualification) {
            CommandsGroup.CommandCategory.activate(CommandsGroup.CommandCategory.monitor, CommandsGroup.CommandCategory.ospid);
            dumpAllMBeans = true;
            printMBeansFromConfigFile = true;
        }
    }

    private static List<AzulInspectorAction> initActions(Globals env) throws IOException {
        MBeansSupport mbs;
        ArrayList<AzulInspectorAction> actionsList = new ArrayList<AzulInspectorAction>();
        actionsList.add(new DumpEnvironmentAction(env));
        if (env.runSafetyCheck) {
            actionsList.add(new SafetyCheckAction());
        }
        if ((mbs = env.getMBeansSupport()) != null) {
            PrintMBeansAction action;
            Object mbeans;
            actionsList.add(PrintVMDetailsAction.init(mbs));
            if (printMBeansFromConfigFile) {
                mbeans = new MBeansList(mbs);
                ((MBeansList)mbeans).addFromConfigFile("azulInspector.cfg");
                action = PrintMBeansAction.init(mbs, (MBeansList)mbeans);
                if (action != null) {
                    actionsList.add(action);
                }
            }
            if (dumpAllMBeans) {
                mbeans = new MBeansList(mbs);
                ((MBeansList)mbeans).addAllAvailable();
                action = PrintMBeansAction.init(mbs, (MBeansList)mbeans);
                if (action != null) {
                    actionsList.add(action);
                }
            }
        }
        for (CommandsGroup group : EnumSet.allOf(CommandsGroup.class)) {
            CommandsGroupRunAction runner = CommandsGroupRunAction.getRunner(env, group);
            if (runner == null) continue;
            actionsList.add(runner);
        }
        AzulInspectorMonitor monitor = AzulInspector.initMonitor(env);
        if (monitor != null) {
            actionsList.add(monitor);
        }
        return actionsList;
    }

    private static AzulInspectorMonitor initMonitor(Globals env) {
        if (Boolean.getBoolean("Latency")) {
            return LatencyMonitor.init(env, Integer.parseInt(System.getProperty("LatencyTime", "2000")), TimeUnit.MILLISECONDS);
        }
        if (env.getMBeansSupport() == null) {
            return null;
        }
        if (Boolean.getBoolean("Watch")) {
            return MBeansMonitor.init(env, 5, TimeUnit.SECONDS);
        }
        if (Boolean.getBoolean("TrendLocal")) {
            return PerformanceMonitor.init(env, 5, TimeUnit.SECONDS);
        }
        if (Boolean.getBoolean("Trend")) {
            return GCMonitor.init(env, Integer.parseInt(System.getProperty("TrendSleep", "250")), TimeUnit.MILLISECONDS);
        }
        return null;
    }

    private static ProcessInfo autodetectIfRequested() {
        boolean autodetectJava = Boolean.getBoolean("MonitorJava");
        boolean autodetectZing = Boolean.getBoolean("MonitorZing");
        if (autodetectJava || autodetectZing) {
            if (autodetectJava && autodetectZing) {
                out.warning("Both MonitorJava and MonitorZing active");
                out.warning("Will search for Zing processes only");
            }
            Collection<Object> java_processes = Collections.emptyList();
            if (autodetectZing) {
                out.println("Locating Zing Processes ...");
                java_processes = Utilities.findZingProcesses(out);
            } else if (autodetectJava) {
                out.println("Locating VM Processes ...");
                java_processes = Utilities.findJavaProcesses(out);
            }
            int java_processes_count = java_processes.size();
            if (java_processes_count == 0) {
                out.warning("No requested VM processes found");
                return null;
            }
            if (java_processes_count > 1) {
                out.warning("Multiple processes detected, will take the first one!");
                out.println();
            }
            return (ProcessInfo)java_processes.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAction(AzulInspectorAction action) {
        String title = action.getDescription();
        int l = Math.max(5, 80 - title.length());
        String dashes = String.format("%" + l + "s", "-").replace(' ', '-');
        out.println();
        out.println("-- " + title + " " + dashes + "  [started " + new Date() + "]");
        out.incOffset();
        err.incOffset();
        try {
            action.run();
        }
        finally {
            out.decOffset();
            err.decOffset();
            out.println("-- " + title + " " + dashes + " [complete " + new Date() + "]");
            out.println();
        }
    }

    private void dumpAction(AzulInspectorAction action) {
        try {
            action.dumpScript(ScriptWriterSupport.getOutputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(AzulInspector.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static enum RunMode {
        EXECUTE,
        DUMP_SCRIPT;

    }

    private static enum MetaMode {
        Agent,
        EnvCheck,
        JDKCheck,
        JVMCheck,
        MonitorMode;

    }
}

