/*
 * Decompiled with CFR 0.152.
 */
package azulinspector;

import azulinspector.AzulInspector;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.output.PrefixedWriter;
import azulinspector.process.ProcessInfo;
import azulinspector.process.ProcessUtils;
import azulinspector.remote.RemoteConnectionInfo;
import azulinspector.utils.Globals;
import azulinspector.utils.JVMInfo;
import azulinspector.utils.Utilities;
import azulinspector.utils.Version;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EnvCheck {
    private static final PrefixedWriter out = new PrefixedWriter(System.out);
    private static final PrefixedWriter err;

    public static void main(String[] args) {
        JVMInfo jvmInfo = JVMInfo.getDefault();
        out.println("Azul Inspector Environment Check - " + Version.VERSION);
        out.println("Starting execution using " + jvmInfo.displayName());
        RemoteConnectionInfo remoteConnection = RemoteConnectionInfo.get();
        Collection<ProcessInfo> processes = EnvCheck.locateJavaInstances(remoteConnection);
        boolean run_oscmds = true;
        for (ProcessInfo process : processes) {
            MBeansSupport mbeans;
            block9: {
                out.println();
                out.println("Inspecting process " + process.summary());
                mbeans = null;
                try {
                    String jmxPort;
                    if (remoteConnection != null) {
                        jmxPort = MBeansSupport.detectJMXPort(process);
                        if (jmxPort != null) {
                            mbeans = MBeansSupport.init(remoteConnection.getHost(), jmxPort);
                        }
                        break block9;
                    }
                    if (process.getPID().equals(jvmInfo.getPID())) {
                        if (processes.size() > 1) {
                            out.println("Found myself, no need to inspect - there are more processes to look at.");
                            continue;
                        }
                        out.println("Found myself and this is the only java process running on the host - will perform an inspection using JMX only.");
                        mbeans = MBeansSupport.init();
                        break block9;
                    }
                    jmxPort = MBeansSupport.detectJMXPort(process);
                    if (jmxPort == null) break block9;
                    mbeans = MBeansSupport.init("localhost", jmxPort);
                }
                catch (IOException ex) {
                    Logger.getLogger(EnvCheck.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
            }
            Globals globals = new Globals(process, mbeans);
            if (mbeans != null) {
                out.println("CALL AzulInspector via JMX");
            } else {
                out.println("CALL AzulInspector via Java Commands " + process.getPID() + " " + globals.getJavaHome());
            }
            AzulInspector.run_check(globals, run_oscmds);
            run_oscmds = false;
        }
        out.println("END");
    }

    private static Collection<ProcessInfo> locateJavaInstances(RemoteConnectionInfo connection) {
        Collection<ProcessInfo> processes;
        String pid = System.getProperty("JustPid", null);
        if (pid == null) {
            processes = Utilities.findJavaProcesses(out);
        } else {
            out.println("Locating Java instance by pid " + pid);
            processes = Arrays.asList(ProcessUtils.getProcessInfo(connection, pid));
        }
        out.println("Completed finding Java instances");
        return processes;
    }

    static {
        out.setPrefix("[EnvCheck] ");
        err = out;
    }
}

