/*
 * Decompiled with CFR 0.152.
 */
package azulinspector;

import azulinspector.output.PrefixedWriter;
import azulinspector.utils.JVMInfo;
import azulinspector.utils.Utilities;
import azulinspector.utils.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

public final class MonitorMode {
    private static final PrefixedWriter out;
    private static final PrefixedWriter err;
    private static final String[] MMpcmd;
    private static final String[] MMpcmdO;
    private static int MMpcmdOUsed;
    private static Object line;

    public static void EXECCMD(int i, String justpid) {
        int o = 0;
        if (i == 1 && !MMpcmd[i].contains(justpid)) {
            MonitorMode.MMpcmd[i] = MMpcmd[i] + justpid;
        }
        out.println(new Date() + " Calling Command - " + MMpcmd[i]);
        try {
            String line1;
            Process p = Runtime.getRuntime().exec("" + MMpcmd[i]);
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            BufferedReader c = new BufferedReader(new InputStreamReader(stdout));
            while ((line1 = c.readLine()) != null) {
                out.println("Found = [" + o + "] " + line1);
                if (line1.contains("azulinspector.EnvCheck") | line1.contains("azulinspector.MonitorMode") | line1.contains("ZVRobot")) {
                    out.println("Found a AzulInspector or ZVRobot process");
                    continue;
                }
                MonitorMode.MMpcmdO[o] = line1;
                ++o;
            }
            BufferedReader c1 = new BufferedReader(new InputStreamReader(stderr));
            while ((line = c1.readLine()) != null) {
            }
            p.getOutputStream().close();
            p.getErrorStream().close();
            p.getInputStream().close();
            p.waitFor();
            c.close();
            c1.close();
            System.out.println(p.exitValue() + "\n");
            Thread.sleep(1000L);
        }
        catch (IOException e) {
            err.println("Command not found or incorrect user privileges");
        }
        catch (InterruptedException e) {
            err.println("Command not found or incorrect user privileges");
        }
        out.println("Found " + o + " Java instances");
        MMpcmdOUsed = o;
    }

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, InterruptedException {
        if (args.length == 1) {
            Utilities.outResourceFile(err, "monitor_usage.txt");
            return;
        }
        JVMInfo jvmInfo = JVMInfo.getDefault();
        out.println("Starting execution using " + jvmInfo.displayName());
        out.println("Azul Inspector Monitor Mode - " + Version.VERSION);
        if ((double)jvmInfo.getSpecVersion() < 1.6) {
            err.println("Sorry this requires a JDK 1.6+ runtime, you are using " + jvmInfo.getVersion());
            return;
        }
        Integer justpid = Integer.parseInt(System.getProperty("JustPid", "0"));
        Integer SleepTime = Integer.parseInt(System.getProperty("SleepTime", "60000"));
        Integer NumIterations = Integer.parseInt(System.getProperty("NumIterations", "60"));
        for (int loop = 1; loop <= NumIterations; ++loop) {
            if (justpid == 0) {
                out.println("Locating Java instances");
                MonitorMode.EXECCMD(0, "");
            } else {
                out.println("Locating single Java instance by pid " + justpid);
                MonitorMode.EXECCMD(1, justpid.toString());
            }
            out.println("Completed finding Java instances " + MMpcmdOUsed);
            if (MMpcmdOUsed < 1) {
                err.println("Monitor Mode terminating no running JVM found.");
                Runtime.getRuntime().exit(0);
                return;
            }
            for (int n2 = 0; n2 < MMpcmdOUsed; ++n2) {
                String targetJVMPort;
                out.println("evaluating " + n2 + " " + MMpcmdO[n2]);
                if (MMpcmdO[n2].contains("azulinspector.EnvCheck") | MMpcmdO[n2].contains("azulinspector.MonitorMode")) {
                    out.println("Found AzulInspector process - skipping");
                    continue;
                }
                String[] azPid = MMpcmdO[n2].split("\\s+", 8);
                out.println("Looking for JMX " + MMpcmdO[n2]);
                if (MMpcmdO[n2].contains("com.sun.management.jmxremote.port")) {
                    out.println("JVM is using JMX");
                    String[] az = MMpcmdO[n2].split("com\\.sun\\.management\\.jmxremote\\.port=", 5);
                    int azC = az[1].indexOf(" ");
                    targetJVMPort = az[1].substring(0, azC);
                    out.println("Port is " + targetJVMPort);
                } else {
                    targetJVMPort = "0";
                    out.println("Port is " + targetJVMPort);
                }
                out.println("Invoking Inspector");
                Class<?> cls = Class.forName("azulinspector.Main");
                Method meth = cls.getMethod("main", String[].class);
                String[] params = new String[]{"127.0.0.1", targetJVMPort, "MonitorMode", azPid[1]};
                meth.invoke(null, new Object[]{params});
            }
            out.println("Monitor Mode End, iteration: " + loop + ", Sleeping: " + SleepTime + "ms");
            Thread.sleep(SleepTime.intValue());
        }
        out.println("Monitor Mode Completed due to loop expiration ");
    }

    static {
        err = out = new PrefixedWriter(System.out);
        out.setPrefix("[MonMode] ");
        MMpcmd = new String[]{"ps -fC java -C jsvc --no-heading", "ps -f --no-heading -p"};
        MMpcmdO = new String[200];
        MMpcmdOUsed = 0;
    }
}

