/*
 * Decompiled with CFR 0.152.
 */
package azulinspector;

import azulinspector.utils.Utilities;
import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class Old_Main {
    private static String[] temp;
    private static int exceptionCount;
    private static Object a1;
    private static PrintWriter printWriter;

    public static void main(String[] args) throws InterruptedException {
        String line;
        BufferedReader stderrReader;
        BufferedReader stdoutReader;
        StreamGobbler stderr;
        Session sess;
        Connection conn;
        Object p;
        String java_home;
        BufferedReader c1;
        BufferedReader c;
        InputStream stderr2;
        InputStream stdout;
        Process p2;
        String filter;
        Integer latencytime;
        boolean latency;
        String distro;
        boolean docker;
        String rmtpass;
        String rmtuser;
        String rmthost;
        boolean rmtprobe;
        String xenpass;
        String xenuser;
        String xenhost;
        boolean xenprobe;
        String kvmpass;
        String kvmuser;
        String kvmhost;
        boolean kvmprobe;
        String esxpass;
        String esxuser;
        String esxhost;
        boolean esxprobe;
        Integer rjcmdpid;
        boolean rjcmd;
        Integer jcmdpid;
        boolean jcmd;
        boolean monitor;
        boolean osagent;
        boolean osenv;
        boolean oshost;
        boolean ospid;
        boolean osnet;
        boolean oscalls;
        String zing_home;
        String jvmpid;
        block220: {
            String[][] pcmd;
            String targetJVMPort;
            String targetJVMIP;
            String line2;
            System.out.println("Azul Inspector - version 41");
            System.out.println("\nThis is a remote client, that will connect to the remote JVM and print out information about the runtime environment");
            System.out.println("\nRun date: " + new Date() + "\n");
            jvmpid = "";
            zing_home = "";
            if (args.length == 1) {
                System.out.println("\nNo parameters passed.");
                Utilities.outResourceFile(new PrintWriter(System.out), "main_usage.txt");
                return;
            }
            oscalls = Boolean.parseBoolean(System.getProperty("NativeCallsEnabled", "false"));
            osnet = Boolean.parseBoolean(System.getProperty("NetworkEnabled", "false"));
            ospid = Boolean.parseBoolean(System.getProperty("ProcessEnabled", "false"));
            oshost = Boolean.parseBoolean(System.getProperty("HostEnabled", "false"));
            osenv = Boolean.parseBoolean(System.getProperty("EnvironmentEnabled", "false"));
            osagent = Boolean.parseBoolean(System.getProperty("AgentEnabled", "false"));
            boolean printmbeans = Boolean.parseBoolean(System.getProperty("PrintMBeans", "false"));
            boolean genmbeans = Boolean.parseBoolean(System.getProperty("GenerateMBeans", "false"));
            boolean sysqualification = Boolean.parseBoolean(System.getProperty("SystemQualification", "false"));
            monitor = Boolean.parseBoolean(System.getProperty("Monitor", "false"));
            boolean monitorzing = Boolean.parseBoolean(System.getProperty("MonitorZing", "false"));
            boolean monitorjava = Boolean.parseBoolean(System.getProperty("MonitorJava", "false"));
            boolean trend = Boolean.parseBoolean(System.getProperty("Trend", "false"));
            Integer trendSleep = Integer.parseInt(System.getProperty("TrendSleep", "250"));
            boolean trendlocal = Boolean.parseBoolean(System.getProperty("TrendLocal", "false"));
            boolean watch = Boolean.parseBoolean(System.getProperty("Watch", "false"));
            jcmd = Boolean.parseBoolean(System.getProperty("JCMD", "false"));
            jcmdpid = Integer.parseInt(System.getProperty("JCMDPid", "0"));
            rjcmd = Boolean.parseBoolean(System.getProperty("RJCMD", "false"));
            rjcmdpid = Integer.parseInt(System.getProperty("RJCMDPid", "0"));
            esxprobe = Boolean.parseBoolean(System.getProperty("ESXProbe", "false"));
            esxhost = System.getProperty("ESXHost", "");
            esxuser = System.getProperty("ESXUser", "");
            esxpass = System.getProperty("ESXPass", "");
            kvmprobe = Boolean.parseBoolean(System.getProperty("KVMProbe", "false"));
            kvmhost = System.getProperty("KVMHost", "");
            kvmuser = System.getProperty("KVMUser", "");
            kvmpass = System.getProperty("KVMPass", "");
            xenprobe = Boolean.parseBoolean(System.getProperty("XENProbe", "false"));
            xenhost = System.getProperty("XENHost", "");
            xenuser = System.getProperty("XENUser", "");
            xenpass = System.getProperty("XENPass", "");
            rmtprobe = Boolean.parseBoolean(System.getProperty("RMTProbe", "false"));
            rmthost = System.getProperty("RMTHost", "");
            rmtuser = System.getProperty("RMTUser", "");
            rmtpass = System.getProperty("RMTPass", "");
            docker = Boolean.parseBoolean(System.getProperty("Docker", "false"));
            distro = System.getProperty("Distro");
            boolean forcegc = Boolean.parseBoolean(System.getProperty("ForceGC", "false"));
            boolean showdeadlocks = Boolean.parseBoolean(System.getProperty("ShowDeadlocks", "false"));
            boolean licensed = Boolean.parseBoolean(System.getProperty("Licensed", "false"));
            latency = Boolean.parseBoolean(System.getProperty("Latency", "false"));
            latencytime = Integer.parseInt(System.getProperty("LatencyTime", "2000"));
            boolean dumpall = Boolean.parseBoolean(System.getProperty("DumpAll", "false"));
            boolean safetycheck = Boolean.parseBoolean(System.getProperty("SafetyCheck", "true"));
            filter = System.getProperty("Filter", "");
            String jmxuser = System.getProperty("JMXUser", "");
            String jmxpass = System.getProperty("JMXPass", "");
            if (safetycheck) {
                int safety = 2;
                float memtotal = 0.0f;
                float memfree = 0.0f;
                try {
                    p2 = Runtime.getRuntime().exec("cat /proc/meminfo");
                    stdout = p2.getInputStream();
                    stderr2 = p2.getErrorStream();
                    c = new BufferedReader(new InputStreamReader(stdout));
                    while ((line2 = c.readLine()) != null) {
                        String[] a;
                        if (line2.matches("AnonHugePages.*") && !(a = line2.split("\\s+"))[1].matches("0")) {
                            System.out.print("Found invalid AnonHugePages ");
                            System.out.println(line2);
                            --safety;
                        }
                        if (line2.matches("HugePages_Total.*") && !(a = line2.split("\\s+"))[1].matches("0")) {
                            System.out.print("Found invalid HugePages setting ");
                            System.out.println(line2);
                            --safety;
                        }
                        if (line2.matches("MemTotal.*") && (a = line2.split("\\s+"))[1].matches("\\d+]")) {
                            memtotal = Float.valueOf(a[1]).floatValue();
                        }
                        if (!line2.matches("MemFree.*") || !(a = line2.split("\\s+"))[1].matches("\\d+")) continue;
                        memfree = Float.valueOf(a[1]).floatValue();
                    }
                    c1 = new BufferedReader(new InputStreamReader(stderr2));
                    while ((line2 = c1.readLine()) != null) {
                        System.out.println(line2);
                    }
                    p2.getOutputStream().close();
                    p2.getErrorStream().close();
                    p2.getInputStream().close();
                    stdout.close();
                    stderr2.close();
                    p2.waitFor();
                    c.close();
                    c1.close();
                    if (100.0f * (memfree / memtotal) < 20.0f) {
                        System.out.println("A limited amount (<20%) of free physical memory is availabe - Program terminating");
                        System.exit(-1);
                    }
                }
                catch (Exception e) {
                    System.out.println("Failed safety check " + e);
                }
                if (safety == 0) {
                    System.out.println("A dangerous combination of AnonHugePages and HughPages - Program terminating");
                    System.exit(-1);
                }
            }
            if (args.length == 0) {
                targetJVMIP = "Local-Client-Mode";
                targetJVMPort = "0";
            } else {
                targetJVMIP = args[0];
                targetJVMPort = args[1];
            }
            if (sysqualification) {
                oscalls = true;
                oshost = true;
                osenv = true;
                genmbeans = true;
            }
            if (monitor) {
                osnet = true;
                ospid = true;
                printmbeans = true;
            }
            if (args.length > 2) {
                if (args[2].matches("EnvCheck")) {
                    oscalls = true;
                    oshost = true;
                    osenv = true;
                    monitor = true;
                    osnet = true;
                    ospid = true;
                    printmbeans = true;
                    genmbeans = true;
                }
                if (args[2].matches("JVMCheck")) {
                    monitor = true;
                    printmbeans = true;
                    genmbeans = true;
                    ospid = true;
                }
                if (args[2].matches("Agent")) {
                    osagent = true;
                    jvmpid = args[3];
                }
                if (args[2].matches("JDKCheck")) {
                    if (targetJVMIP.matches("127.0.0.1")) {
                        oscalls = true;
                        oshost = true;
                        osenv = true;
                        monitor = true;
                        osnet = true;
                        ospid = true;
                        monitor = true;
                        printmbeans = true;
                        genmbeans = true;
                        jcmd = true;
                        jcmdpid = Integer.parseInt(args[3]);
                        targetJVMIP = "Local-Client-Mode";
                        targetJVMPort = "0";
                        zing_home = args[4];
                    } else {
                        monitor = true;
                        printmbeans = true;
                        genmbeans = true;
                        jcmd = true;
                        ospid = true;
                        jcmdpid = Integer.parseInt(args[3]);
                        targetJVMIP = "Local-Client-Mode";
                        targetJVMPort = "0";
                        zing_home = args[4];
                    }
                }
                if (args[2].matches("MonitorMode")) {
                    monitor = true;
                    ospid = true;
                    printmbeans = true;
                    genmbeans = true;
                    if (args[1].matches("0")) {
                        jcmd = true;
                        jcmdpid = Integer.parseInt(args[3]);
                    } else {
                        targetJVMIP = args[0];
                        targetJVMPort = args[1];
                    }
                }
            }
            if (distro != null) {
                System.out.println("Using context sensitive commands based on distribution: " + distro);
            }
            if (monitorzing) {
                System.out.println("Locating Zing instance");
                pcmd = new String[][]{{"", "zing-ps"}, {"", "ps  -fP " + jvmpid + " --no-heading"}};
                System.out.println("Invoking zing-ps command " + jvmpid);
                for (int n = 0; n < pcmd.length; ++n) {
                    if (!pcmd[n][0].matches("")) continue;
                    System.out.println(new Date() + " Calling Zing Command - [ZCMD] " + n + " " + pcmd[n][1]);
                    try {
                        p2 = Runtime.getRuntime().exec("" + pcmd[n][1]);
                        stdout = null;
                        stderr2 = null;
                        stdout = p2.getInputStream();
                        stderr2 = p2.getErrorStream();
                        c = new BufferedReader(new InputStreamReader(stdout));
                        while ((line2 = c.readLine()) != null) {
                            String[] az;
                            if (n == 0 && (az = line2.split("\\s+", 3)).length > 2 && az[2].contains("java")) {
                                System.out.println("[ZCMD] - Found Zing Java Instance " + az[2]);
                                pcmd[1][1] = "ps -fp " + az[1] + " --no-heading";
                                jcmdpid = Integer.parseInt(az[1]);
                                System.out.println("[ZCMD] - Found Zing Java Instance " + jcmdpid);
                                zing_home = az[2].substring(0, az[2].lastIndexOf("/bin/java"));
                            }
                            if (n != 1) continue;
                            if (line2.contains("com.sun.management.jmxremote.port")) {
                                System.out.println("[ZCMD] Zing JVM is using JMX");
                                az = line2.split("com\\.sun\\.management\\.jmxremote\\.port=", 5);
                                int azC = az[1].indexOf(" ");
                                targetJVMPort = az[1].substring(0, azC);
                                targetJVMIP = "127.0.0.1";
                                System.out.println("[ZCMD] Port " + targetJVMPort + " ending at " + azC);
                                continue;
                            }
                            System.out.println("[ZCMD] Cannot find JMX Port, setting up JCMD functions");
                            jcmd = true;
                        }
                        c1 = new BufferedReader(new InputStreamReader(stderr2));
                        while ((line2 = c1.readLine()) != null) {
                            System.out.println("[ZCMD " + n + "] " + line2);
                        }
                        p2.getOutputStream().close();
                        p2.getErrorStream().close();
                        p2.getInputStream().close();
                        stdout.close();
                        stderr2.close();
                        p2.waitFor();
                        c.close();
                        c1.close();
                        System.out.println("[ZCMD " + n + "] " + p2.exitValue() + "\n");
                        monitor = true;
                        osnet = true;
                        ospid = true;
                        printmbeans = true;
                        genmbeans = true;
                        System.out.println("[ZCMD " + n + "] " + p2.exitValue() + "\n");
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Command not found or incorrect user privileges");
                    }
                }
                System.out.println("End of Zing Command Collection");
            }
            if (monitorjava) {
                System.out.println("Locating Java instance");
                pcmd = new String[][]{{"", "ps -C java -C jsvc --no-heading"}, {"", "ps  -fP " + jvmpid + " --no-heading"}};
                System.out.println("Invoking ps -ef command " + jvmpid);
                for (int n = 0; n < pcmd.length; ++n) {
                    if (!pcmd[n][0].matches("")) continue;
                    System.out.println(new Date() + " Calling Command - [JCAM] " + n + " " + pcmd[n][1]);
                    try {
                        p2 = Runtime.getRuntime().exec("" + pcmd[n][1]);
                        stdout = null;
                        stderr2 = null;
                        stdout = p2.getInputStream();
                        stderr2 = p2.getErrorStream();
                        c = new BufferedReader(new InputStreamReader(stdout));
                        while ((line2 = c.readLine()) != null) {
                            String[] az;
                            if (n == 0) {
                                az = line2.split("\\W+|\\s+", 5);
                                if (az[0].isEmpty()) {
                                    for (int p1 = 1; p1 < az.length; ++p1) {
                                        if (az[p1].isEmpty()) continue;
                                        az[0] = az[p1];
                                        break;
                                    }
                                }
                                if (az.length > 2) {
                                    System.out.println("[JCAM] - Found Java Instance " + az[0]);
                                    if (jcmdpid == 0) {
                                        jcmdpid = Integer.parseInt(az[0]);
                                        pcmd[1][1] = "ps -fp " + az[0] + " --no-heading";
                                    }
                                }
                            }
                            if (n == 1) {
                                if (line2.contains("com.sun.management.jmxremote.port")) {
                                    System.out.println("[JCAM] Zing JVM is using JMX");
                                    az = line2.split("com\\.sun\\.management\\.jmxremote\\.port=", 5);
                                    int azC = az[1].indexOf(" ");
                                    targetJVMPort = az[1].substring(0, azC);
                                    targetJVMIP = "127.0.0.1";
                                    System.out.println("[JCAM] Port " + targetJVMPort + " ending at " + azC);
                                    pcmd[2][1] = "java -DMonitor=true -jar azulinspector.jar 127.0.0.1 " + targetJVMPort;
                                } else {
                                    System.out.println("[JCAM] Cannot find JMX Port, setting up JCMD functions");
                                    zing_home = line2.substring(line2.indexOf("/"), line2.lastIndexOf("/bin/java"));
                                    jcmd = true;
                                }
                            }
                            if (n != 2) continue;
                            System.out.println(line2);
                        }
                        c1 = new BufferedReader(new InputStreamReader(stderr2));
                        while ((line2 = c1.readLine()) != null) {
                            System.out.println("[JCAM " + n + "] " + line2);
                        }
                        p2.getOutputStream().close();
                        p2.getErrorStream().close();
                        p2.getInputStream().close();
                        stdout.close();
                        stderr2.close();
                        p2.waitFor();
                        c.close();
                        c1.close();
                        System.out.println("[JCAM " + n + "] " + p2.exitValue() + "\n");
                        monitor = true;
                        osnet = true;
                        ospid = true;
                        printmbeans = true;
                        genmbeans = true;
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Command not found or incorrect user privileges");
                    }
                }
                monitor = true;
                osnet = true;
                ospid = true;
                printmbeans = true;
                genmbeans = true;
                System.out.println("End of Java Command Collection");
            }
            System.out.println("\nTarget JVM IP " + targetJVMIP);
            System.out.println("Target JVM port " + targetJVMPort);
            System.out.println("NativeCallsEnabled: " + oscalls);
            System.out.println("ProcessEnabled " + ospid);
            System.out.println("HostEnabled " + oshost);
            System.out.println("EnvironmentEnabled " + osenv);
            System.out.println("PrintMBeans " + printmbeans);
            System.out.println("GenerateMBeans " + genmbeans);
            System.out.println("SystemQualification " + sysqualification);
            System.out.println("Monitor " + monitor);
            System.out.println("MonitorZing " + monitorzing);
            System.out.println("MonitorJava " + monitorjava);
            System.out.println("Trend " + trend);
            System.out.println("TrendSleep " + trendSleep);
            System.out.println("TrendLocal " + trendlocal);
            System.out.println("Watch " + watch);
            System.out.println("JCMD " + jcmd + " PID " + jcmdpid);
            System.out.println("RJCMD " + rjcmd + " PID " + rjcmdpid);
            System.out.println("ESXProbe " + esxprobe + " ESXHost " + esxhost + " ESXUser " + esxuser);
            System.out.println("KVMProbe " + kvmprobe + " KVMHost " + kvmhost + " KVMUser " + kvmuser);
            System.out.println("XENProbe " + xenprobe + " XENHost " + xenhost + " XENUser " + xenuser);
            System.out.println("RMTProbe " + rmtprobe + " RMTHost " + rmthost + " RMTUser " + rmtuser);
            System.out.println("Docker " + docker);
            System.out.println("Latency " + latency + " LatencyTime " + latencytime);
            java_home = "";
            if (!(jcmd || rjcmd || osagent)) {
                int mbeansize = 10000 + (args.length - 2);
                int mbeanused = 0;
                String[] mbeans = new String[mbeansize];
                if (args.length > 3) {
                    for (int n = 3; n < args.length; ++n) {
                        mbeans[mbeanused] = args[n];
                        ++mbeanused;
                    }
                    System.out.println("MBean size " + mbeansize + " Used " + mbeanused);
                }
                try {
                    MBeanServerConnection jmxc;
                    if (!jmxpass.isEmpty() && !jmxuser.isEmpty()) {
                        System.out.println("Connecting using JMX user " + jmxuser + " for authentication ");
                        HashMap<String, String[]> env = new HashMap<String, String[]>();
                        String[] credentials = new String[]{"monitorRole", "monitorpassword"};
                        env.put("jmx.remote.credentials", credentials);
                        JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + targetJVMIP + ":" + targetJVMPort + "/jmxrmi");
                        JMXConnector connector = JMXConnectorFactory.connect(address, env);
                        jmxc = connector.getMBeanServerConnection();
                    } else if (targetJVMIP.matches("Local-Client-Mode")) {
                        System.out.println("Using Local Host");
                        jmxc = ManagementFactory.getPlatformMBeanServer();
                    } else {
                        System.out.println("Using Remote Host " + targetJVMIP + ":" + targetJVMPort);
                        JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + targetJVMIP + ":" + targetJVMPort + "/jmxrmi");
                        JMXConnector connector = JMXConnectorFactory.connect(address);
                        jmxc = connector.getMBeanServerConnection();
                    }
                    System.out.println("\nDomains:");
                    Object[] domains = jmxc.getDomains();
                    Arrays.sort(domains);
                    for (Object domain : domains) {
                        System.out.println("\tDomain = " + (String)domain);
                    }
                    System.out.println("\nMBeanServer default domain = " + jmxc.getDefaultDomain());
                    System.out.println("\nMBean count = " + jmxc.getMBeanCount());
                    System.out.println("\nQuery MBeanServer MBeans:");
                    TreeSet<ObjectName> names = new TreeSet<ObjectName>(jmxc.queryNames(null, null));
                    int beanmax = 10000;
                    for (ObjectName name : names) {
                        System.out.println("\tObjectName = " + name);
                        if (genmbeans) {
                            if (mbeanused >= beanmax) {
                                System.out.println("Warning MBean count greater than 10,000 - sampling stops at limit. MBeanUsed =" + mbeanused + " BeanMax = " + beanmax);
                            } else {
                                mbeans[mbeanused] = name.toString();
                                ++mbeanused;
                            }
                        }
                        if (!trendlocal) continue;
                        if (mbeanused >= beanmax) {
                            System.out.println("Warning MBean count greater than 10,000 - sampling stops . MBeanUsed =" + mbeanused + " BeanMax = " + beanmax);
                            continue;
                        }
                        if (!name.toString().contains("GarbageCollector")) continue;
                        mbeans[mbeanused] = name.toString();
                        ++mbeanused;
                    }
                    RuntimeMXBean remoteRuntime = ManagementFactory.newPlatformMXBeanProxy(jmxc, "java.lang:type=Runtime", RuntimeMXBean.class);
                    System.out.println("\nRuntime Details");
                    System.out.print("\tJVM Args: " + remoteRuntime.getInputArguments());
                    System.out.println("\tBootClassPath: " + remoteRuntime.getBootClassPath());
                    System.out.println("\tClasspath: " + remoteRuntime.getClassPath());
                    System.out.println("\tLibraryPath: " + remoteRuntime.getLibraryPath());
                    System.out.println("\tName: " + remoteRuntime.getName());
                    jvmpid = remoteRuntime.getName();
                    temp = jvmpid.split("@");
                    jvmpid = temp[0];
                    System.out.println("\tSpecName: " + remoteRuntime.getSpecName());
                    System.out.println("\tSpecVersion: " + remoteRuntime.getSpecVersion());
                    System.out.println("\tVM Name: " + remoteRuntime.getVmName());
                    System.out.println("\tVM Version: " + remoteRuntime.getVmVersion());
                    System.out.println("\tVM Vendor: " + remoteRuntime.getVmVendor());
                    System.out.println("\tUpTime: " + remoteRuntime.getUptime());
                    System.out.println("\tSystem Properties: ");
                    Map<String, String> sysprop = remoteRuntime.getSystemProperties();
                    for (String key : sysprop.keySet()) {
                        System.out.println("\t\t" + key.toString() + " = " + sysprop.get(key));
                        if (!key.toString().matches("sun.java.launcher.pid")) continue;
                        if (jvmpid.matches("")) {
                            System.out.println("\tWARNING: runtime pid is " + jvmpid + " ");
                        }
                        jvmpid = sysprop.get(key);
                        System.out.println("\tlauncher pid is this process " + jvmpid);
                    }
                    OperatingSystemMXBean remoteOperatingSystem = ManagementFactory.newPlatformMXBeanProxy(jmxc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
                    System.out.println("\nOperating System Details");
                    System.out.println("\tArcitecture: " + remoteOperatingSystem.getArch());
                    System.out.println("\tName: " + remoteOperatingSystem.getName());
                    System.out.println("\tVersion: " + remoteOperatingSystem.getVersion());
                    System.out.println("\tProcessors: " + remoteOperatingSystem.getAvailableProcessors());
                    System.out.println("\tSystem Load Average: " + remoteOperatingSystem.getSystemLoadAverage());
                    ClassLoadingMXBean ClassLoadingSystem = ManagementFactory.newPlatformMXBeanProxy(jmxc, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
                    System.out.println("\nClassloader Details");
                    System.out.println("\tClassLoader Count: " + ClassLoadingSystem.getLoadedClassCount());
                    System.out.println("\tTotal: " + ClassLoadingSystem.getTotalLoadedClassCount());
                    System.out.println("\tUnloaded: " + ClassLoadingSystem.getUnloadedClassCount());
                    ThreadMXBean thread = ManagementFactory.newPlatformMXBeanProxy(jmxc, "java.lang:type=Threading", ThreadMXBean.class);
                    System.out.println("\nThread Details");
                    System.out.println("\tThread Count: " + thread.getThreadCount());
                    System.out.println("\tPeak Count: " + thread.getPeakThreadCount());
                    System.out.println("\tDaemon Threads: " + thread.getDaemonThreadCount());
                    if (showdeadlocks) {
                        ThreadInfo[] infos;
                        System.out.println("\tDeadLocked: " + thread.findDeadlockedThreads());
                        System.out.println("\tMonitor Deadlock: " + thread.findMonitorDeadlockedThreads());
                        System.out.println("\tThreadDump: ");
                        for (ThreadInfo info : infos = thread.dumpAllThreads(true, true)) {
                            System.out.println("[ThreadDump] ID: " + info.getThreadId() + " Name: " + info.getThreadName() + " State: " + (Object)((Object)info.getThreadState()));
                            StackTraceElement[] elems = info.getStackTrace();
                            for (int i = 0; i < elems.length; ++i) {
                                System.out.println("[ThreadDump] " + elems[i].toString());
                            }
                        }
                    }
                    MemoryMXBean MemoryPool = ManagementFactory.newPlatformMXBeanProxy(jmxc, "java.lang:type=Memory", MemoryMXBean.class);
                    System.out.println("\nMemory Details");
                    System.out.println("\tHeap Usage: " + MemoryPool.getHeapMemoryUsage());
                    System.out.println("\tNonHeap Usage: " + MemoryPool.getNonHeapMemoryUsage());
                    if (forcegc) {
                        System.out.println("\nRemote GC invoked - You might need to specify -XX:-DisableExplicitGC");
                        System.out.println("\nMemory Details");
                        System.out.println("\tHeap Usage: " + MemoryPool.getHeapMemoryUsage());
                        MemoryPool.gc();
                        System.gc();
                        System.out.println("\tNonHeap Usage: " + MemoryPool.getNonHeapMemoryUsage());
                    }
                    if (trend) {
                        System.out.println("Starting Trending analysis");
                        System.out.println("date: " + new Date());
                        System.out.println("Using sleep time of " + trendSleep + " use Control + C to terminate");
                        long memThisMax = 0L;
                        long memLastMax = 0L;
                        long memThisUsed = 0L;
                        long memLastUsed = 0L;
                        long memUsed = 0L;
                        int memcollection = 0;
                        long delay = 0L;
                        long oldtime = remoteRuntime.getUptime();
                        long sample = 0L;
                        long ratetotal = 0L;
                        PrintWriter out = new PrintWriter(new FileWriter("azulInspectorTrend.log"));
                        out.println("Starting Trend on " + remoteRuntime.getVmName() + " - " + remoteRuntime.getVmVersion() + new Date());
                        System.out.println("Starting Trend on " + remoteRuntime.getVmName() + " - " + remoteRuntime.getVmVersion() + new Date());
                        out.println("Time,\t\tRate,\t\tChurn,\t\tAve,\t\tLoad,\t\tThreads,\t\tChange,\t\tDelay,\t\tResponse");
                        System.out.println("Time,\t\tRate,\t\tChurn,\t\tAve,\t\tLoad,\t\tThreads,\t\tChange,\t\tDelay,\t\tResponse");
                        while (true) {
                            long uptime = remoteRuntime.getUptime();
                            delay = uptime - oldtime - (long)trendSleep.intValue();
                            oldtime = uptime;
                            MemoryUsage mem = MemoryPool.getHeapMemoryUsage();
                            memThisUsed = mem.getUsed();
                            if (memThisUsed >= memLastUsed) {
                                memUsed = Math.abs(memLastUsed - memThisUsed);
                                memLastUsed = memThisUsed;
                                memcollection = 0;
                            } else if (memThisUsed < memLastUsed) {
                                memUsed = memLastUsed - memThisUsed;
                                memLastUsed = memThisUsed;
                                memcollection = 1;
                            }
                            int appThreads = thread.getThreadCount() - thread.getDaemonThreadCount();
                            long rate = memUsed / (long)trendSleep.intValue();
                            long rateAve = (ratetotal += rate) / ++sample / (long)appThreads;
                            long rateChurn = Math.round(rate / rateAve);
                            System.out.print(uptime + ",\t\t" + rate + ",\t\t" + rateChurn + ",\t\t" + rateAve + ",\t\t" + remoteOperatingSystem.getSystemLoadAverage() + ",\t\t" + appThreads + ",\t\t" + memcollection + ",\t\t" + delay + ",\t\t");
                            out.print(uptime + ",\t\t" + rate + ",\t\t" + rateChurn + ",\t\t" + rateAve + ",\t\t" + remoteOperatingSystem.getSystemLoadAverage() + ",\t\t" + appThreads + ",\t\t" + memcollection + ",\t\t" + delay + ",\t\t");
                            long a = System.nanoTime();
                            long b = remoteRuntime.getUptime();
                            long c2 = System.nanoTime();
                            System.out.println(TimeUnit.NANOSECONDS.toMillis(c2 - a));
                            out.println(TimeUnit.NANOSECONDS.toMillis(c2 - a));
                            Thread.sleep(trendSleep.intValue());
                        }
                    }
                    if (trendlocal) {
                        System.out.println("Starting Trending local analysis ");
                        System.out.println("date: " + new Date());
                        System.out.println("Use Control + C to terminate");
                        long sample = 0L;
                        PrintWriter out = new PrintWriter(new FileWriter("azulInspectorTrendLocal.log"));
                        if (mbeanused > 0) {
                            System.out.println("Attempting to find Collection attribute details for specified GC beans:");
                            for (int n = 0; n < mbeanused; ++n) {
                                System.out.println(mbeans[n]);
                            }
                        }
                        System.out.println("Starting Trend on " + remoteRuntime.getVmName() + " - " + remoteRuntime.getVmVersion() + new Date());
                        System.out.println("Using " + remoteRuntime.getVmVendor() + " ");
                        System.out.println("Time,\tCPU,\tLoad,\tMemory,\t\tGCCount,\tGCTime");
                        while (true) {
                            try {
                                while (true) {
                                    String line3;
                                    System.out.print(remoteRuntime.getUptime() + ",\t");
                                    Process p3 = Runtime.getRuntime().exec("ps -p " + jvmpid + " -o pcpu=");
                                    InputStream stdout2 = null;
                                    stdout2 = p3.getInputStream();
                                    BufferedReader c3 = new BufferedReader(new InputStreamReader(stdout2));
                                    while ((line3 = c3.readLine()) != null) {
                                        System.out.print(line3 + ",\t");
                                    }
                                    p3.getOutputStream().close();
                                    p3.getErrorStream().close();
                                    p3.getInputStream().close();
                                    stdout2.close();
                                    p3.waitFor();
                                    c3.close();
                                    System.out.print(remoteOperatingSystem.getSystemLoadAverage() + ",\t");
                                    System.out.print(MemoryPool.getHeapMemoryUsage().getUsed() + ",\t");
                                    for (int n = 0; n < mbeanused; ++n) {
                                        MBeanAttributeInfo[] attributes;
                                        MBeanInfo info = jmxc.getMBeanInfo(new ObjectName(mbeans[n]));
                                        for (MBeanAttributeInfo attr : attributes = info.getAttributes()) {
                                            if (!attr.getName().contains("Collection")) continue;
                                            System.out.print(mbeans[n].substring(5 + mbeans[n].indexOf("name=")) + " " + attr.getName() + ",");
                                            if (attr.getType().contains("[Ljava.lang.String")) {
                                                String[] a = (String[])jmxc.getAttribute(new ObjectName(mbeans[n]), attr.getName());
                                                for (int m = 0; m < a.length; ++m) {
                                                    System.out.println(a[m] + ",\t");
                                                }
                                                continue;
                                            }
                                            System.out.print(jmxc.getAttribute(new ObjectName(mbeans[n]), attr.getName()) + ",\t");
                                        }
                                    }
                                    ++sample;
                                    System.out.println("");
                                    Thread.sleep(5000L);
                                }
                            }
                            catch (Exception e) {
                                System.out.println("-999 " + new Date());
                                if (++exceptionCount <= 20) continue;
                                return;
                            }
                            break;
                        }
                    }
                    if (watch) {
                        System.out.println("Starting Watch");
                        System.out.println("date: " + new Date());
                        System.out.println("Use Control + C to terminate");
                        long sample = 0L;
                        String cfgfile = "azulInspector.watch";
                        String[] mbeansWatch = new String[mbeansize];
                        int n = mbeanused + 1;
                        System.out.println("\nProcessing MBeans from file " + cfgfile + " position " + mbeanused);
                        try {
                            String strLine;
                            FileInputStream fstream = new FileInputStream(cfgfile);
                            DataInputStream in = new DataInputStream(fstream);
                            MBeanAttributeInfo[] br = new BufferedReader(new InputStreamReader(in));
                            while ((strLine = br.readLine()) != null) {
                                if (strLine.startsWith("!")) {
                                    mbeansWatch[mbeanused] = strLine.substring(1, strLine.length());
                                    System.out.println("Adding attribute to watch [" + mbeanused + "] " + mbeansWatch[mbeanused]);
                                    if (mbeanused >= beanmax) {
                                        System.out.println("Maxbean limit reached - " + mbeanused);
                                        continue;
                                    }
                                    ++mbeanused;
                                    continue;
                                }
                                mbeans[mbeanused] = strLine;
                                System.out.println("Adding probe for [" + mbeanused + "]" + mbeans[mbeanused]);
                            }
                            fstream.close();
                            in.close();
                            br.close();
                            System.out.println("Total mbeans loaded from file " + mbeanused);
                        }
                        catch (Exception e) {
                            System.err.println("Error: " + e.getMessage());
                        }
                        System.out.println("Starting Watch on " + remoteRuntime.getVmName() + " - " + remoteRuntime.getVmVersion() + new Date());
                        System.out.print("Sample, Time");
                        for (n = 0; n < mbeanused; ++n) {
                            System.out.print(", " + mbeansWatch[n]);
                        }
                        System.out.println("");
                        while (true) {
                            try {
                                while (true) {
                                    System.out.print(sample + ", " + remoteRuntime.getUptime());
                                    for (n = 0; n < mbeanused; ++n) {
                                        MBeanAttributeInfo[] attributes;
                                        MBeanInfo info = jmxc.getMBeanInfo(new ObjectName(mbeans[n]));
                                        for (MBeanAttributeInfo attr : attributes = info.getAttributes()) {
                                            if (!attr.getName().contains(mbeansWatch[n])) continue;
                                            System.out.print("," + jmxc.getAttribute(new ObjectName(mbeans[n]), attr.getName()));
                                        }
                                    }
                                    ++sample;
                                    System.out.println("");
                                    Thread.sleep(5000L);
                                }
                            }
                            catch (Exception e) {
                                System.err.println("Error: " + e.getMessage());
                                System.out.println("-999 " + new Date());
                                if (++exceptionCount <= 20) continue;
                                return;
                            }
                            break;
                        }
                    }
                    if (printmbeans) {
                        String cfgfile = "azulInspector.cfg";
                        int n = mbeanused + 1;
                        System.out.println("\nProcessing MBeans from file " + cfgfile + " position " + mbeanused);
                        try {
                            String strLine;
                            FileInputStream fstream = new FileInputStream(cfgfile);
                            DataInputStream in = new DataInputStream(fstream);
                            BufferedReader br = new BufferedReader(new InputStreamReader(in));
                            while ((strLine = br.readLine()) != null) {
                                if (strLine.startsWith("#")) continue;
                                mbeans[mbeanused] = strLine;
                                System.out.println("Adding probe for " + mbeans[mbeanused]);
                                if (mbeanused >= beanmax) {
                                    System.out.println("Maxbean limit reached - " + mbeanused);
                                    continue;
                                }
                                ++mbeanused;
                            }
                            fstream.close();
                            in.close();
                            br.close();
                            System.out.println("Total mbeans loaded from file " + mbeanused);
                        }
                        catch (Exception e) {
                            System.err.println("Error: " + e.getMessage());
                        }
                    }
                    System.out.println("Found " + mbeanused + " MBeans to probe");
                    for (int p4 = 0; p4 < mbeanused; ++p4) {
                        System.out.println("\nAttempting Probe [CFG " + p4 + "] " + mbeans[p4]);
                        try {
                            MBeanAttributeInfo[] attributes;
                            MBeanInfo info = jmxc.getMBeanInfo(new ObjectName(mbeans[p4]));
                            for (MBeanAttributeInfo attr : attributes = info.getAttributes()) {
                                String[] a;
                                if (attr.getType().equalsIgnoreCase("javax.management.openmbean.CompositeData")) {
                                    a = (String[])jmxc.getAttribute(new ObjectName(mbeans[p4]), attr.getName());
                                    int n1 = 0;
                                    int v1 = 0;
                                    String[][] value = new String[100][100];
                                    for (Object tmp : a.values()) {
                                        String[] anum = tmp.toString().split(",", v1);
                                        value[n1][v1] = anum[0];
                                        ++n1;
                                    }
                                    CompositeType b = a.getCompositeType();
                                    ++v1;
                                    n1 = 0;
                                    Iterator<String> it = b.keySet().iterator();
                                    while (it.hasNext()) {
                                        String c4;
                                        value[n1][v1] = c4 = it.next();
                                        ++n1;
                                    }
                                    for (int pv = 0; pv < n1; ++pv) {
                                        System.out.println("\t" + value[pv][1] + " = " + value[pv][0]);
                                    }
                                    continue;
                                }
                                System.out.print("\tName: " + attr.getName());
                                if (attr.getType().contains("[Ljava.lang.String")) {
                                    a = (String[])jmxc.getAttribute(new ObjectName(mbeans[p4]), attr.getName());
                                    for (int m = 0; m < a.length; ++m) {
                                        System.out.println("\t" + a[m]);
                                    }
                                    continue;
                                }
                                System.out.println(" Value: " + jmxc.getAttribute(new ObjectName(mbeans[p4]), attr.getName()));
                            }
                            System.out.println("\nEnd of Probe" + jmxc.queryMBeans(new ObjectName(mbeans[p4]), null));
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("Invalid mbean name at entry " + p4);
                        }
                    }
                    System.out.println("\nRemote JMX connection closed.");
                }
                catch (Exception e) {
                    System.out.println("Exception " + e.getMessage());
                    if (e.getMessage().matches(".*Credentials required.*")) {
                        System.out.println("***********************************************************");
                        System.out.println("Add the parameter -DJMXUser and -DJMXPass to the script.");
                        System.out.println("***********************************************************");
                        Thread.sleep(10000L);
                        return;
                    }
                    e.getStackTrace();
                    e.printStackTrace();
                    if (++exceptionCount <= 20) break block220;
                    return;
                }
            }
        }
        if (jvmpid.matches("")) {
            if (jcmdpid > 0) {
                jvmpid = jcmdpid.toString();
            }
            if (rjcmdpid > 0) {
                jvmpid = rjcmdpid.toString();
            }
        }
        if (jcmd) {
            System.out.println("Running local java commands against PID " + jvmpid + "\n");
            if (zing_home.matches("")) {
                System.out.println("This option requires the environment variable JAVA_HOME is set");
                java_home = System.getenv("JAVA_HOME");
                System.out.println("Environment variable " + java_home);
                if (java_home == null) {
                    System.out.println("Using AzulInspectors JDK");
                    java_home = System.getProperty("java.home");
                }
                System.out.println("Located " + java_home);
            } else {
                System.out.println("Using " + zing_home + " as JAVA_HOME");
                java_home = zing_home;
            }
            if (java_home.endsWith("/jre")) {
                System.out.println("Repointing " + java_home);
                java_home = java_home.substring(0, java_home.length() - 4);
            }
            if (java_home.endsWith("/bin")) {
                System.out.println("Repointing " + java_home);
                java_home = java_home.substring(0, java_home.length() - 4);
            }
            if (java_home.endsWith("/bin/java")) {
                System.out.println("Repointing " + java_home);
                java_home = java_home.substring(0, java_home.length() - 9);
            }
            if (java_home.endsWith("/bin/java6")) {
                System.out.println("Repointing " + java_home);
                java_home = java_home.substring(0, java_home.length() - 10);
            }
            if (java_home.endsWith("/bin/java7")) {
                System.out.println("Repointing " + java_home);
                java_home = java_home.substring(0, java_home.length() - 10);
            }
            if (java_home.endsWith("/bin/java8")) {
                System.out.println("Repointing " + java_home);
                java_home = java_home.substring(0, java_home.length() - 10);
            }
            System.out.println("JAVA_HOME is " + java_home);
            String[][] pcmd = new String[][]{{"", java_home + "/bin/jstat -class " + jvmpid}, {"", java_home + "/bin/jstat -compiler " + jvmpid}, {"", java_home + "/bin/jstat -gc " + jvmpid}, {"", java_home + "/bin/jstat -gccapacity " + jvmpid}, {"", java_home + "/bin/jstat -gccause " + jvmpid}, {"", java_home + "/bin/jstat -gcnew " + jvmpid}, {"", java_home + "/bin/jstat -gcnewcapacity " + jvmpid}, {"", java_home + "/bin/jstat -gcold " + jvmpid}, {"", java_home + "/bin/jstat -gcoldcapacity " + jvmpid}, {"", java_home + "/bin/jstat -gcpermcapacity " + jvmpid}, {"", java_home + "/bin/jstat -gcutil " + jvmpid}, {"", java_home + "/bin/jinfo " + jvmpid}, {"", java_home + "/bin/jstat -gpgc " + jvmpid}};
            System.out.println("Invoking Java Calls for process " + jvmpid);
            for (int n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling java System Command - [JCMD " + n + "] " + pcmd[n][1]);
                try {
                    String line4;
                    p = Runtime.getRuntime().exec("" + pcmd[n][1]);
                    InputStream stdout3 = null;
                    InputStream stderr3 = null;
                    stdout3 = ((Process)p).getInputStream();
                    stderr3 = ((Process)p).getErrorStream();
                    BufferedReader c5 = new BufferedReader(new InputStreamReader(stdout3));
                    while ((line4 = c5.readLine()) != null) {
                        System.out.println("[JCMD " + n + "] " + line4);
                    }
                    BufferedReader c12 = new BufferedReader(new InputStreamReader(stderr3));
                    while ((line4 = c12.readLine()) != null) {
                        System.out.println("[JCMD " + n + "] " + line4);
                    }
                    ((Process)p).getOutputStream().close();
                    ((Process)p).getErrorStream().close();
                    ((Process)p).getInputStream().close();
                    stdout3.close();
                    stderr3.close();
                    ((Process)p).waitFor();
                    c5.close();
                    c12.close();
                    System.out.println("[JCMD " + n + "] " + ((Process)p).exitValue() + "\n");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Command not found or incorrect user privileges");
                }
            }
            System.out.println("End of Java Command Collection");
        }
        if (!rmtprobe && (oscalls || osnet || osenv || ospid || oshost || osagent)) {
            int n;
            System.out.println("Building Operating System Commands");
            String[][] pcmd = new String[][]{{"osnet osagent", "hostname", ""}, {"osenv osagent", "uname -a", ""}, {"osenv", "cat /etc/system-release", ""}, {"osenv", "cat /etc/redhat-release", ".*el5.*|.*el6.*|.*el7.*"}, {"osenv osagent", "sysctl -A", ""}, {"ospid", "lsof -p" + jvmpid, ""}, {"ospid", "cat /proc/" + jvmpid + "/net/dev", ""}, {"ospid", "cat /proc/" + jvmpid + "/net/arp", ""}, {"ospid", "cat /proc/" + jvmpid + "/net/sockstat", ""}, {"ospid", "cat /proc/" + jvmpid + "/net/tcp", ""}, {"ospid", "cat /proc/" + jvmpid + "/limits", ""}, {"oshost", "cat /proc/cpuinfo", ""}, {"oshost osagent", "cat /proc/meminfo", ""}, {"oshost osagent", "zing-ps --acct2", ""}, {"oshost", "dmidecode", ""}, {"ospid", "ps -fp " + jvmpid + " -LP", ""}, {"ospid", "ps -p " + jvmpid + " -o pcpu,pmem,rss,size,vsz,minflt,majflt,psr", ""}, {"", "ps -a -o pcpu,pmem,rss,size,vsz,args --sort=-pcpu", ""}, {"osnet", "netstat -ntap", ""}, {"osenv", "cat /etc/SuSE-release && cat /etc/os-release", "default"}, {"osenv", "ec2-describe-instances", "-ec2 "}, {"osenv", "ec2-describe-images", "-ec2 "}, {"osenv", "ec2-describe-availability-zones", "-ec2 "}, {"ospid osagent", "cat /proc/swaps", ""}, {"ospid osagent", "vmstat 5 5", ""}, {"osenv", "lsmod", ""}, {"osenv", "ulimit -a", ""}, {"osenv", "dmesg", ""}, {"osenv", "mcelog", ""}, {"osenv", "numactl --hardware", ""}, {"osenv", "cat /proc/interrupts", ""}, {"osenv", "chkconfig --list", ""}, {"ospid", "numastat", ""}, {"osenv", "rpm -qa", ""}, {"osenv", "df -k", ""}, {"ospid", "mpstat -P ALL 1 1", ""}, {"osenv", "lsb_release -a", ""}, {"oshost", "cat /proc/acpi/processor/CPU0/info", ""}, {"ospid", "cat /proc/" + jvmpid + "/sched", ""}, {"ospid", "cat /proc/sched_debug", ""}, {"oshost", "cat /proc/sched", ""}, {"osenv", "tuned-adm active", ""}, {"osenv", "uptime", ""}, {"osenv", "cat /etc/inittab", ""}, {"osenv osagent", "cat /sys/kernel/mm/transparent_hugepage/enabled", ""}, {"osenv osagent", "cat /boot/grub/menu.lst", ".*el5.*|.*el6.*|.*default.*"}, {"osenv", "dpkg -l", ""}, {"ospid osagent", "numastat -p " + jvmpid, ""}, {"osenv", "ifconfig", ""}, {"ospid", "pidstat -p " + jvmpid + " -dhurwIt", ""}, {"osenv osagent", "cat /sys/kernel/mm/redhat_transparent_hugepage/enabled", ""}, {"osenv", "cat /proc/buddyinfo", ""}, {"ospid", "cat /proc/zoneinfo", ""}, {"osenv", "free -lm", ""}, {"osenv osagent", "lscpu", ""}, {"osenv", "find /boot -iname config-* -print -fprint azulinspector.tmp", ""}, {"osenv", "xargs -r -a azulinspector.tmp egrep -e 'INTEL_IDLE|CONFIG_KPROBES'", ""}, {"osenv", "cat /proc/vmstat", ""}, {"osenv osagent", "cat /sys/kernel/mm/redhat_transparent_hugepage/defrag", ""}, {"osenv osagent", "cat /sys/kernel/mm/transparent_hugepage/defrag", ""}, {"osenv", "cat /etc/modprobe.d/onload.conf", ""}, {"osenv", "cat /etc/modprobe.d/mlx4_en", ""}, {"", "ps -a -o pcpu,pmem,rss,size,vsz,args --sort=-rss", ""}, {"", "cat /proc/stat", ""}, {"osenv", "whoami", ""}, {"osenv", "cat /sys/devices/system/clocksource/clocksource0/available_clocksource", ""}, {"osenv", "zing-ps -s", ""}, {"osenv", "cat /etc/zing/license", ""}, {"osenv", "cat /etc/zing/pmem.conf", ""}, {"osenv", "tail -v /etc/zing/pmem.conf.[0-99]", ""}, {"osenv", "cat /etc/debian_version", "debian"}, {"osenv", "zing-licensed --display_system_info", " "}, {"osenv osagent", "cat /etc/default/grub", ".*el7.*"}, {"osenv", "zing-ps -V", ""}};
            for (n = 0; n < pcmd.length; ++n) {
                int m;
                for (m = 0; m < 3; ++m) {
                    if (osnet && pcmd[n][m].contains("osnet")) {
                        pcmd[n][0] = "";
                    }
                    if (ospid && pcmd[n][m].contains("ospid")) {
                        pcmd[n][0] = "";
                    }
                    if (oshost && pcmd[n][m].contains("oshost")) {
                        pcmd[n][0] = "";
                    }
                    if (osenv && pcmd[n][m].contains("osenv")) {
                        pcmd[n][0] = "";
                    }
                    if (oscalls && pcmd[n][m].contains("oscalls")) {
                        pcmd[n][0] = "";
                    }
                    if (!osagent || !pcmd[n][m].contains("osagent")) continue;
                    pcmd[n][0] = "";
                }
                if (distro != null) {
                    System.out.println("Context check");
                    if (pcmd[n][0].matches("") && !pcmd[n][2].matches("")) {
                        System.out.println("Check command " + n + " " + pcmd[n][2] + " distro " + distro);
                        if (!distro.matches(pcmd[n][2])) {
                            pcmd[n][0] = "Dont_Run";
                            System.out.println("Check N" + n + " M" + m + " match " + pcmd[n][0]);
                        }
                    }
                }
                if (filter.isEmpty() || filter.contains("[" + Integer.toString(n) + "]")) continue;
                pcmd[n][0] = "Dont_Run";
            }
            System.out.println("Invoking Operating System Calls for process " + jvmpid);
            if (!filter.isEmpty()) {
                System.out.println("Using filter " + filter);
            }
            for (n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling Operating System Command - [" + n + "] " + pcmd[n][1]);
                try {
                    String line5;
                    p = new ProcessBuilder("bash", "-c", pcmd[n][1]);
                    ((ProcessBuilder)p).redirectErrorStream(true);
                    Process shell = ((ProcessBuilder)p).start();
                    InputStream is = shell.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader c6 = new BufferedReader(isr);
                    while ((line5 = c6.readLine()) != null) {
                        System.out.println("[" + n + "] " + line5);
                    }
                    is.close();
                    isr.close();
                    int waitFor = shell.waitFor();
                    c6.close();
                    System.out.println("[" + n + "] " + waitFor + "\n");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Command not found or incorrect user privileges\n");
                }
            }
        }
        if (docker) {
            System.out.println("Building Docker Commands");
            String[][] pcmd = new String[][]{{"", "docker info"}, {"", "docker images"}, {"", "docker ps"}, {"", "docker ps -q"}, {"", "xargs -r -a azulinspector.tmp docker inspect"}, {"", "xargs -r -a azulinspector.tmp docker top"}, {"", "find /cgroup/memory/docker -fprint azulinspector.tmp"}, {"", "xargs -r -a azulinspector.tmp tail -v 2>/dev/null "}, {"", "find /cgroup/cpu/docker -fprint azulinspector.tmp"}, {"", "xargs -r -a azulinspector.tmp tail -v 2>/dev/null"}, {"", "find /cgroup/cpuacct/docker -fprint azulinspector.tmp"}, {"", "xargs -r -a azulinspector.tmp tail -v 2>/dev/null"}};
            System.out.println("Invoking Docker commands ");
            int n = 0;
            for (n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling Docker Command - [DOCKER " + n + "] " + pcmd[n][1]);
                try {
                    String line6;
                    p2 = Runtime.getRuntime().exec("" + pcmd[n][1]);
                    stdout = null;
                    stderr2 = null;
                    stdout = p2.getInputStream();
                    stderr2 = p2.getErrorStream();
                    c = new BufferedReader(new InputStreamReader(stdout));
                    if (n == 3) {
                        printWriter = new PrintWriter("azulinspector.tmp");
                    }
                    while ((line6 = c.readLine()) != null) {
                        System.out.println("[DOCKER " + n + "] " + line6);
                        if (n != 3) continue;
                        printWriter.println(line6);
                    }
                    c1 = new BufferedReader(new InputStreamReader(stderr2));
                    while ((line6 = c1.readLine()) != null) {
                        System.out.println("[DOCKER " + n + "] " + line6);
                    }
                    if (n == 3) {
                        printWriter.close();
                    }
                    p2.getOutputStream().close();
                    p2.getErrorStream().close();
                    p2.getInputStream().close();
                    stdout.close();
                    stderr2.close();
                    p2.waitFor();
                    c.close();
                    c1.close();
                    System.out.println("[DOCKER " + n + "] " + p2.exitValue() + "\n");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("[DOCKER " + n + "] Command not found or incorrect user privileges\n");
                }
            }
        }
        if (esxprobe) {
            int n;
            System.out.println("Building ESX Probes");
            System.out.println("Command categories HostEnabled: " + oshost + " EnvironmentEnabled: " + osenv + " Monitor: " + monitor);
            String[][] pcmd = new String[][]{{"osenv", "cat /etc/issue"}, {"osenv", "cat /proc/cpuinfo"}, {"osenv", "cat /proc/meminfo"}, {"osenv", "sysctl -A"}, {"osenv", "find ./vmfs/volumes -iname *.vmxf -print -exec cat {} ';'"}, {"osenv", "find ./vmfs/volumes -iname *.vmx -print -exec cat {} ';'"}, {"osenv", "esxcfg-nic -l"}, {"osenv", "esxcfg-vswitch -l"}, {"osenv", "esxcfg-vswif -l"}, {"osenv", "esxcfg-info"}, {"osenv", "vmkvsitools vmware -v -l"}, {"oshost", "esxtop -b -d 2 -n 10 -a -l"}, {"oshost", "vmksystemswap --stats"}, {"oshost", "vmksystemswap --state"}, {"oshost", "esxcfg-info -r"}, {"oshost", "cat /proc/stat"}};
            for (n = 0; n < pcmd.length; ++n) {
                for (int m = 0; m < 2; ++m) {
                    if (oshost && pcmd[n][m].matches("oshost")) {
                        pcmd[n][0] = "";
                    }
                    if (osenv && pcmd[n][m].matches("osenv")) {
                        pcmd[n][0] = "";
                    }
                    if (!monitor || !pcmd[n][m].matches("oshost")) continue;
                    pcmd[n][0] = "";
                }
            }
            System.out.println("Invoking ESX Calls  " + pcmd.length);
            for (n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling ESX System Command - [ESX " + n + "] " + pcmd[n][1]);
                try {
                    conn = new Connection(esxhost);
                    conn.connect();
                    boolean isAuthenticated = conn.authenticateWithPassword(esxuser, esxpass);
                    if (!isAuthenticated) {
                        throw new IOException("Authentication failed.");
                    }
                    sess = conn.openSession();
                    sess.execCommand(pcmd[n][1]);
                    StreamGobbler stdout4 = new StreamGobbler(sess.getStdout());
                    stderr = new StreamGobbler(sess.getStderr());
                    stdoutReader = new BufferedReader(new InputStreamReader(stdout4));
                    stderrReader = new BufferedReader(new InputStreamReader(stderr));
                    while ((line = stdoutReader.readLine()) != null) {
                        System.out.println("[ESX " + n + "]" + line);
                    }
                    while ((line = stderrReader.readLine()) != null) {
                        System.out.println("[ESX " + n + "]" + line);
                    }
                    sess.close();
                    ((InputStream)stdout4).close();
                    ((InputStream)stderr).close();
                    stdoutReader.close();
                    stderrReader.close();
                    conn.close();
                    System.out.println("[ESX " + n + "]\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    System.exit(2);
                }
            }
        }
        if (rmtprobe) {
            int n;
            System.out.println("Building Remote Probes");
            System.out.println("Command categories HostEnabled: " + oshost + " EnvironmentEnabled: " + osenv + " Monitor: " + monitor);
            String[][] pcmd = new String[][]{{"osnet", "hostname -va"}, {"osenv", "uname -a"}, {"osenv", "cat /etc/system-release"}, {"osenv", "cat /etc/redhat-release"}, {"osenv", "sysctl -A"}, {"", "lsof -p" + jvmpid}, {"ospid", "cat /proc/" + jvmpid + "/net/dev"}, {"ospid", "cat /proc/" + jvmpid + "/net/arp"}, {"ospid", "cat /proc/" + jvmpid + "/net/sockstat"}, {"ospid", "cat /proc/" + jvmpid + "/net/tcp"}, {"ospid", "cat /proc/" + jvmpid + "/limits"}, {"oshost", "cat /proc/cpuinfo"}, {"oshost", "cat /proc/meminfo"}, {"oshost", "zing-ps --acct2"}, {"oshost", "dmidecode"}, {"ospid", "ps -fp " + jvmpid + " -LP"}, {"ospid", "ps -p " + jvmpid + " -o pcpu,pmem,rss,size,vsz,minflt,majflt,psr"}, {"", "ps -a -o pcpu,pmem,rss,size,vsz,args --sort=-pcpu"}, {"osnet", "netstat -ntap"}, {"osenv", "cat /etc/SuSE-release && cat /etc/os-release"}, {"osenv", "ec2-describe-instances"}, {"osenv", "ec2-describe-images"}, {"osenv", "ec2-describe-availability-zones"}, {"ospid", "cat /proc/swaps"}, {"ospid", "vmstat 5 5"}, {"osenv", "lsmod"}, {"osenv", "ulimit -a"}, {"osenv", "dmesg"}, {"osenv", "mcelog"}, {"osenv", "numactl --hardware"}, {"osenv", "cat /proc/interrupts"}, {"osenv", "chkconfig --list"}, {"osenv", "numastat"}, {"osenv", "rpm -qa"}, {"osenv", "df -k"}, {"ospid", "mpstat -P ALL 1 1"}, {"osenv", "lsb_release -a"}, {"oshost", "cat /proc/acpi/processor/CPU0/info"}, {"ospid", "cat /proc/" + jvmpid + "/sched"}, {"ospid", "cat /proc/sched_debug"}, {"oshost", "cat /proc/sched"}, {"osenv", "tuned-adm active"}, {"osenv", "uptime"}, {"osenv", "cat /etc/inittab"}, {"osenv", "cat /sys/kernel/mm/transparent_hugepage/enabled"}, {"osenv", "cat /boot/grub/menu.lst"}, {"osenv", "dpkg -l"}, {"ospid", "numastat -p " + jvmpid}, {"osenv", "ifconfig"}, {"ospid", "pidstat -p " + jvmpid + " -dhurwIt"}, {"osenv", "cat /sys/kernel/mm/redhat_transparent_hugepage/enabled"}, {"osenv", "cat /proc/buddyinfo"}, {"ospid", "cat /proc/zoneinfo"}, {"osenv", "free -lm"}, {"osenv", "lscpu"}, {"osenv", "find /boot -iname config-* -print -fprint azulinspector.tmp"}, {"osenv", "xargs -r -a azulinspector.tmp egrep -e 'INTEL_IDLE|CONFIG_KPROBES'"}, {"osenv", "cat /proc/vmstat"}, {"osenv", "cat /sys/kernel/mm/redhat_transparent_hugepage/defrag"}, {"osenv", "cat /sys/kernel/mm/transparent_hugepage/defrag"}, {"osenv", "cat /etc/modprobe.d/onload.conf"}, {"osenv", "cat /etc/modprobe.d/mlx4_en"}, {"", "ps -a -o pcpu,pmem,rss,size,vsz,args --sort=-rss"}, {"", "cat /proc/stat"}, {"osenv", "whoami"}, {"osenv", "cat /sys/devices/system/clocksource/clocksource0/available_clocksource"}, {"osenv", "zing-ps -s"}, {"osenv", "cat /etc/zing/license"}, {"osenv", "cat /etc/zing/pmem.conf"}, {"osenv", "tail -v /etc/zing/pmem.conf.[0-99]"}, {"osenv", "cat /etc/debian_version"}, {"osenv", "zing-licensed --display_system_info"}, {"osenv", "zing-ps -V", ""}};
            for (n = 0; n < pcmd.length; ++n) {
                for (int m = 0; m < 2; ++m) {
                    if (oshost && pcmd[n][m].matches("oshost")) {
                        pcmd[n][0] = "";
                    }
                    if (osenv && pcmd[n][m].matches("osenv")) {
                        pcmd[n][0] = "";
                    }
                    if (!monitor || !pcmd[n][m].matches("ospid")) continue;
                    pcmd[n][0] = "";
                }
                if (filter.isEmpty() || filter.contains("[" + Integer.toString(n) + "]")) continue;
                pcmd[n][0] = "Dont_Run";
            }
            System.out.println("Invoking Remote Calls  " + pcmd.length);
            if (!filter.isEmpty()) {
                System.out.println("Using filter " + filter);
            }
            for (n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling Remote System Command - [RMT " + n + "] " + pcmd[n][1]);
                try {
                    conn = new Connection(rmthost);
                    conn.connect();
                    boolean isAuthenticated = conn.authenticateWithPassword(rmtuser, rmtpass);
                    if (!isAuthenticated) {
                        throw new IOException("Authentication failed.");
                    }
                    sess = conn.openSession();
                    sess.execCommand(pcmd[n][1]);
                    StreamGobbler stdout5 = new StreamGobbler(sess.getStdout());
                    stderr = new StreamGobbler(sess.getStderr());
                    stdoutReader = new BufferedReader(new InputStreamReader(stdout5));
                    stderrReader = new BufferedReader(new InputStreamReader(stderr));
                    while ((line = stdoutReader.readLine()) != null) {
                        System.out.println("[RMT " + n + "]" + line);
                        if (n != 5 || !line.contains("txt    REG")) continue;
                        java_home = line.substring(line.indexOf("/"), line.lastIndexOf("/"));
                    }
                    while ((line = stderrReader.readLine()) != null) {
                        System.out.println("[RMT " + n + "]" + line);
                    }
                    sess.close();
                    ((InputStream)stdout5).close();
                    ((InputStream)stderr).close();
                    stdoutReader.close();
                    stderrReader.close();
                    conn.close();
                    System.out.println("[RMT " + n + "]\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    System.exit(2);
                }
            }
        }
        if (rjcmd) {
            System.out.println("Building Remote Java Probes");
            System.out.println("Running remote java commands against PID " + jvmpid + "\n");
            if (java_home == "") {
                System.out.println("This option requires the environment variable JAVA_HOME is set to bin.");
                java_home = System.getenv("JAVA_HOME");
            } else {
                System.out.println("JAVA_HOME set from remote process listing");
            }
            System.out.println("JAVA_HOME is " + java_home);
            String[][] pcmd = new String[][]{{"", java_home + "/jstat -class " + jvmpid}, {"", java_home + "/jstat -compiler " + jvmpid}, {"", java_home + "/jstat -gc " + jvmpid}, {"", java_home + "/jstat -gccapacity " + jvmpid}, {"", java_home + "/jstat -gccause " + jvmpid}, {"", java_home + "/jstat -gcnew " + jvmpid}, {"", java_home + "/jstat -gcnewcapacity " + jvmpid}, {"", java_home + "/jstat -gcold " + jvmpid}, {"", java_home + "/jstat -gcoldcapacity " + jvmpid}, {"", java_home + "/jstat -gcpermcapacity " + jvmpid}, {"", java_home + "/jstat -gcutil " + jvmpid}, {"", java_home + "/jinfo " + jvmpid}, {"", java_home + "/jstat -gpgc " + jvmpid}};
            System.out.println("Invoking Java Calls for process " + jvmpid);
            for (int n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling java System Command - [ RJCMD " + n + "] " + pcmd[n][1]);
                for (n = 0; n < pcmd.length; ++n) {
                    if (!pcmd[n][0].matches("")) continue;
                    System.out.println(new Date() + " Calling Remote System Command - [ RJCMD " + n + "] " + pcmd[n][1]);
                    try {
                        conn = new Connection(rmthost);
                        conn.connect();
                        boolean isAuthenticated = conn.authenticateWithPassword(rmtuser, rmtpass);
                        if (!isAuthenticated) {
                            throw new IOException("Authentication failed.");
                        }
                        sess = conn.openSession();
                        sess.execCommand(pcmd[n][1]);
                        StreamGobbler stdout6 = new StreamGobbler(sess.getStdout());
                        stderr = new StreamGobbler(sess.getStderr());
                        stdoutReader = new BufferedReader(new InputStreamReader(stdout6));
                        stderrReader = new BufferedReader(new InputStreamReader(stderr));
                        while ((line = stdoutReader.readLine()) != null) {
                            System.out.println("[RJCMD " + n + "]" + line);
                        }
                        while ((line = stderrReader.readLine()) != null) {
                            System.out.println("[RJCMD " + n + "]" + line);
                        }
                        sess.close();
                        ((InputStream)stdout6).close();
                        ((InputStream)stderr).close();
                        stdoutReader.close();
                        stderrReader.close();
                        conn.close();
                        System.out.println("[RJCMD " + n + "]\n");
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                        System.exit(2);
                    }
                }
            }
        }
        if (kvmprobe) {
            int n;
            System.out.println("Building kvm Probes");
            System.out.println("Command categories HostEnabled: " + oshost + " EnvironmentEnabled: " + osenv + " Monitor: " + monitor);
            String[][] pcmd = new String[][]{{"osenv", "cat /etc/issue"}, {"osenv", "cat /proc/cpuinfo"}, {"osenv", "cat /proc/meminfo"}, {"osenv", "sysctl -A"}, {"osenv", "lsmod"}, {"oshost", "top -b -d 2 -n 5"}, {"oshost", "virt-top -b -n 5"}, {"oshost", "kvm_stat"}, {"oshost", "kvm_memstat"}, {"oshost", "cat /proc/stat"}};
            for (n = 0; n < pcmd.length; ++n) {
                for (int m = 0; m < 2; ++m) {
                    if (oshost && pcmd[n][m].matches("oshost")) {
                        pcmd[n][0] = "";
                    }
                    if (osenv && pcmd[n][m].matches("osenv")) {
                        pcmd[n][0] = "";
                    }
                    if (!monitor || !pcmd[n][m].matches("oshost")) continue;
                    pcmd[n][0] = "";
                }
            }
            System.out.println("Invoking KVM Calls  " + pcmd.length);
            for (n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling KVM System Command - [KVM " + n + "] " + pcmd[n][1]);
                try {
                    conn = new Connection(kvmhost);
                    conn.connect();
                    boolean isAuthenticated = conn.authenticateWithPassword(kvmuser, kvmpass);
                    if (!isAuthenticated) {
                        throw new IOException("Authentication failed.");
                    }
                    sess = conn.openSession();
                    sess.execCommand(pcmd[n][1]);
                    StreamGobbler stdout7 = new StreamGobbler(sess.getStdout());
                    stderr = new StreamGobbler(sess.getStderr());
                    stdoutReader = new BufferedReader(new InputStreamReader(stdout7));
                    stderrReader = new BufferedReader(new InputStreamReader(stderr));
                    while ((line = stdoutReader.readLine()) != null) {
                        System.out.println("[KVM " + n + "]" + line);
                    }
                    while ((line = stderrReader.readLine()) != null) {
                        System.out.println("[KVM " + n + "]" + line);
                    }
                    sess.close();
                    ((InputStream)stdout7).close();
                    ((InputStream)stderr).close();
                    stdoutReader.close();
                    stderrReader.close();
                    conn.close();
                    System.out.println("[KVM " + n + "]\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    System.exit(2);
                }
            }
        }
        if (xenprobe) {
            int n;
            System.out.println("Building xen Probes");
            System.out.println("Command categories HostEnabled: " + oshost + " EnvironmentEnabled: " + osenv + " Monitor: " + monitor);
            String[][] pcmd = new String[][]{{"osenv", "xm list"}, {"osenv", "xm info"}, {"osenv", "xm vcpu-list"}, {"osenv", "xm network-list"}, {"oshost", "top -b -d 2 -n 5"}, {"oshost", "xentop -b -i 5"}, {"oshost", "xm list"}, {"oshost", "cat /proc/stat"}};
            for (n = 0; n < pcmd.length; ++n) {
                for (int m = 0; m < 2; ++m) {
                    if (oshost && pcmd[n][m].matches("oshost")) {
                        pcmd[n][0] = "";
                    }
                    if (osenv && pcmd[n][m].matches("osenv")) {
                        pcmd[n][0] = "";
                    }
                    if (!monitor || !pcmd[n][m].matches("oshost")) continue;
                    pcmd[n][0] = "";
                }
            }
            System.out.println("Invoking XEN Calls  " + pcmd.length);
            for (n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Calling XEN System Command - [XEN " + n + "] " + pcmd[n][1]);
                try {
                    conn = new Connection(xenhost);
                    conn.connect();
                    boolean isAuthenticated = conn.authenticateWithPassword(xenuser, xenpass);
                    if (!isAuthenticated) {
                        throw new IOException("Authentication failed.");
                    }
                    sess = conn.openSession();
                    sess.execCommand(pcmd[n][1]);
                    StreamGobbler stdout8 = new StreamGobbler(sess.getStdout());
                    stderr = new StreamGobbler(sess.getStderr());
                    stdoutReader = new BufferedReader(new InputStreamReader(stdout8));
                    stderrReader = new BufferedReader(new InputStreamReader(stderr));
                    while ((line = stdoutReader.readLine()) != null) {
                        System.out.println("[XEN " + n + "]" + line);
                    }
                    while ((line = stderrReader.readLine()) != null) {
                        System.out.println("[XEN " + n + "]" + line);
                    }
                    sess.close();
                    ((InputStream)stdout8).close();
                    ((InputStream)stderr).close();
                    stdoutReader.close();
                    stderrReader.close();
                    conn.close();
                    System.out.println("[XEN " + n + "]\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    System.exit(2);
                }
            }
        }
        if (latency) {
            System.out.println("Latency Collection");
            System.out.println("Connecting to " + rmthost + " as " + rmtpass);
            System.out.println("Collection frequency " + latencytime);
            String[][] pcmd = new String[][]{{"", "cat /proc/sched_debug"}};
            for (int n = 0; n < pcmd.length; ++n) {
                if (!pcmd[n][0].matches("")) continue;
                System.out.println(new Date() + " Collecting - [LAT " + n + "] " + pcmd[n][1]);
                try {
                    Connection conn2 = new Connection(rmthost);
                    conn2.connect();
                    boolean isAuthenticated = conn2.authenticateWithPassword(rmtuser, rmtpass);
                    if (!isAuthenticated) {
                        throw new IOException("Authentication failed.");
                    }
                    while (true) {
                        String line7;
                        System.out.println(new Date());
                        Session sess2 = conn2.openSession();
                        sess2.execCommand(pcmd[n][1]);
                        StreamGobbler stdout9 = new StreamGobbler(sess2.getStdout());
                        StreamGobbler stderr4 = new StreamGobbler(sess2.getStderr());
                        BufferedReader stdoutReader2 = new BufferedReader(new InputStreamReader(stdout9));
                        BufferedReader stderrReader2 = new BufferedReader(new InputStreamReader(stderr4));
                        while ((line7 = stdoutReader2.readLine()) != null) {
                            System.out.println("[LAT " + n + "]" + line7);
                        }
                        while ((line7 = stderrReader2.readLine()) != null) {
                            System.out.println("[LAT " + n + "]" + line7);
                        }
                        Thread.sleep(latencytime.intValue());
                        sess2.close();
                        ((InputStream)stdout9).close();
                        ((InputStream)stderr4).close();
                        stdoutReader2.close();
                        stderrReader2.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    System.exit(2);
                }
            }
        }
        System.out.println("Execution completed " + new Date());
    }

    static {
        exceptionCount = 0;
    }
}

