/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.actions;

import azulinspector.AzulInspector;
import azulinspector.actions.AzulInspectorAction;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.output.PrefixedWriter;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class PrintVMDetailsAction
implements AzulInspectorAction {
    private final MBeansSupport mbs;
    private final MBeanServerConnection jmxc;

    private PrintVMDetailsAction(MBeansSupport mbs) {
        this.mbs = mbs;
        this.jmxc = mbs.getJMXConnection();
    }

    public static PrintVMDetailsAction init(MBeansSupport mbs) {
        return new PrintVMDetailsAction(mbs);
    }

    @Override
    public String getDescription() {
        return "Dump VM Details";
    }

    @Override
    public void run() {
        AzulInspector.out.println("Using " + (this.mbs.isLocal() ? "Local Host" : "Remote Host " + this.mbs.getAddress()));
        this.dumpMBeanDomains();
        this.dumpMBeanNames();
        this.dumpRuntimeDetails();
        this.dumpSystemProperties();
        this.dumpOperatingSystemMXBean();
        this.dumpClassLoadingMXBean();
        this.dumpThreadMXBean();
        this.dumpMemoryMXBean();
    }

    @Override
    public void dumpScript(PrefixedWriter out) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMBeanDomains() {
        AzulInspector.out.println("\nDomains:");
        try {
            AzulInspector.out.incOffset();
            Object[] domains = this.jmxc.getDomains();
            Arrays.sort(domains);
            for (Object domain : domains) {
                AzulInspector.out.println("Domain = " + (String)domain);
            }
            AzulInspector.out.println("\nMBeanServer default domain = " + this.jmxc.getDefaultDomain());
        }
        catch (IOException ex) {
            AzulInspector.err.println("Failed to query MBean domains: " + ex.getMessage());
        }
        finally {
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMBeanNames() {
        try {
            int mbeansCount = this.jmxc.getMBeanCount();
            AzulInspector.out.println("MBean count = " + mbeansCount);
            AzulInspector.out.println("\nObjectNames:");
            AzulInspector.out.incOffset();
            Set<ObjectName> names = this.jmxc.queryNames(ObjectName.WILDCARD, null);
            AzulInspector.out.println("Query MBeanServer MBeans:");
            TreeSet<ObjectName> sorted = new TreeSet<ObjectName>(names);
            for (ObjectName name : sorted) {
                AzulInspector.out.println("ObjectName = " + name);
            }
        }
        catch (IOException ex) {
            AzulInspector.err.println("Failed to query MBean names: " + ex.getMessage());
        }
        finally {
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    private void dumpRuntimeDetails() {
        AzulInspector.out.println("Runtime Details:");
        try {
            RuntimeMXBean runtime = this.mbs.getRuntimeBean();
            AzulInspector.out.incOffset();
            AzulInspector.out.println("JVM Args:        " + runtime.getInputArguments());
            AzulInspector.out.println("BootClassPath:   " + (runtime.isBootClassPathSupported() ? runtime.getBootClassPath() : "<unsupported>"));
            AzulInspector.out.println("Classpath:       " + runtime.getClassPath());
            AzulInspector.out.println("LibraryPath:     " + runtime.getLibraryPath());
            AzulInspector.out.println("Name:            " + runtime.getName());
            AzulInspector.out.println("SpecName:        " + runtime.getSpecName());
            AzulInspector.out.println("SpecVersion:     " + runtime.getSpecVersion());
            AzulInspector.out.println("VM Name:         " + runtime.getVmName());
            AzulInspector.out.println("VM Version:      " + runtime.getVmVersion());
            AzulInspector.out.println("VM Vendor:       " + runtime.getVmVendor());
            AzulInspector.out.println("UpTime:          " + runtime.getUptime());
        }
        finally {
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSystemProperties() {
        AzulInspector.out.println("System Properties:");
        try {
            AzulInspector.out.incOffset();
            RuntimeMXBean runtime = this.mbs.getRuntimeBean();
            Map<String, String> sysprop = runtime.getSystemProperties();
            TreeMap<String, String> sorted = new TreeMap<String, String>(sysprop);
            int maxKeyLength = 0;
            for (String key : sorted.keySet()) {
                maxKeyLength = Math.max(maxKeyLength, key.length());
            }
            char[] pad = new char[maxKeyLength];
            Arrays.fill(pad, ' ');
            String padding = ": " + new String(pad);
            for (Map.Entry entry : sorted.entrySet()) {
                AzulInspector.out.println((String)entry.getKey() + padding.substring(0, maxKeyLength - ((String)entry.getKey()).length() + 2) + (String)entry.getValue());
            }
        }
        finally {
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    private void dumpOperatingSystemMXBean() {
        AzulInspector.out.println("Operating System Details:");
        try {
            AzulInspector.out.incOffset();
            OperatingSystemMXBean remoteOperatingSystem = ManagementFactory.newPlatformMXBeanProxy(this.jmxc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            AzulInspector.out.println("Arcitecture:         " + remoteOperatingSystem.getArch());
            AzulInspector.out.println("Name:                " + remoteOperatingSystem.getName());
            AzulInspector.out.println("Version:             " + remoteOperatingSystem.getVersion());
            AzulInspector.out.println("Processors:          " + remoteOperatingSystem.getAvailableProcessors());
            AzulInspector.out.println("System Load Average: " + remoteOperatingSystem.getSystemLoadAverage());
        }
        catch (IOException ex) {
            AzulInspector.err.println("Failed to query OperatingSystemMXBean: " + ex.getMessage());
        }
        finally {
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    private void dumpClassLoadingMXBean() {
        AzulInspector.out.println("Classloader Details:");
        try {
            AzulInspector.out.incOffset();
            ClassLoadingMXBean ClassLoadingSystem = ManagementFactory.newPlatformMXBeanProxy(this.jmxc, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
            AzulInspector.out.println("ClassLoader Count: " + ClassLoadingSystem.getLoadedClassCount());
            AzulInspector.out.println("Total:             " + ClassLoadingSystem.getTotalLoadedClassCount());
            AzulInspector.out.println("Unloaded:          " + ClassLoadingSystem.getUnloadedClassCount());
        }
        catch (IOException ex) {
            AzulInspector.err.println("Failed to query ClassLoadingMXBean: " + ex.getMessage());
        }
        finally {
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpThreadMXBean() {
        block10: {
            AzulInspector.out.println("Thread Details:");
            try {
                AzulInspector.out.incOffset();
                ThreadMXBean thread = ManagementFactory.newPlatformMXBeanProxy(this.jmxc, "java.lang:type=Threading", ThreadMXBean.class);
                AzulInspector.out.println("Thread Count:   " + thread.getThreadCount());
                AzulInspector.out.println("Peak Count:     " + thread.getPeakThreadCount());
                AzulInspector.out.println("Daemon Threads: " + thread.getDaemonThreadCount());
                if (!Boolean.getBoolean("ShowDeadlocks")) break block10;
                AzulInspector.out.println("DeadLocked:       " + Arrays.toString(thread.findDeadlockedThreads()));
                AzulInspector.out.println("Monitor Deadlock: " + Arrays.toString(thread.findMonitorDeadlockedThreads()));
                AzulInspector.out.println("ThreadDump: ");
                ThreadInfo[] infos = thread.dumpAllThreads(true, true);
                String oldPrefix = AzulInspector.out.setPrefix("[ThreadDump] ");
                try {
                    for (ThreadInfo info : infos) {
                        StackTraceElement[] elems;
                        AzulInspector.out.println("ID: " + info.getThreadId() + "; Name: " + info.getThreadName() + "; State: " + (Object)((Object)info.getThreadState()));
                        for (StackTraceElement elem : elems = info.getStackTrace()) {
                            AzulInspector.out.println("   " + elem.toString());
                        }
                    }
                }
                finally {
                    AzulInspector.out.setPrefix(oldPrefix);
                }
            }
            catch (IOException ex) {
                AzulInspector.err.println("Failed to query ThreadMXBean: " + ex.getMessage());
            }
            finally {
                AzulInspector.out.decOffset();
                AzulInspector.out.println();
            }
        }
    }

    private void dumpMemoryMXBean() {
        AzulInspector.out.println("Memory Details:");
        try {
            AzulInspector.out.incOffset();
            MemoryMXBean MemoryPool = ManagementFactory.newPlatformMXBeanProxy(this.jmxc, "java.lang:type=Memory", MemoryMXBean.class);
            AzulInspector.out.println("Heap Usage:    " + MemoryPool.getHeapMemoryUsage());
            AzulInspector.out.println("NonHeap Usage: " + MemoryPool.getNonHeapMemoryUsage());
            if (Boolean.getBoolean("ForceGC")) {
                AzulInspector.out.warning("Remote GC invoked - You might need to specify -XX:-DisableExplicitGC");
                AzulInspector.out.println("Heap Usage:    " + MemoryPool.getHeapMemoryUsage());
                MemoryPool.gc();
                System.gc();
                AzulInspector.out.println("NonHeap Usage: " + MemoryPool.getNonHeapMemoryUsage());
            }
        }
        catch (IOException ex) {
            AzulInspector.err.println("Failed to query MemoryMXBean: " + ex.getMessage());
        }
        finally {
            AzulInspector.out.decOffset();
        }
    }
}

