/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.actions;

import azulinspector.AzulInspector;
import azulinspector.actions.AzulInspectorAction;
import azulinspector.output.LineFilter;
import azulinspector.output.OutputBuffer;
import azulinspector.output.PrefixedWriter;
import azulinspector.process.ExitStatus;
import azulinspector.process.LocalProcessBuilder;
import azulinspector.process.ProcessUtils;
import java.util.concurrent.atomic.AtomicInteger;

public final class SafetyCheckAction
implements AzulInspectorAction {
    @Override
    public String getDescription() {
        return "Critical safety settings validation [SafetyCheck]";
    }

    @Override
    public void run() {
        OutputBuffer output = new OutputBuffer(1024);
        OutputBuffer error = new OutputBuffer().redirect(AzulInspector.err);
        final AtomicInteger safetyViolators = new AtomicInteger(0);
        ExitStatus status = ProcessUtils.execute(new LocalProcessBuilder("cat", "/proc/meminfo"), output.accept("AnonHugePages.*|HugePages_Total.*").filter(new LineFilter(){

            @Override
            public String filter(String line) {
                String[] tokens = line.split("\\s+");
                if (tokens.length > 1 && !"0".equals(tokens[1])) {
                    AzulInspector.out.warning("Found invalid " + tokens[0]);
                    AzulInspector.out.warning("\t" + line);
                    safetyViolators.incrementAndGet();
                }
                return null;
            }
        }), error);
        output.dump(AzulInspector.out);
        AzulInspector.out.println("ExitCode: " + status.getExitCode());
        if (status.getExitCode() != 0) {
            AzulInspector.err.println("Failed to read /proc/meminfo");
        }
        if (safetyViolators.get() == 2) {
            AzulInspector.err.println("A dangerous combination of AnonHugePages and HugePages_Total - program terminating");
            System.exit(-1);
        }
    }

    @Override
    public void dumpScript(PrefixedWriter out) {
        out.println("GRP=\"Critical safety settings validation [SafetyCheck]\"");
        out.println("line started");
        out.println("cat /proc/meminfo | egrep \"^AnonHugePages|^HugePages_Total\" | awk '{if ($2 != 0) {print \"Warning: Found invalid \" $0; c++;}} END {if (c>1) {print \"A dangerous combination of AnonHugePages and HugePages_Total - program terminating\"; exit 1}}'");
        out.println("echo \"ExitCode: $?\"");
        out.println("echo");
        out.println("line complete\n");
    }
}

