/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.commands;

public enum CommandsGroup {
    DOCKER("DOCKER", "Docker"),
    ESX("ESX", "ESX System"),
    JCMD("JCMD", "Java System"),
    KVM("KVM", "KVM System"),
    OS("", "Operating System"),
    XEN("XEN", "XEN System");

    final String eye_catcher;
    final String description;

    private CommandsGroup(String eye_catcher, String description) {
        this.eye_catcher = eye_catcher;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static enum CommandCategory {
        monitor("Monitor"),
        osagent("Agent"),
        oscalls("NativeCallsEnabled"),
        osenv("EnvironmentEnabled"),
        oshost("HostEnabled"),
        osnet("NetworkEnabled"),
        ospid("ProcessEnabled");

        private final String prop;
        private boolean active;

        public static void activate(CommandCategory ... modifiers) {
            for (CommandCategory modifier : modifiers) {
                modifier.active = true;
            }
        }

        public static void deactivate(CommandCategory ... modifiers) {
            for (CommandCategory modifier : modifiers) {
                modifier.active = false;
            }
        }

        public static void reset() {
            for (CommandCategory modifier : CommandCategory.values()) {
                modifier.active = Boolean.getBoolean(modifier.prop);
            }
        }

        private CommandCategory(String prop) {
            this.prop = prop;
            this.active = Boolean.getBoolean(prop);
        }

        public String toString() {
            return this.prop + ": " + this.active;
        }

        public boolean isActive() {
            return this.active;
        }

        public String property() {
            return this.prop;
        }
    }
}

