/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.commands;

import azulinspector.commands.CommandsGroup;
import azulinspector.commands.DockerCommandsProvider;
import azulinspector.commands.ESXCommandsProvider;
import azulinspector.commands.EyeCatchersFilter;
import azulinspector.commands.JCmdCommandsProvider;
import azulinspector.commands.KVMCommandsProvider;
import azulinspector.commands.OSCommandsProvider;
import azulinspector.commands.XENCommandsProvider;
import azulinspector.utils.Globals;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

abstract class CommandsGroupProvider {
    protected final String[][] cmds;
    protected final Globals env;
    protected final CommandsGroup grp;

    protected CommandsGroupProvider(CommandsGroup grp, Globals env, String[][] cmds) {
        this.grp = grp;
        this.env = env;
        this.cmds = cmds;
    }

    public static CommandsGroupProvider get(Globals env, CommandsGroup groupID) {
        Class providerClass = null;
        switch (groupID) {
            case DOCKER: {
                if (Boolean.getBoolean("Docker")) {
                    providerClass = DockerCommandsProvider.class;
                }
            }
            case ESX: {
                if (!Boolean.getBoolean("ESXProbe")) break;
                providerClass = ESXCommandsProvider.class;
                break;
            }
            case JCMD: {
                if (!Boolean.getBoolean("JCMD") && !Boolean.getBoolean("RJCMD")) break;
                providerClass = JCmdCommandsProvider.class;
                break;
            }
            case KVM: {
                if (!Boolean.getBoolean("KVMProbe")) break;
                providerClass = KVMCommandsProvider.class;
                break;
            }
            case OS: {
                if (!Boolean.getBoolean("RMTProbe") && CommandsGroupProvider.getEnabledCategories().isEmpty()) break;
                providerClass = OSCommandsProvider.class;
                break;
            }
            case XEN: {
                if (!Boolean.getBoolean("XENProbe")) break;
                providerClass = XENCommandsProvider.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("No implementation for " + (Object)((Object)groupID));
            }
        }
        if (providerClass != null) {
            try {
                return (CommandsGroupProvider)providerClass.cast(providerClass.getDeclaredMethod("init", Globals.class).invoke(null, env));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public EnumSet<CommandsGroup.CommandCategory> getCategoriers() {
        EnumSet<CommandsGroup.CommandCategory> result = EnumSet.noneOf(CommandsGroup.CommandCategory.class);
        for (String[] cmd : this.cmds) {
            for (String m : cmd[0].split("\\|")) {
                if ((m = m.trim()).isEmpty()) continue;
                result.add(CommandsGroup.CommandCategory.valueOf(m));
            }
        }
        return result;
    }

    public Map<Integer, String[]> getCommands() {
        String enabledModes = CommandsGroupProvider.getEnabledCategories();
        TreeMap<Integer, String[]> result = new TreeMap<Integer, String[]>();
        EyeCatchersFilter filter = EyeCatchersFilter.getFilterFor(this.grp);
        for (int idx = 0; idx < this.cmds.length; ++idx) {
            String[] command = this.cmds[idx];
            if (!filter.appliesTo(idx) || !CommandsGroupProvider.hasMatches(command[0], enabledModes)) continue;
            if (this.env.distro != null) {
                String distr;
                String string = distr = command.length >= 3 ? command[2] : null;
                if (distr != null && !this.env.distro.matches(distr)) continue;
            }
            result.put(idx, command[1].split(" "));
        }
        return result;
    }

    private static String getEnabledCategories() {
        StringBuilder sb = new StringBuilder();
        for (CommandsGroup.CommandCategory modifyer : EnumSet.allOf(CommandsGroup.CommandCategory.class)) {
            if (!modifyer.isActive()) continue;
            sb.append(modifyer.name()).append('|');
        }
        return sb.substring(0, Math.max(0, sb.lastIndexOf("|")));
    }

    static boolean hasMatches(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1.isEmpty()) {
            return true;
        }
        if (str2.isEmpty()) {
            return false;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(str1.split("\\|")));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(str2.split("\\|")));
        set1.retainAll(set2);
        return !set1.isEmpty();
    }
}

