/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.commands;

import azulinspector.AzulInspector;
import azulinspector.actions.AzulInspectorAction;
import azulinspector.commands.CommandsGroup;
import azulinspector.commands.CommandsGroupProvider;
import azulinspector.output.OutputBuffer;
import azulinspector.output.PrefixedWriter;
import azulinspector.process.AbstractProcessBuilder;
import azulinspector.process.ExitStatus;
import azulinspector.process.LocalProcessBuilder;
import azulinspector.process.ProcessUtils;
import azulinspector.process.RemoteProcessBuilder;
import azulinspector.remote.RemoteConnectionInfo;
import azulinspector.utils.Globals;
import azulinspector.utils.Utilities;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class CommandsGroupRunAction
implements AzulInspectorAction {
    private static final boolean useScripts = Boolean.getBoolean("CGR_USE_SCRIPTS");
    private static final long sleepSecondsBetweenCommands = Long.getLong("CGR_SLEEP_SECONDS", 1L);
    private final CommandsGroupProvider provider;
    private final Globals env;
    private final CommandsGroup group;

    private CommandsGroupRunAction(CommandsGroupProvider provider, Globals env, CommandsGroup groupID) {
        this.provider = provider;
        this.env = env;
        this.group = groupID;
    }

    public static CommandsGroupRunAction getRunner(Globals env, CommandsGroup groupID) {
        CommandsGroupProvider provider = CommandsGroupProvider.get(env, groupID);
        return provider == null ? null : new CommandsGroupRunAction(provider, env, groupID);
    }

    @Override
    public void run() {
        RemoteConnectionInfo connectionInfo = null;
        if (!this.env.isLocal() && (connectionInfo = RemoteConnectionInfo.get(this.group)) == null) {
            throw new IllegalStateException();
        }
        this.dumpCategories(AzulInspector.out);
        if (useScripts) {
            CommandsGroupRunAction.runCommandsAsScript(connectionInfo, this.provider);
        } else {
            CommandsGroupRunAction.runCommandsSequentially(connectionInfo, this.provider);
        }
    }

    @Override
    public void dumpScript(PrefixedWriter out) {
        out.println("cat << EOF");
        this.dumpCategories(out);
        out.println("EOF");
        out.println("cat << EOF | run_group \"Local " + this.provider.grp.description + "\" \"" + this.provider.grp.eye_catcher + "\"");
        for (Map.Entry<Integer, String[]> entry : this.provider.getCommands().entrySet()) {
            out.println(entry.getKey() + " " + Utilities.toString(entry.getValue(), " "));
        }
        out.println("EOF");
        out.println();
    }

    private static void runCommandsAsScript(RemoteConnectionInfo connectionInfo, CommandsGroupProvider provider) {
        Map<Integer, String[]> commands = provider.getCommands();
        StringBuilder eye_catcher_buffer = new StringBuilder();
        StringBuilder script_buffer = new StringBuilder();
        StringBuilder header_buffer = new StringBuilder();
        StringBuilder cmdline = new StringBuilder();
        OutputBuffer out_buffer = new OutputBuffer().redirect(AzulInspector.out);
        OutputBuffer err_buffer = new OutputBuffer().redirect(AzulInspector.err);
        String grp_eye_catcher = provider.grp.eye_catcher.isEmpty() ? "" : (connectionInfo == null ? "" : "R") + provider.grp.eye_catcher + " ";
        String exec_mode = connectionInfo == null ? "Local " : "Remote ";
        String descr_header = header_buffer.append("`date | tr -d '\\n'`; Calling ").append(exec_mode).append(provider.grp.description).append(" Command: ").toString();
        for (Map.Entry<Integer, String[]> entry : commands.entrySet()) {
            String[] cmd = entry.getValue();
            eye_catcher_buffer.setLength(0);
            String eyeCatcher = eye_catcher_buffer.append("[").append(grp_eye_catcher).append(entry.getKey()).append("] ").toString();
            cmdline.setLength(0);
            for (String arg : cmd) {
                if (arg.contains(" ")) {
                    cmdline.append('\'').append(arg).append("' ");
                    continue;
                }
                cmdline.append(arg).append(' ');
            }
            script_buffer.append("echo \"").append(eyeCatcher).append(descr_header).append(eyeCatcher).append((CharSequence)cmdline).append("\"\n");
            script_buffer.append("(sh -c \"");
            script_buffer.append((CharSequence)cmdline);
            script_buffer.append("\" 2>&1; echo ExitCode: $?) | sed 's/^/").append(eyeCatcher).append("/'; echo\n");
            script_buffer.append("sleep ").append(sleepSecondsBetweenCommands).append(";\n");
        }
        AbstractProcessBuilder pb = connectionInfo == null ? new LocalProcessBuilder("bash", "-s") : new RemoteProcessBuilder(connectionInfo, "bash", "-s");
        ProcessUtils.execute(pb, out_buffer, err_buffer, new ByteArrayInputStream(script_buffer.toString().getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommandsSequentially(RemoteConnectionInfo connectionInfo, CommandsGroupProvider provider) {
        Map<Integer, String[]> commands = provider.getCommands();
        StringBuilder eye_catcher_buffer = new StringBuilder();
        StringBuilder header_buffer = new StringBuilder();
        String grp_eye_catcher = provider.grp.eye_catcher.isEmpty() ? "" : (connectionInfo == null ? "" : "R") + provider.grp.eye_catcher + " ";
        String exec_mode = connectionInfo == null ? "Local " : "Remote ";
        String descr_header = header_buffer.append("; Calling ").append(exec_mode).append(provider.grp.description).append(" Command: ").toString();
        OutputBuffer out_buffer = new OutputBuffer().redirect(AzulInspector.out);
        OutputBuffer err_buffer = new OutputBuffer().redirect(AzulInspector.err);
        for (Map.Entry<Integer, String[]> entry : commands.entrySet()) {
            String[] cmd = entry.getValue();
            eye_catcher_buffer.setLength(0);
            String eye_catcher_string = eye_catcher_buffer.append("[").append(grp_eye_catcher).append(entry.getKey()).append("] ").toString();
            String old_out_prefix = AzulInspector.out.setPrefix(eye_catcher_string);
            String old_err_prefix = AzulInspector.err.setPrefix(eye_catcher_string);
            header_buffer.setLength(0);
            header_buffer.append(new Date()).append(descr_header).append(eye_catcher_string).append(Utilities.toString(cmd, " "));
            AzulInspector.out.println(header_buffer.toString());
            try {
                AbstractProcessBuilder pb = connectionInfo == null ? new LocalProcessBuilder(cmd[0], Arrays.copyOfRange(cmd, 1, cmd.length)) : new RemoteProcessBuilder(connectionInfo, cmd[0], Arrays.copyOfRange(cmd, 1, cmd.length));
                ExitStatus res = ProcessUtils.execute(pb, out_buffer, err_buffer);
                AzulInspector.out.println("ExitCode: " + res.getExitCode());
                Thread.sleep(TimeUnit.SECONDS.toMillis(sleepSecondsBetweenCommands));
            }
            catch (InterruptedException ex) {
                if (Thread.interrupted()) {
                    break;
                }
            }
            finally {
                AzulInspector.out.setPrefix(old_out_prefix);
                AzulInspector.err.setPrefix(old_err_prefix);
            }
            AzulInspector.out.println();
        }
    }

    @Override
    public final String getDescription() {
        return this.group.description + " Commands";
    }

    private static List<String> formatCategories(EnumSet<CommandsGroup.CommandCategory> categories) {
        int len = 0;
        StringBuilder line = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        if (!categories.isEmpty()) {
            for (CommandsGroup.CommandCategory category : categories) {
                len = Math.max(len, category.property().length());
            }
            String delim = String.format(": %" + len + "s", " ");
            int dlen = delim.length();
            for (CommandsGroup.CommandCategory mod : categories) {
                String plen = mod.property();
                line.setLength(0);
                line.append(plen).append(delim.substring(0, dlen - plen.length())).append(mod.isActive());
                result.add(line.toString());
            }
        }
        return result;
    }

    protected void dumpCategories(PrefixedWriter out) {
        List<String> categories = CommandsGroupRunAction.formatCategories(this.provider.getCategoriers());
        if (!categories.isEmpty()) {
            out.println("Command Categories:");
            out.incOffset();
            for (String cat : categories) {
                out.println(cat);
            }
            out.decOffset();
        }
        out.println();
    }
}

