/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.commands;

import azulinspector.commands.CommandsGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class EyeCatchersFilter {
    private final Set<Integer> ids;

    private EyeCatchersFilter(Set<Integer> ids) {
        this.ids = ids;
    }

    public static EyeCatchersFilter getFilterFor(CommandsGroup grp) {
        Set<Integer> ids = null;
        if (CommandsGroup.OS.equals((Object)grp)) {
            ids = EyeCatchersFilter.initFilter();
        }
        if (ids == null) {
            ids = Collections.emptySet();
        }
        return new EyeCatchersFilter(ids);
    }

    private static Set<Integer> initFilter() {
        String flt = System.getProperty("Filter");
        if (flt == null) {
            return null;
        }
        HashSet<Integer> result = new HashSet<Integer>();
        StringBuilder sb = new StringBuilder(5);
        block4: for (char c : flt.toCharArray()) {
            switch (c) {
                case ' ': 
                case '[': 
                case ']': {
                    continue block4;
                }
                case ',': {
                    result.add(Integer.parseInt(sb.toString()));
                    sb.setLength(0);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            result.add(Integer.parseInt(sb.toString()));
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean appliesTo(int idx) {
        if (this.ids.isEmpty()) {
            return true;
        }
        return this.ids.contains(idx);
    }
}

