/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.commands;

import azulinspector.commands.CommandsGroup;
import azulinspector.commands.CommandsGroupProvider;
import azulinspector.utils.Globals;
import azulinspector.utils.Utilities;
import java.util.ArrayList;

final class JCmdCommandsProvider
extends CommandsGroupProvider {
    private JCmdCommandsProvider(Globals env, String[][] cmds) {
        super(CommandsGroup.JCMD, env, cmds);
    }

    public static JCmdCommandsProvider init(Globals env) {
        String jvmpid = env.getJVMPID();
        String java_home = env.getJavaHome();
        ArrayList<String> extra_paths = new ArrayList<String>();
        extra_paths.add(java_home + "/bin");
        extra_paths.add(java_home.replace("/jre", "/bin"));
        String jstat = Utilities.locateExecutable("jstat", extra_paths);
        String jinfo = Utilities.locateExecutable("jinfo", extra_paths);
        String jcmd = Utilities.locateExecutable("jcmd", extra_paths);
        String[][] cmds = new String[][]{{"", jstat + " -class " + jvmpid}, {"", jstat + " -compiler " + jvmpid}, {"", jstat + " -gc " + jvmpid}, {"", jstat + " -gccapacity " + jvmpid}, {"", jstat + " -gccause " + jvmpid}, {"", jstat + " -gcnew " + jvmpid}, {"", jstat + " -gcnewcapacity " + jvmpid}, {"", jstat + " -gcold " + jvmpid}, {"", jstat + " -gcoldcapacity " + jvmpid}, {"", jstat + " -gcpermcapacity " + jvmpid}, {"", jstat + " -gcutil " + jvmpid}, {"", jinfo + " " + jvmpid}, {"", jstat + " -gpgc " + jvmpid}, {"", jcmd + " " + jvmpid + " GC.heap_info"}};
        return new JCmdCommandsProvider(env, cmds);
    }
}

