/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.commands;

import azulinspector.commands.CommandsGroup;
import azulinspector.commands.CommandsGroupProvider;
import azulinspector.utils.Globals;

final class OSCommandsProvider
extends CommandsGroupProvider {
    private OSCommandsProvider(Globals env, String[][] cmds) {
        super(CommandsGroup.OS, env, cmds);
    }

    public static OSCommandsProvider init(Globals env) {
        String jvmpid = env.getJVMPID();
        String[][] cmds = new String[][]{{"osnet|osagent", "hostname"}, {"osenv|osagent", "uname -a"}, {"osenv", "cat /etc/system-release"}, {"osenv", "cat /etc/redhat-release", ".*el5.*|.*el6.*|.*el7.*"}, {"osenv|osagent", "sysctl -A"}, {"ospid", "lsof -p " + jvmpid}, {"ospid", "cat /proc/" + jvmpid + "/net/dev"}, {"ospid", "cat /proc/" + jvmpid + "/net/arp"}, {"ospid", "cat /proc/" + jvmpid + "/net/sockstat"}, {"ospid", "cat /proc/" + jvmpid + "/net/tcp"}, {"ospid", "cat /proc/" + jvmpid + "/limits"}, {"oshost", "cat /proc/cpuinfo"}, {"oshost|osagent", "cat /proc/meminfo"}, {"oshost|osagent", "zing-ps --acct2"}, {"oshost", "dmidecode"}, {"ospid", "ps -fp " + jvmpid + " -LP"}, {"ospid", "ps -p " + jvmpid + " -o pcpu,pmem,rss,size,vsz,minflt,majflt,psr"}, {"", "ps -a -o pcpu,pmem,rss,size,vsz,args --sort=-pcpu"}, {"osnet", "netstat -ntap"}, {"osenv", "cat /etc/SuSE-release /etc/os-release", "default"}, {"osenv", "ec2-describe-instances", "-ec2 "}, {"osenv", "ec2-describe-images", "-ec2 "}, {"osenv", "ec2-describe-availability-zones", "-ec2 "}, {"ospid|osagent", "cat /proc/swaps"}, {"ospid|osagent", "vmstat 5 5"}, {"osenv", "lsmod"}, {"osenv", "ulimit -a"}, {"osenv", "dmesg"}, {"osenv", "mcelog"}, {"osenv", "numactl --hardware"}, {"osenv", "cat /proc/interrupts"}, {"osenv", "chkconfig --list"}, {"ospid", "numastat"}, {"osenv", "rpm -qa"}, {"osenv", "df -k"}, {"ospid", "mpstat -P ALL 1 1"}, {"osenv", "lsb_release -a"}, {"oshost", "cat /proc/acpi/processor/CPU0/info"}, {"ospid", "cat /proc/" + jvmpid + "/sched"}, {"ospid", "cat /proc/sched_debug"}, {"oshost", "cat /proc/sched"}, {"osenv", "tuned-adm active"}, {"osenv", "uptime"}, {"osenv", "cat /etc/inittab"}, {"osenv|osagent", "cat /sys/kernel/mm/transparent_hugepage/enabled"}, {"osenv|osagent", "cat /boot/grub/menu.lst", ".*el5.*|.*el6.*|.*default.*"}, {"osenv", "dpkg -l"}, {"ospid|osagent", "numastat -p " + jvmpid}, {"osenv", "ifconfig"}, {"ospid", "pidstat -p " + jvmpid + " -dhurwIt"}, {"osenv|osagent", "cat /sys/kernel/mm/redhat_transparent_hugepage/enabled"}, {"osenv", "cat /proc/buddyinfo"}, {"ospid", "cat /proc/zoneinfo"}, {"osenv", "free -lm"}, {"osenv|osagent", "lscpu"}, {"osenv", "find /boot -iname config-* -print | xargs -r egrep -e 'INTEL_IDLE|CONFIG_KPROBES'"}, {"osenv", "cat /proc/vmstat"}, {"osenv|osagent", "cat /sys/kernel/mm/redhat_transparent_hugepage/defrag"}, {"osenv|osagent", "cat /sys/kernel/mm/transparent_hugepage/defrag"}, {"osenv", "cat /etc/modprobe.d/onload.conf"}, {"osenv", "cat /etc/modprobe.d/mlx4_en"}, {"", "ps -a -o pcpu,pmem,rss,size,vsz,args --sort=-rss"}, {"", "cat /proc/stat"}, {"osenv", "whoami"}, {"osenv", "cat /sys/devices/system/clocksource/clocksource0/available_clocksource"}, {"osenv", "zing-ps -s"}, {"osenv", "cat /etc/zing/license"}, {"osenv", "cat /etc/zing/pmem.conf"}, {"osenv", "tail -v /etc/zing/pmem.conf.[0-99]"}, {"osenv", "cat /etc/debian_version", "debian"}, {"osenv", "zing-licensed --display_system_info"}, {"osenv|osagent", "cat /etc/default/grub", ".*el7.*"}, {"osenv", "zing-ps -V"}, {"osenv", "systemctl list-unit-files"}, {"osenv", "systemctl list-dependencies runlevel5.target"}, {"osenv", "cat /boot/grub2/grub.cfg", ".*el7.*"}, {"osenv", "cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor", ".*el7.*"}, {"osenv", "cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_driver", ".*el7.*"}, {"osenv", "cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq", ".*el7.*"}, {"osenv", "cat /proc/sys/kernel/numa_balancing"}, {"osenv", "find /sys/devices/system/node -name numastat -print -exec cat {} \\;"}, {"osenv", "cat /proc/cmdline"}};
        return new OSCommandsProvider(env, cmds);
    }
}

