/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.mbeans;

import azulinspector.AzulInspector;
import azulinspector.mbeans.MBeansSupport;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class MBeansList {
    final MBeansSupport mbs;
    private final Map<ObjectName, Set<String>> mbeans = new TreeMap<ObjectName, Set<String>>(new ObjectNameComparator());

    public MBeansList(MBeansSupport mbs) {
        this.mbs = mbs;
    }

    public void addAll(String[] names) {
        for (String name : names) {
            try {
                this.put(new ObjectName(name), Collections.emptySet());
            }
            catch (MalformedObjectNameException ex) {
                Logger.getLogger(MBeansList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addAllAvailable() {
        try {
            Set<ObjectName> names = this.mbs.getJMXConnection().queryNames(ObjectName.WILDCARD, null);
            for (ObjectName name : names) {
                MBeanInfo info = this.mbs.getJMXConnection().getMBeanInfo(name);
                TreeSet<String> attrs = new TreeSet<String>();
                for (MBeanAttributeInfo attr : info.getAttributes()) {
                    attrs.add(attr.getName());
                }
                this.put(name, attrs);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MBeansList.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstanceNotFoundException ex) {
            Logger.getLogger(MBeansList.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(MBeansList.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ReflectionException ex) {
            Logger.getLogger(MBeansList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void add(ObjectName name, MBeanAttributeInfo attr) {
        Set<String> attrs = this.mbeans.get(name);
        if (attrs == null) {
            attrs = new TreeSet<String>();
            this.mbeans.put(name, attrs);
        }
        attrs.add(attr.getName());
    }

    private void add(ObjectName name, Collection<String> attrs) {
        if (attrs == null) {
            return;
        }
        Set<String> set = this.mbeans.get(name);
        if (set == null) {
            set = new TreeSet<String>();
            this.mbeans.put(name, set);
        }
        set.addAll(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromConfigFile(String filename) {
        AzulInspector.out.println("Processing " + filename + " configuration file.");
        BufferedReader br = null;
        ObjectName name = null;
        TreeSet<String> attrs = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                if ((line = line.replaceFirst("#.*", "").trim()).isEmpty()) continue;
                if (!line.startsWith("!")) {
                    this.put(name, attrs);
                    name = new ObjectName(line);
                    attrs = new TreeSet<String>();
                    continue;
                }
                line = line.substring(1);
                if (attrs == null) {
                    AzulInspector.err.println("Wrong config file format. Expected to find mbean name before attributes");
                    break;
                }
                attrs.add(line);
            }
            this.put(name, attrs);
        }
        catch (MalformedObjectNameException ex) {
            AzulInspector.err.println(ex.toString());
        }
        catch (FileNotFoundException ex) {
            AzulInspector.err.println(ex.toString());
        }
        catch (IOException ex) {
            AzulInspector.err.println(ex.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        AzulInspector.out.println("Total mbeans loaded from file: " + this.mbeans.size());
    }

    private void put(ObjectName name, Set<String> attrs_names) {
        this.add(name, this.validateMBeanData(name, attrs_names));
    }

    private Collection<String> validateMBeanData(ObjectName name, Collection<String> attr_names) {
        if (name == null || attr_names == null) {
            return null;
        }
        MBeanInfo info = null;
        try {
            info = this.mbs.getJMXConnection().getMBeanInfo(name);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (IntrospectionException introspectionException) {
        }
        catch (ReflectionException reflectionException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (info == null) {
            AzulInspector.out.warning("Failed to instantiate MXBean named '" + name.toString() + "'. Entry skipped.");
            return null;
        }
        if (attr_names.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        MBeanAttributeInfo[] allAttrs = info.getAttributes();
        HashSet<String> allAttrNames = new HashSet<String>(allAttrs.length);
        for (MBeanAttributeInfo attr : allAttrs) {
            allAttrNames.add(attr.getName());
        }
        for (String attr : attr_names) {
            if (allAttrNames.contains(attr)) {
                result.add(attr);
                continue;
            }
            AzulInspector.out.warning("MXBean '" + name.getCanonicalName() + "' has no attribure '" + attr + "'. Attribute skipped.");
        }
        return result.isEmpty() ? null : result;
    }

    public boolean isEmpty() {
        return this.mbeans.isEmpty();
    }

    public Iterable<Map.Entry<ObjectName, Set<String>>> entrySet() {
        return this.mbeans.entrySet();
    }

    private static class ObjectNameComparator
    implements Comparator<ObjectName> {
        private ObjectNameComparator() {
        }

        @Override
        public int compare(ObjectName o1, ObjectName o2) {
            return o1.getCanonicalName().compareTo(o2.getCanonicalName());
        }
    }
}

