/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.mbeans;

import azulinspector.AzulInspector;
import azulinspector.process.ProcessInfo;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class MBeansSupport {
    private final ConcurrentHashMap<Class, Object> vmBeans = new ConcurrentHashMap();
    private final MBeanServerConnection jmxc;
    private final String host;
    private final String port;
    private final boolean isLocal;

    private MBeansSupport(boolean isLocal, String host, String port, MBeanServerConnection connection) {
        this.isLocal = isLocal;
        this.host = host;
        this.port = port;
        this.jmxc = connection;
    }

    public static MBeansSupport init() throws IOException {
        return MBeansSupport.init(null, null);
    }

    public static MBeansSupport init(String jmxHost, String jmxPort) throws IOException {
        MBeanServerConnection jmxc;
        String jmxuser = System.getProperty("JMXUser", "");
        String jmxpass = System.getProperty("JMXPass", "");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (!jmxuser.isEmpty() && !jmxpass.isEmpty()) {
            env.put("jmx.remote.credentials", new String[]{jmxuser, jmxpass});
        }
        boolean isLocal = true;
        if (jmxHost == null) {
            jmxHost = "127.0.0.1";
        }
        if (jmxPort == null) {
            jmxc = ManagementFactory.getPlatformMBeanServer();
            jmxHost = "Local-Client-Mode";
            jmxPort = "0";
        } else {
            String uri = "service:jmx:rmi:///jndi/rmi://" + jmxHost + ":" + jmxPort + "/jmxrmi";
            try {
                JMXServiceURL url = new JMXServiceURL(uri);
                JMXConnector connector = JMXConnectorFactory.connect(url, env);
                jmxc = connector.getMBeanServerConnection();
                isLocal = MBeansSupport.isLocal(jmxHost);
            }
            catch (IOException ex) {
                AzulInspector.err.println("Failed to connect to: " + uri);
                String msg = ex.getMessage();
                if (msg != null && msg.contains("Credentials required")) {
                    System.err.println("***********************************************************");
                    System.err.println("Add the parameter -DJMXUser and -DJMXPass to the script.");
                    System.err.println("***********************************************************");
                }
                throw ex;
            }
        }
        return new MBeansSupport(isLocal, jmxHost, jmxPort, jmxc);
    }

    public MBeanServerConnection getJMXConnection() {
        return this.jmxc;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getAddress() {
        return this.getHost() + ":" + this.getPort();
    }

    public String getVMInfoAsString() {
        RuntimeMXBean runtime = this.getRuntimeBean();
        return runtime.getVmName() + " - " + runtime.getVmVersion() + " - " + runtime.getVmVendor();
    }

    public OperatingSystemMXBean getOperatingSystemBean() {
        return this.getVMBean("java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
    }

    public MemoryMXBean getMemoryBean() {
        return this.getVMBean("java.lang:type=Memory", MemoryMXBean.class);
    }

    public RuntimeMXBean getRuntimeBean() {
        return this.getVMBean("java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public ThreadMXBean getThreadBean() {
        return this.getVMBean("java.lang:type=Threading", ThreadMXBean.class);
    }

    private <T> T getVMBean(String factoryName, Class<T> mbeanClass) {
        Object result = this.vmBeans.get(mbeanClass);
        if (result != null) {
            return (T)result;
        }
        try {
            result = ManagementFactory.newPlatformMXBeanProxy(this.jmxc, factoryName, mbeanClass);
        }
        catch (IOException ex) {
            Logger.getLogger(MBeansSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object prev = this.vmBeans.putIfAbsent(mbeanClass, result);
        return (T)(prev == null ? result : prev);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    private static boolean isLocal(String jmxHost) throws IOException {
        InetAddress addr = InetAddress.getByName(jmxHost);
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static String detectJMXPort(ProcessInfo processInfo) {
        Pattern[] patterns = new Pattern[]{Pattern.compile(".*com.sun.management.jmxremote.port=([0-9]*).*"), Pattern.compile(".*cassandra.jmx.local.port=([0-9]*).*")};
        for (String arg : processInfo.getCmd()) {
            for (Pattern p : patterns) {
                Matcher matcher = p.matcher(arg);
                if (!matcher.matches()) continue;
                return matcher.group(1);
            }
        }
        return null;
    }
}

