/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.mbeans;

import azulinspector.AzulInspector;
import azulinspector.mbeans.MBeansList;
import azulinspector.monitor.MBeansMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class MBeansTable {
    private final MBeansList data;
    private final String dataFormat;
    private final String dataLabelFormat;
    private final String[] extraColumns;
    private final StringBuilder buf = new StringBuilder();

    public MBeansTable(String[] extraColumns, MBeansList data) {
        this.data = data;
        this.extraColumns = extraColumns == null ? new String[]{} : extraColumns;
        int labelLength = 0;
        for (Map.Entry<ObjectName, Set<String>> entry : data.entrySet()) {
            String name = entry.getKey().getKeyProperty("name");
            String type = entry.getKey().getKeyProperty("type");
            if (name != null) {
                labelLength = Math.max(labelLength, name.length());
            }
            if (type != null) {
                labelLength = Math.max(labelLength, type.length());
            }
            for (String attr : entry.getValue()) {
                labelLength = Math.max(labelLength, attr.length());
            }
        }
        this.dataLabelFormat = "%" + labelLength + "s%-3s";
        this.dataFormat = "%" + labelLength + "s,%-2s";
    }

    public void outHeader(boolean outMBeansType) {
        Iterator<String> it;
        int extraColsLen = this.extraColumns.length * 13;
        if (outMBeansType) {
            this.buf.append(String.format("%" + extraColsLen + "s", " "));
            for (Map.Entry<ObjectName, Set<String>> entry : this.data.entrySet()) {
                it = entry.getValue().iterator();
                while (it.hasNext()) {
                    this.buf.append(String.format(this.dataLabelFormat, entry.getKey().getKeyProperty("type"), " "));
                    it.next();
                }
            }
            AzulInspector.out.println(this.buf.toString());
        }
        this.buf.setLength(0);
        this.buf.append(String.format("%" + extraColsLen + "s", " "));
        for (Map.Entry<ObjectName, Set<String>> entry : this.data.entrySet()) {
            it = entry.getValue().iterator();
            while (it.hasNext()) {
                this.buf.append(String.format(this.dataLabelFormat, entry.getKey().getKeyProperty("name"), " "));
                it.next();
            }
        }
        AzulInspector.out.println(this.buf.toString());
        this.buf.setLength(0);
        for (String extraColumn : this.extraColumns) {
            this.buf.append(String.format("%8s%-5s", extraColumn, " "));
        }
        for (Map.Entry entry : this.data.entrySet()) {
            for (String attr : (Set)entry.getValue()) {
                this.buf.append(String.format(this.dataLabelFormat, attr, " "));
            }
        }
        AzulInspector.out.println(this.buf.toString());
    }

    public void outData(String[] extraData) {
        this.buf.setLength(0);
        for (String v : extraData) {
            this.buf.append(String.format("%8s,%-4s", v, " "));
        }
        try {
            for (Map.Entry entry : this.data.entrySet()) {
                for (String attr : (Set)entry.getValue()) {
                    Object value = this.data.mbs.getJMXConnection().getAttribute((ObjectName)entry.getKey(), attr);
                    if (value instanceof String[]) {
                        String[] arr;
                        for (String elem : arr = (String[])value) {
                            this.buf.append(String.format(this.dataFormat, elem, " "));
                        }
                        continue;
                    }
                    this.buf.append(String.format(this.dataFormat, value.toString(), " "));
                }
            }
        }
        catch (InstanceNotFoundException ex) {
            Logger.getLogger(MBeansMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ReflectionException ex) {
            Logger.getLogger(MBeansMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MBeansMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MBeanException ex) {
            Logger.getLogger(MBeansMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (AttributeNotFoundException ex) {
            Logger.getLogger(MBeansMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.buf.setLength(this.buf.lastIndexOf(","));
        AzulInspector.out.println(this.buf.toString());
    }

    public MBeansList getMbeansList() {
        return this.data;
    }
}

