/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.mbeans;

import azulinspector.AzulInspector;
import azulinspector.actions.AzulInspectorAction;
import azulinspector.mbeans.MBeansList;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.output.PrefixedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class PrintMBeansAction
implements AzulInspectorAction {
    private final MBeansSupport mbs;
    private final MBeansList mbeans;
    private static final int limit = Integer.getInteger("PrintMBeansAction.limit", 10000);
    private static final int offset = 50;

    private PrintMBeansAction(MBeansSupport mbs, MBeansList mbeans) {
        this.mbs = mbs;
        this.mbeans = mbeans;
    }

    public static PrintMBeansAction init(MBeansSupport mbs, MBeansList mbeans) {
        return new PrintMBeansAction(mbs, mbeans);
    }

    @Override
    public String getDescription() {
        return "Dumping MBeans State";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder sb = new StringBuilder("Attribute: ");
        int prefix_len = sb.length();
        String filler = String.format("%50s", " ");
        int count = 0;
        for (Map.Entry<ObjectName, Set<String>> entry : this.mbeans.entrySet()) {
            ObjectName name = entry.getKey();
            Set<String> attrs = entry.getValue();
            AzulInspector.out.println("Name: " + name.toString());
            AzulInspector.out.incOffset();
            try {
                for (String attr : attrs) {
                    if (count++ >= limit) {
                        AzulInspector.out.warning("MBeans dump is truncated. Use -DPrintMBeansAction.limit=NUM to increase number of lines to dump.");
                        return;
                    }
                    try {
                        Object value = this.mbs.getJMXConnection().getAttribute(name, attr);
                        sb.setLength(prefix_len);
                        sb.append(attr);
                        int pos = sb.length();
                        if (pos < 50) {
                            sb.append(filler);
                            sb.setLength(50);
                        }
                        String type = String.format("%-20s ", value == null ? "[<null>]" : "[" + value.getClass().getSimpleName() + "]");
                        sb.append(type);
                        AzulInspector.out.print(sb.toString());
                        AzulInspector.out.incOffset();
                        if (value instanceof boolean[]) {
                            AzulInspector.out.println(Arrays.toString((boolean[])value));
                            continue;
                        }
                        if (value instanceof byte[]) {
                            AzulInspector.out.println(Arrays.toString((byte[])value));
                            continue;
                        }
                        if (value instanceof char[]) {
                            AzulInspector.out.println(Arrays.toString((char[])value));
                            continue;
                        }
                        if (value instanceof double[]) {
                            AzulInspector.out.println(Arrays.toString((double[])value));
                            continue;
                        }
                        if (value instanceof float[]) {
                            AzulInspector.out.println(Arrays.toString((float[])value));
                            continue;
                        }
                        if (value instanceof int[]) {
                            AzulInspector.out.println(Arrays.toString((int[])value));
                            continue;
                        }
                        if (value instanceof long[]) {
                            AzulInspector.out.println(Arrays.toString((long[])value));
                            continue;
                        }
                        if (value instanceof short[]) {
                            AzulInspector.out.println(Arrays.toString((short[])value));
                            continue;
                        }
                        if (value instanceof Object[]) {
                            AzulInspector.out.println();
                            for (Object data : (Object[])value) {
                                AzulInspector.out.println(data == null ? "<null>" : data.toString());
                            }
                            continue;
                        }
                        AzulInspector.out.println(value == null ? "<null>" : value.toString());
                    }
                    catch (MBeanException ex) {
                        AzulInspector.out.warning(ex.getMessage());
                    }
                    catch (AttributeNotFoundException ex) {
                        AzulInspector.out.warning(ex.getMessage());
                    }
                    catch (InstanceNotFoundException ex) {
                        AzulInspector.out.warning(ex.getMessage());
                    }
                    catch (ReflectionException ex) {
                        AzulInspector.out.warning(ex.getMessage());
                    }
                    catch (IOException ex) {
                        AzulInspector.out.warning(ex.getMessage());
                    }
                    catch (RuntimeException ex) {
                        AzulInspector.out.warning(ex.getMessage());
                    }
                    finally {
                        AzulInspector.out.decOffset();
                    }
                }
            }
            finally {
                AzulInspector.out.decOffset();
                AzulInspector.out.println();
            }
        }
    }

    @Override
    public void dumpScript(PrefixedWriter out) {
    }
}

