/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.monitor;

import azulinspector.actions.AzulInspectorAction;
import azulinspector.monitor.LatencyMonitor;
import azulinspector.output.PrefixedWriter;
import azulinspector.utils.Utilities;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AzulInspectorMonitor<T>
implements AzulInspectorAction {
    private final ScheduledExecutorService exec = Utilities.newScheduledThreadPool(1);
    private final long frequency;

    AzulInspectorMonitor(long frequency, TimeUnit units) {
        this.frequency = units.toMillis(frequency);
    }

    @Override
    public final void run() {
        T data = this.preRun();
        try {
            ScheduledFuture<?> task = this.exec.scheduleAtFixedRate(this.getTask(), 0L, this.frequency, TimeUnit.MILLISECONDS);
            task.get();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(LatencyMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(LatencyMonitor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.postRun(data);
        }
    }

    @Override
    public void dumpScript(PrefixedWriter out) {
    }

    protected final long getFrequency() {
        return this.frequency;
    }

    protected abstract T preRun();

    protected abstract void postRun(T var1);

    protected abstract Runnable getTask();

    protected static final class CopyWriter
    extends PrintWriter {
        private final PrintWriter copy;

        public CopyWriter(OutputStream stream, PrintWriter copy) {
            super(stream, true);
            this.copy = copy;
        }

        @Override
        public void println(String msg) {
            super.println(msg);
            this.copy.println(msg);
        }
    }
}

