/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.monitor;

import azulinspector.AzulInspector;
import azulinspector.mbeans.MBeansList;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.mbeans.MBeansTable;
import azulinspector.monitor.AzulInspectorMonitor;
import azulinspector.output.LineFilter;
import azulinspector.output.OutputBuffer;
import azulinspector.process.AbstractProcessBuilder;
import azulinspector.process.LocalProcessBuilder;
import azulinspector.process.ProcessBuilder;
import azulinspector.process.ProcessUtils;
import azulinspector.process.RemoteProcessBuilder;
import azulinspector.remote.RemoteConnectionInfo;
import azulinspector.utils.Globals;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class GCMonitor
extends AzulInspectorMonitor<String> {
    private final PrintWriter out;
    private final MBeansSupport mbs;
    private final ProcessBuilder psProcessBuilder;
    private final MBeansTable table;

    private GCMonitor(MBeansSupport mbs, MBeansList mbeans, ProcessBuilder psProcessBuilder, PrintWriter out) {
        super(5L, TimeUnit.SECONDS);
        this.mbs = mbs;
        this.table = new MBeansTable(new String[]{"Time", "CPU", "Load", "Memory"}, mbeans);
        this.psProcessBuilder = psProcessBuilder;
        this.out = out;
    }

    public static AzulInspectorMonitor init(Globals env, int parseInt, TimeUnit timeUnit) {
        String logFile = "azulInspectorTrend.log";
        PrintWriter out = AzulInspector.out;
        try {
            out = new AzulInspectorMonitor.CopyWriter((OutputStream)new FileOutputStream(logFile), AzulInspector.out);
        }
        catch (FileNotFoundException ex) {
            AzulInspector.out.warning(ex.getMessage());
        }
        MBeansSupport mbs = env.getMBeansSupport();
        MBeanServerConnection jmxc = mbs.getJMXConnection();
        MBeansList mbeans = new MBeansList(mbs);
        try {
            TreeSet<ObjectName> names = new TreeSet<ObjectName>(jmxc.queryNames(ObjectName.WILDCARD, null));
            for (ObjectName objName : names) {
                MBeanAttributeInfo[] attributes;
                if (!objName.getKeyProperty("type").contains("GarbageCollector")) continue;
                MBeanInfo info = jmxc.getMBeanInfo(objName);
                for (MBeanAttributeInfo attr : attributes = info.getAttributes()) {
                    if (!attr.getName().contains("Collection")) continue;
                    mbeans.add(objName, attr);
                }
            }
        }
        catch (InstanceNotFoundException names) {
        }
        catch (IntrospectionException names) {
        }
        catch (ReflectionException names) {
        }
        catch (IOException names) {
            // empty catch block
        }
        String jvmpid = "" + env.getJVMPID();
        if (!mbs.isLocal()) {
            throw new IllegalArgumentException("Must run on the same physical host as the target");
        }
        AbstractProcessBuilder pb = env.isLocal() ? new LocalProcessBuilder("ps", "-p", jvmpid, "-o", "pcpu=") : new RemoteProcessBuilder(RemoteConnectionInfo.get(), "ps", "-p", jvmpid, "-o", "pcpu=");
        return new GCMonitor(mbs, mbeans, pb, out);
    }

    @Override
    protected String preRun() {
        this.out.println("Local Trend Monitor [CPU/Memory/GC]");
        this.out.println("  Using sleep time of 5 seconds.");
        this.out.println("  Log is written to azulInspectorTrend.log.");
        this.out.println("\nVM Attached: ");
        this.out.println("  " + this.mbs.getAddress());
        this.out.println("  " + this.mbs.getVMInfoAsString());
        this.out.println("\nDate: " + new Date());
        this.out.println("\nGC-specific beans found:");
        for (Map.Entry<ObjectName, Set<String>> entry : this.table.getMbeansList().entrySet()) {
            ObjectName name = entry.getKey();
            for (String value : entry.getValue()) {
                this.out.println("  " + name + ":" + value);
            }
        }
        this.out.println("\nUse Control + C to terminate.\n");
        this.table.outHeader(false);
        return null;
    }

    @Override
    protected void postRun(String args) {
    }

    @Override
    protected Runnable getTask() {
        return new TrendTask();
    }

    @Override
    public String getDescription() {
        return "GC Monitor";
    }

    private class TrendTask
    implements Runnable {
        private final OutputBuffer ps_out;
        private final AtomicReference<String> cpu = new AtomicReference<String>("-");

        public TrendTask() {
            this.ps_out = new OutputBuffer().filter(new LineFilter(){

                @Override
                public String filter(String line) {
                    TrendTask.this.cpu.set(line.trim());
                    return null;
                }
            });
        }

        @Override
        public void run() {
            ProcessUtils.execute(GCMonitor.this.psProcessBuilder, this.ps_out, new OutputBuffer().redirect(AzulInspector.err));
            GCMonitor.this.table.outData(new String[]{Long.toString(GCMonitor.this.mbs.getRuntimeBean().getUptime()), this.cpu.getAndSet("-"), String.format("%.2f", GCMonitor.this.mbs.getOperatingSystemBean().getSystemLoadAverage()), Long.toString(GCMonitor.this.mbs.getMemoryBean().getHeapMemoryUsage().getUsed())});
        }
    }
}

