/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.monitor;

import azulinspector.AzulInspector;
import azulinspector.monitor.AzulInspectorMonitor;
import azulinspector.output.OutputBuffer;
import azulinspector.process.ProcessUtils;
import azulinspector.process.RemoteProcessBuilder;
import azulinspector.remote.RemoteConnectionInfo;
import azulinspector.utils.Globals;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class LatencyMonitor
extends AzulInspectorMonitor<String> {
    private final RemoteConnectionInfo cinfo;

    private LatencyMonitor(RemoteConnectionInfo cinfo, int frequency, TimeUnit timeUnit) {
        super(frequency, timeUnit);
        this.cinfo = cinfo;
    }

    public static LatencyMonitor init(Globals env, int frequency, TimeUnit timeUnit) {
        RemoteConnectionInfo remoteConnectionInfo = RemoteConnectionInfo.get();
        if (remoteConnectionInfo == null) {
            AzulInspector.err.error("Latency monitor requires remote connection!");
            return null;
        }
        return new LatencyMonitor(remoteConnectionInfo, frequency, timeUnit);
    }

    @Override
    protected String preRun() {
        String oldPrefix = AzulInspector.out.setPrefix("[LAT] ");
        AzulInspector.out.println("Latency collection:");
        AzulInspector.out.println("Date: " + new Date());
        AzulInspector.out.println("Collection frequency: " + this.getFrequency());
        AzulInspector.out.println("Connecting to " + this.cinfo.getDispalyName());
        AzulInspector.out.println("\nUse Control + C to terminate.\n");
        return oldPrefix;
    }

    @Override
    protected Runnable getTask() {
        return new LatencyTask();
    }

    @Override
    protected void postRun(String old_prefix) {
        AzulInspector.out.setPrefix(old_prefix);
    }

    @Override
    public String getDescription() {
        return "Latency Monitor";
    }

    private class LatencyTask
    implements Runnable {
        private final RemoteProcessBuilder pb;
        private final OutputBuffer output = new OutputBuffer().redirect(AzulInspector.out);
        private final OutputBuffer error = new OutputBuffer().redirect(AzulInspector.err);

        public LatencyTask() {
            this.pb = new RemoteProcessBuilder(LatencyMonitor.this.cinfo, "cat", "/proc/sched_debug");
        }

        @Override
        public void run() {
            ProcessUtils.execute(this.pb, this.output, this.error);
        }
    }
}

