/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.monitor;

import azulinspector.AzulInspector;
import azulinspector.mbeans.MBeansList;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.mbeans.MBeansTable;
import azulinspector.monitor.AzulInspectorMonitor;
import azulinspector.utils.Globals;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class MBeansMonitor
extends AzulInspectorMonitor<String> {
    private final MBeansSupport mbs;
    private final MBeansTable table;

    private MBeansMonitor(MBeansSupport mbs, MBeansList mbeans) {
        super(5L, TimeUnit.SECONDS);
        this.mbs = mbs;
        this.table = new MBeansTable(new String[]{"Sample", "Time"}, mbeans);
    }

    public static AzulInspectorMonitor init(Globals env, int frequency, TimeUnit timeUnit) {
        String cfgFile = "azulInspector.watch";
        MBeansSupport mbs = env.getMBeansSupport();
        MBeansList mbeans = new MBeansList(mbs);
        mbeans.addFromConfigFile(cfgFile);
        return new MBeansMonitor(mbs, mbeans);
    }

    @Override
    protected String preRun() {
        AzulInspector.out.println("Date: " + new Date());
        AzulInspector.out.println("Starting Watch on " + this.mbs.getVMInfoAsString());
        AzulInspector.out.println("\nUse Control + C to terminate.\n");
        this.table.outHeader(true);
        return null;
    }

    @Override
    protected void postRun(String args) {
    }

    @Override
    protected Runnable getTask() {
        return new WatcherTask();
    }

    @Override
    public String getDescription() {
        return "MBeans Monitor";
    }

    private class WatcherTask
    implements Runnable {
        private final RuntimeMXBean runtime;
        private int sample = 1;

        public WatcherTask() {
            this.runtime = MBeansMonitor.this.mbs.getRuntimeBean();
        }

        @Override
        public void run() {
            MBeansMonitor.this.table.outData(new String[]{Integer.toString(this.sample++), Long.toString(this.runtime.getUptime())});
        }
    }
}

