/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.monitor;

import azulinspector.AzulInspector;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.monitor.AzulInspectorMonitor;
import azulinspector.utils.Globals;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class PerformanceMonitor
extends AzulInspectorMonitor<String> {
    private final MBeansSupport mbs;
    private final PrintWriter out;

    private PerformanceMonitor(MBeansSupport mbs, PrintWriter out, int frequency, TimeUnit timeUnit) {
        super(frequency, timeUnit);
        this.out = out;
        this.mbs = mbs;
    }

    public static PerformanceMonitor init(Globals env, int frequency, TimeUnit timeUnit) {
        String logFile = "performanceMonitor.log";
        PrintWriter out = AzulInspector.out;
        try {
            out = new AzulInspectorMonitor.CopyWriter((OutputStream)new FileOutputStream(logFile), AzulInspector.out);
        }
        catch (FileNotFoundException ex) {
            AzulInspector.out.warning(ex.toString());
        }
        return new PerformanceMonitor(env.getMBeansSupport(), out, frequency, timeUnit);
    }

    @Override
    protected String preRun() {
        this.out.println("Performance Trend Monitor [Memory Rates/CPU/Threads/Response]");
        this.out.println("  Using sleep time of " + this.getFrequency() + " ms. [TrendSleep]");
        this.out.println("\nVM Attached: ");
        this.out.println("  " + this.mbs.getAddress());
        this.out.println("  " + this.mbs.getVMInfoAsString());
        this.out.println("\nDate: " + new Date());
        this.out.println("\nUse Control + C to terminate.\n");
        this.out.println(String.format("%8s%-5s", "Time", " ") + String.format("%8s%-5s", "Rate", " ") + String.format("%8s%-5s", "Churn", " ") + String.format("%8s%-5s", "Ave", " ") + String.format("%8s%-5s", "Load", " ") + String.format("%8s%-5s", "Threads", " ") + String.format("%8s%-5s", "Change", " ") + String.format("%8s%-5s", "Delay", " ") + String.format("%8s%-5s", "Response", " "));
        return null;
    }

    @Override
    protected void postRun(String args) {
    }

    @Override
    protected Runnable getTask() {
        return new TrendTask();
    }

    @Override
    public String getDescription() {
        return "Performance Monitor";
    }

    private class TrendTask
    implements Runnable {
        private long last_mem;
        private long last_uptime;
        private long sample = 0L;
        private double total_rate = 0.0;
        private final StringBuilder sb = new StringBuilder();
        private final MemoryMXBean memory;
        private final RuntimeMXBean runtime;
        private final ThreadMXBean thread;
        private final OperatingSystemMXBean os;

        public TrendTask() {
            this.memory = PerformanceMonitor.this.mbs.getMemoryBean();
            this.runtime = PerformanceMonitor.this.mbs.getRuntimeBean();
            this.thread = PerformanceMonitor.this.mbs.getThreadBean();
            this.os = PerformanceMonitor.this.mbs.getOperatingSystemBean();
            this.last_mem = this.memory.getHeapMemoryUsage().getUsed();
            this.last_uptime = this.runtime.getUptime();
        }

        @Override
        public void run() {
            ++this.sample;
            long uptime = this.runtime.getUptime();
            long mem = this.memory.getHeapMemoryUsage().getUsed();
            long dmem = this.last_mem - mem;
            double dmem_ms_rate = (double)Math.abs(dmem) / (double)PerformanceMonitor.this.getFrequency();
            int appThreads = this.thread.getThreadCount() - this.thread.getDaemonThreadCount();
            this.total_rate += dmem_ms_rate;
            double avrg_rate = this.total_rate / (double)this.sample / (double)appThreads;
            double chrun_rate = dmem_ms_rate / avrg_rate;
            long a = System.nanoTime();
            long b = this.runtime.getUptime();
            long c = System.nanoTime();
            this.sb.setLength(0);
            this.sb.append(String.format("%8d,%-4s", uptime, " "));
            this.sb.append(String.format("%8d,%-4s", Math.round(dmem_ms_rate), " "));
            this.sb.append(String.format("%8d,%-4s", Math.round(chrun_rate), " "));
            this.sb.append(String.format("%8d,%-4s", Math.round(avrg_rate), " "));
            this.sb.append(String.format("%8.2f,%-4s", this.os.getSystemLoadAverage(), " "));
            this.sb.append(String.format("%8d,%-4s", appThreads, " "));
            this.sb.append(String.format("%8s,%-4s", dmem > 0L ? "1" : "0", " "));
            this.sb.append(String.format("%8d,%-4s", uptime - this.last_uptime - PerformanceMonitor.this.getFrequency(), " "));
            this.sb.append(String.format("%8d", TimeUnit.NANOSECONDS.toMillis(c - a), " "));
            PerformanceMonitor.this.out.println(this.sb.toString());
            this.last_uptime = uptime;
            this.last_mem = mem;
        }
    }
}

