/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.output;

import azulinspector.output.LineFilter;
import azulinspector.output.OutputBufferOverflowException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class OutputBuffer
implements Iterable<String> {
    private final int sizelimit;
    private final List<String> data = new ArrayList<String>();
    private final List<LineFilter> filters = new ArrayList<LineFilter>();
    private final AtomicLong dataSize = new AtomicLong(0L);
    private PrintWriter redirect = null;

    public OutputBuffer(int sizelimit) {
        this.sizelimit = sizelimit;
    }

    public OutputBuffer() {
        this(0);
    }

    public final OutputBuffer reset() {
        this.filters.clear();
        this.clear();
        return this;
    }

    public final OutputBuffer clear() {
        this.data.clear();
        this.dataSize.set(0L);
        return this;
    }

    public void dump(PrintWriter out) {
        for (String line : this.data) {
            out.println(line);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.data.iterator();
    }

    public void put(String line) {
        for (LineFilter filter : this.filters) {
            line = filter.filter(line);
            if (line != null) continue;
            return;
        }
        if (this.redirect != null) {
            this.redirect.println(line);
            this.redirect.flush();
        } else {
            if (this.dataSize.addAndGet(line.length()) > (long)this.sizelimit) {
                throw new OutputBufferOverflowException();
            }
            this.data.add(line);
        }
    }

    public int getLinesCount() {
        return this.data.size();
    }

    public int getCharsCount() {
        return this.dataSize.intValue();
    }

    public OutputBuffer accept(String regexp) {
        this.filter(new LineFilter.RegExpAcceptFilter(regexp));
        return this;
    }

    public OutputBuffer filter(LineFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public OutputBuffer redirect(PrintWriter redirect) {
        this.redirect = redirect;
        return this;
    }

    public OutputBuffer redirect(PrintStream stream) {
        return this.redirect(new PrintWriter(stream, true));
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.data) {
            sb.append(s).append('\n');
        }
        return sb.toString().trim();
    }
}

