/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class PrefixedWriter
extends PrintWriter {
    private final AtomicInteger offset = new AtomicInteger(0);
    private final AtomicBoolean line_start = new AtomicBoolean();
    private final String s_offset = "                          ";
    private String prefix;
    private String super_prefix;

    public PrefixedWriter(OutputStream out) {
        super(out, true);
    }

    @Override
    public void write(String s, int off, int len) {
        int pos = s.indexOf(10, off);
        if (pos >= 0 && pos < off + len) {
            this.write(s, off, pos - off);
            this.println();
            this.write(s, pos + 1, len - (pos - off) - 1);
        } else {
            if (this.line_start.compareAndSet(true, false)) {
                this.indent();
            }
            super.write(s, off, len);
        }
    }

    @Override
    public void println() {
        super.println();
        this.line_start.set(true);
    }

    public String setPrefix(String prefix) {
        String old = this.prefix;
        this.prefix = prefix;
        this.line_start.set(true);
        return old;
    }

    public void incOffset() {
        this.setOffset(this.offset.get() + 2);
    }

    public void decOffset() {
        this.setOffset(this.offset.get() - 2);
    }

    public void setOffset(int offset) {
        this.offset.set(Math.max(0, Math.min(offset, "                          ".length())));
        this.line_start.set(true);
    }

    private void indent() {
        if (this.super_prefix != null) {
            super.write(this.super_prefix, 0, this.super_prefix.length());
            super.write("                          ", 0, Math.max(0, this.offset.get() - this.super_prefix.length()));
        } else {
            super.write("                          ", 0, this.offset.get());
        }
        if (this.prefix != null) {
            super.write(this.prefix, 0, this.prefix.length());
        }
    }

    public void warning(String msg) {
        this.super_prefix = "[W] ";
        this.line_start.set(true);
        this.println(msg);
        this.super_prefix = null;
    }

    public void error(String msg) {
        this.super_prefix = "[E] ";
        this.line_start.set(true);
        this.println(msg);
        this.super_prefix = null;
    }
}

