/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.process;

import java.util.List;

public final class ProcessInfo {
    private final String pid;
    private final String exe;
    private final List<String> cmd;

    ProcessInfo(String pid, String exe, List<String> cmd) {
        this.pid = pid;
        this.cmd = cmd;
        this.exe = exe == null && cmd.size() > 0 ? cmd.get(0) : exe;
    }

    public String getCommandLine() {
        StringBuilder sb = new StringBuilder();
        for (String arg : this.cmd) {
            sb.append(arg).append(' ');
        }
        return sb.toString().trim();
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public String getExe() {
        return this.exe;
    }

    public String summary() {
        return this.pid + ": " + this.getCommandLine();
    }

    public String getPID() {
        return this.pid;
    }
}

