/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.process;

import azulinspector.output.LineFilter;
import azulinspector.output.OutputBuffer;
import azulinspector.process.AbstractProcessBuilder;
import azulinspector.process.ExitStatus;
import azulinspector.process.LocalProcessBuilder;
import azulinspector.process.ProcessBuilder;
import azulinspector.process.ProcessInfo;
import azulinspector.process.RemoteProcessBuilder;
import azulinspector.process.SimpleExitStatus;
import azulinspector.remote.RemoteConnectionInfo;
import azulinspector.utils.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProcessUtils {
    private static final ExecutorService execService = Utilities.newCachedThreadPool();

    public static ProcessInfo getLocalProcessInfo(String pid) {
        return ProcessUtils.getProcessInfo(null, pid);
    }

    public static ProcessInfo getProcessInfo(RemoteConnectionInfo connection, String pid) {
        List<String> output_exe = ProcessUtils.runCmd(connection, "readlink", "-f", "/proc/%/exe".replace("%", pid));
        List<String> output_cmd = ProcessUtils.runCmd(connection, "strings", "-1", "/proc/%/cmdline".replace("%", pid));
        String executable = output_exe.isEmpty() ? null : output_exe.get(0);
        return new ProcessInfo(pid, executable, output_cmd);
    }

    private static List<String> runCmd(RemoteConnectionInfo connection, String exe, String ... args) {
        AbstractProcessBuilder pb = connection == null ? new LocalProcessBuilder(exe, args) : new RemoteProcessBuilder(connection, exe, args);
        final ArrayList<String> output = new ArrayList<String>();
        ProcessUtils.execute(pb, new OutputBuffer().filter(new LineFilter(){

            @Override
            public String filter(String line) {
                output.add(line);
                return null;
            }
        }), null);
        return output;
    }

    private ProcessUtils() {
    }

    public static ExitStatus execute(ProcessBuilder pb, OutputBuffer output, OutputBuffer error) {
        return ProcessUtils.execute(pb, output, error, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExitStatus execute(ProcessBuilder pb, OutputBuffer output, OutputBuffer error, InputStream input) {
        AtomicBoolean interrupted = new AtomicBoolean(false);
        try {
            Process process = pb.start();
            if (output == null) {
                output = new OutputBuffer().filter(new LineFilter.Dispose());
            }
            if (error == null) {
                error = new OutputBuffer().filter(new LineFilter.Dispose());
            }
            Future<Void> outputTask = execService.submit(new OutputProcessor(process.getInputStream(), output, interrupted));
            Future<Void> errorTask = execService.submit(new OutputProcessor(process.getErrorStream(), error, interrupted));
            Future<Void> inputTask = input == null ? null : execService.submit(new InputProcessor(process.getOutputStream(), input, interrupted));
            try {
                SimpleExitStatus simpleExitStatus = new SimpleExitStatus(process.waitFor());
                return simpleExitStatus;
            }
            catch (InterruptedException ex) {
                process.destroy();
                interrupted.set(true);
                outputTask.cancel(false);
                errorTask.cancel(false);
            }
            finally {
                block43: {
                    block42: {
                        block41: {
                            try {
                                outputTask.get();
                            }
                            catch (InterruptedException ex2) {
                                interrupted.set(true);
                            }
                            catch (ExecutionException ex3) {
                                if (ex3.getCause() instanceof InterruptedException) break block41;
                                if (ex3.getCause() instanceof IOException) {
                                    error.put(ex3.getCause().getMessage());
                                }
                                Logger.getLogger(ProcessUtils.class.getName()).log(Level.SEVERE, null, ex3);
                            }
                        }
                        try {
                            errorTask.get();
                        }
                        catch (InterruptedException ex4) {
                            interrupted.set(true);
                        }
                        catch (ExecutionException ex5) {
                            if (ex5.getCause() instanceof InterruptedException) break block42;
                            if (ex5.getCause() instanceof IOException) {
                                error.put(ex5.getCause().getMessage());
                            }
                            Logger.getLogger(ProcessUtils.class.getName()).log(Level.SEVERE, null, ex5);
                        }
                    }
                    if (inputTask != null) {
                        try {
                            inputTask.get();
                        }
                        catch (InterruptedException ex6) {
                            interrupted.set(true);
                        }
                        catch (ExecutionException ex7) {
                            if (ex7.getCause() instanceof InterruptedException) break block43;
                            if (ex7.getCause() instanceof IOException) {
                                error.put(ex7.getCause().getMessage());
                            }
                            Logger.getLogger(ProcessUtils.class.getName()).log(Level.SEVERE, null, ex7);
                        }
                    }
                }
            }
        }
        catch (IOException ex8) {
            error.put(ex8.getMessage());
        }
        if (!interrupted.get()) return ExitStatus.ERROR;
        return ExitStatus.ERROR;
    }

    private static final class InputProcessor
    implements Callable<Void> {
        private final InputStream in;
        private final OutputStream out;
        private final AtomicBoolean interrupted;

        private InputProcessor(OutputStream out, InputStream in, AtomicBoolean interrupted) {
            this.in = in;
            this.out = out;
            this.interrupted = interrupted;
        }

        @Override
        public Void call() throws Exception {
            int n;
            byte[] buffer = new byte[1024];
            while (!this.interrupted.get() && (n = this.in.read(buffer)) > -1) {
                this.out.write(buffer, 0, n);
            }
            this.out.close();
            return null;
        }
    }

    private static final class OutputProcessor
    implements Callable<Void> {
        private final OutputBuffer output;
        private final InputStream stream;
        private final AtomicBoolean interrupted;

        public OutputProcessor(InputStream stream, OutputBuffer lineProcessor, AtomicBoolean interrupted) {
            this.output = lineProcessor;
            this.stream = stream;
            this.interrupted = interrupted;
        }

        @Override
        public Void call() throws Exception {
            try (BufferedReader br = null;){
                String line;
                br = new BufferedReader(new InputStreamReader(this.stream));
                while ((line = br.readLine()) != null) {
                    if (this.interrupted.get()) {
                        break;
                    }
                    this.output.put(line);
                }
            }
            return null;
        }
    }
}

