/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.process;

import azulinspector.process.AbstractProcessBuilder;
import azulinspector.remote.ConnectionManager;
import azulinspector.remote.RemoteConnectionInfo;
import azulinspector.utils.Utilities;
import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RemoteProcessBuilder
extends AbstractProcessBuilder {
    private final String cmd;
    private final RemoteConnectionInfo connectionInfo;
    private final ExecutorService exec = Utilities.newCachedThreadPool();

    public RemoteProcessBuilder(RemoteConnectionInfo connectionInfo, String command, String ... args) {
        super(command, args);
        this.connectionInfo = connectionInfo;
        StringBuilder sb = new StringBuilder();
        sb.append('\"').append(command).append("\" ");
        for (String arg : args) {
            sb.append('\"').append(arg).append("\" ");
        }
        this.cmd = sb.toString();
    }

    @Override
    public Process start() throws IOException {
        Connection connection = ConnectionManager.connectTo(this.connectionInfo);
        final Session session = connection.openSession();
        if (this.redirectError) {
            session.execCommand("2>&1 " + this.cmd);
        } else {
            session.execCommand(this.cmd);
        }
        final Process process = new Process(){
            private final AtomicInteger exitCode = new AtomicInteger(-1);

            @Override
            public OutputStream getOutputStream() {
                return session.getStdin();
            }

            @Override
            public InputStream getInputStream() {
                return session.getStdout();
            }

            @Override
            public InputStream getErrorStream() {
                return session.getStderr();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int waitFor() throws InterruptedException {
                AtomicInteger atomicInteger = this.exitCode;
                synchronized (atomicInteger) {
                    int res = this.exitCode.get();
                    if (res >= 0) {
                        return res;
                    }
                    res = 100;
                    try {
                        int cond = session.waitForCondition(99, 0L);
                        if ((cond & 0x20) == 32) {
                            res = session.getExitStatus();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(RemoteProcessBuilder.class.getName()).log(Level.SEVERE, null, ex);
                        this.exitCode.set(-2);
                    }
                    finally {
                        this.exitCode.set(res);
                    }
                    return res;
                }
            }

            @Override
            public int exitValue() {
                int res = this.exitCode.get();
                if (res < 0) {
                    throw new IllegalThreadStateException("Process not finished yet");
                }
                return res;
            }

            @Override
            public void destroy() {
                session.close();
            }
        };
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    process.waitFor();
                    session.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        return process;
    }
}

