/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.remote;

import azulinspector.remote.Authentication;
import azulinspector.remote.PasswordBasedAuth;
import azulinspector.remote.RemoteConnectionInfo;
import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionMonitor;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public final class ConnectionManager {
    private static final ConcurrentHashMap<RemoteConnectionInfo, Connection> connections = new ConcurrentHashMap();

    private ConnectionManager() {
    }

    public static Connection connectTo(RemoteConnectionInfo connectionInfo) throws IOException {
        Connection connection = connections.get(connectionInfo);
        if (connection != null && connection.isAuthenticationComplete()) {
            return connection;
        }
        connection = new Connection(connectionInfo.getHost());
        connection.addConnectionMonitor(new ConnectionListener(connectionInfo));
        connection.connect();
        Authentication auth = connectionInfo.getAuthentication();
        if (auth instanceof PasswordBasedAuth) {
            PasswordBasedAuth pauth = (PasswordBasedAuth)auth;
            boolean success = connection.authenticateWithPassword(pauth.getUsername(), pauth.getPassword());
            if (!success) {
                throw new IOException("Failed to connect to " + connectionInfo.getHost());
            }
        } else {
            throw new InternalError("Unsupported auth type " + auth.getClass().getName());
        }
        connections.put(connectionInfo, connection);
        return connection;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownTask()));
    }

    private static class ShutdownTask
    implements Runnable {
        private ShutdownTask() {
        }

        @Override
        public void run() {
            for (Connection connection : connections.values()) {
                connection.close();
            }
        }
    }

    private static class ConnectionListener
    implements ConnectionMonitor {
        private final RemoteConnectionInfo connectionInfo;

        public ConnectionListener(RemoteConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
        }

        @Override
        public void connectionLost(Throwable reason) {
            connections.remove(this.connectionInfo);
        }
    }
}

