/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.remote;

import azulinspector.commands.CommandsGroup;
import azulinspector.remote.Authentication;
import azulinspector.remote.PasswordBasedAuth;

public final class RemoteConnectionInfo {
    private static final String esxhost = System.getProperty("ESXHost");
    private static final String esxuser = System.getProperty("ESXUser");
    private static final String esxpass = System.getProperty("ESXPass");
    private static final String kvmhost = System.getProperty("KVMHost");
    private static final String kvmuser = System.getProperty("KVMUser");
    private static final String kvmpass = System.getProperty("KVMPass");
    private static final String xenhost = System.getProperty("XENHost");
    private static final String xenuser = System.getProperty("XENUser");
    private static final String xenpass = System.getProperty("XENPass");
    private static final String rmthost = System.getProperty("RMTHost");
    private static final String rmtuser = System.getProperty("RMTUser");
    private static final String rmtpass = System.getProperty("RMTPass");
    private final String host;
    private final Authentication auth;

    public RemoteConnectionInfo(String host, Authentication auth) {
        this.host = host;
        this.auth = auth;
    }

    public String getHost() {
        return this.host;
    }

    public Authentication getAuthentication() {
        return this.auth;
    }

    public String getDispalyName() {
        return this.auth.getDisplayName() + "@" + this.host;
    }

    public static RemoteConnectionInfo get(CommandsGroup group) {
        String pass;
        String user;
        String host;
        if (group == null) {
            host = rmthost;
            user = rmtuser;
            pass = rmtpass;
        } else {
            switch (group) {
                case ESX: {
                    host = esxhost;
                    user = esxuser;
                    pass = esxpass;
                    break;
                }
                case KVM: {
                    host = kvmhost;
                    user = kvmuser;
                    pass = kvmpass;
                    break;
                }
                case XEN: {
                    host = xenhost;
                    user = xenuser;
                    pass = xenpass;
                    break;
                }
                default: {
                    host = rmthost;
                    user = rmtuser;
                    pass = rmtpass;
                }
            }
        }
        if (host == null || user == null || pass == null) {
            return null;
        }
        return new RemoteConnectionInfo(host, new PasswordBasedAuth(user, pass));
    }

    public static RemoteConnectionInfo get() {
        return RemoteConnectionInfo.get(null);
    }
}

