/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.utils;

import azulinspector.commands.CommandsGroup;
import azulinspector.mbeans.MBeansSupport;
import azulinspector.process.ProcessInfo;
import azulinspector.remote.RemoteConnectionInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;

public final class Globals {
    private final ProcessInfo processInfo;
    private final MBeansSupport mbs;
    public final String distro = System.getProperty("Distro");
    public final boolean runSafetyCheck;

    public Globals(ProcessInfo processInfo, MBeansSupport mbs) {
        if (processInfo == null) {
            throw new NullPointerException("ProcessInfo cannot be null");
        }
        this.processInfo = processInfo;
        this.mbs = mbs;
        this.runSafetyCheck = Boolean.parseBoolean(System.getProperty("SafetyCheck", "true"));
    }

    public void dump(PrintWriter out) {
        ArrayList<String> data = new ArrayList<String>();
        data.add("SafetyCheck: " + this.runSafetyCheck);
        data.add("\nJMX Connection");
        data.add("--------------");
        if (this.mbs != null) {
            data.add("JMX Host: " + this.mbs.getHost());
            data.add("JMX Port: " + this.mbs.getPort());
        } else {
            data.add("[none]");
        }
        data.add("\nCommand Groups");
        data.add("--------------");
        data.add("Docker: " + Boolean.getBoolean("Docker"));
        data.add("JCMD: " + Boolean.getBoolean("JCMD"));
        data.add("RJCMD: " + Boolean.getBoolean("RJCMD"));
        data.add("ESXProbe: " + Boolean.getBoolean("ESXProbe") + "; ESXHost: " + System.getProperty("ESXHost") + "; ESXUser: " + System.getProperty("ESXUser"));
        data.add("KVMProbe: " + Boolean.getBoolean("KVMProbe") + "; KVMHost: " + System.getProperty("KVMHost") + "; KVMUser: " + System.getProperty("KVMUser"));
        data.add("XENProbe: " + Boolean.getBoolean("XENProbe") + "; XENHost: " + System.getProperty("XENHost") + "; XENUser: " + System.getProperty("XENUser"));
        data.add("RMTProbe: " + Boolean.getBoolean("RMTProbe") + "; RMTHost: " + System.getProperty("RMTHost") + "; RMTUser: " + System.getProperty("RMTUser"));
        data.add("\nCommand Groups Categories");
        data.add("-------------------------");
        for (CommandsGroup.CommandCategory categories : EnumSet.allOf(CommandsGroup.CommandCategory.class)) {
            data.add(categories.toString());
        }
        data.add("\nMonitors");
        data.add("--------");
        data.add("Watch: " + Boolean.getBoolean("Watch"));
        data.add("TrendLocal: " + Boolean.getBoolean("TrendLocal"));
        data.add("Latency: " + Boolean.getBoolean("Latency") + "; LatencyTime: " + System.getProperty("LatencyTime", "2000"));
        data.add("Trend: " + Boolean.getBoolean("Trend") + "; TrendSleep: " + System.getProperty("TrendSleep", "250"));
        int maxLength = 0;
        ArrayList<Integer> offsets = new ArrayList<Integer>(data.size());
        for (String line : data) {
            int idx = line.indexOf(":");
            maxLength = Math.max(maxLength, idx);
            offsets.add(idx);
        }
        String delim = String.format(":%" + (maxLength += 2) + "s", " ");
        StringBuilder sb = new StringBuilder();
        Iterator it = offsets.iterator();
        for (String line : data) {
            Integer idx = (Integer)it.next();
            if (idx > 0) {
                sb.append(line.substring(0, idx)).append(delim.subSequence(0, maxLength - idx)).append(line.substring(1 + idx));
                out.println(sb.toString());
                sb.setLength(0);
                continue;
            }
            out.println(line);
        }
    }

    public void dumpScript(PrintWriter out) {
        out.println("cat << EOF");
        this.dump(out);
        out.println("\nEOF\n");
    }

    public MBeansSupport getMBeansSupport() {
        return this.mbs;
    }

    public String getJVMPID() {
        return this.processInfo.getPID();
    }

    public String getJavaHome() {
        if (this.mbs != null) {
            return this.mbs.getRuntimeBean().getSystemProperties().get("java.home");
        }
        return this.processInfo.getExe().replace("/bin/java", "");
    }

    public boolean printMBeans() {
        return this.getMBeansSupport() != null;
    }

    public boolean isLocal() {
        if (this.mbs != null) {
            return this.mbs.isLocal();
        }
        return RemoteConnectionInfo.get() == null;
    }
}

