/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.utils;

import azulinspector.process.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JVMInfo {
    private final String pid;
    private final String vmName;
    private final String vmInfo;
    private final String vmVersion;
    private final Float vmSpecVersion;

    private JVMInfo(String pid, String vmName, String vmInfo, String vmVersion, Float vmSpecVersion) {
        this.pid = pid;
        this.vmName = vmName;
        this.vmInfo = vmInfo;
        this.vmVersion = vmVersion;
        this.vmSpecVersion = vmSpecVersion;
    }

    public static final JVMInfo getDefault() {
        return new JVMInfo(JVMInfo.getSelfPID(), System.getProperty("java.runtime.name"), System.getProperty("java.vm.info"), System.getProperty("java.runtime.version"), Float.valueOf(System.getProperty("java.vm.specification.version")));
    }

    private static String getSelfPID() {
        try {
            return new File("/proc/self").getCanonicalFile().getName();
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessUtils.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getPID() {
        return this.pid;
    }

    public String displayName() {
        return "(name): " + this.vmName + " (version): " + this.vmVersion + " (rel): " + this.vmInfo + " (spec):" + this.vmSpecVersion;
    }

    public float getSpecVersion() {
        return this.vmSpecVersion.floatValue();
    }

    public String getVersion() {
        return this.vmVersion;
    }
}

