/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.utils;

import azulinspector.output.PrefixedWriter;
import azulinspector.utils.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;

public final class ScriptWriterSupport {
    public final boolean scriptGenerateMode = Boolean.parseBoolean(System.getProperty("GenerateScript", "false"));
    private static final AtomicReference<PrefixedWriter> scriptWriter = new AtomicReference();

    private static PrefixedWriter init() throws FileNotFoundException {
        String filename = System.getProperty("AzulInspectorScript", "AzulInspectorScript.sh");
        File f = new File(filename);
        final PrefixedScriptWriter w = new PrefixedScriptWriter(new FileOutputStream(f));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                w.closeit();
            }
        }));
        Utilities.outResourceFile(w, "AzulInspectorScript.sh");
        f.setExecutable(true);
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrefixedWriter getOutputStream() throws FileNotFoundException {
        PrefixedWriter w = scriptWriter.get();
        if (w == null) {
            AtomicReference<PrefixedWriter> atomicReference = scriptWriter;
            synchronized (atomicReference) {
                w = scriptWriter.get();
                if (w != null) {
                    return w;
                }
                w = ScriptWriterSupport.init();
                scriptWriter.set(w);
            }
        }
        return w;
    }

    private static final class PrefixedScriptWriter
    extends PrefixedWriter {
        public PrefixedScriptWriter(OutputStream s) {
            super(s);
        }

        @Override
        public void close() {
        }

        private void closeit() {
            this.println("\nDONE=yes\n");
            super.close();
            System.out.println("A script has been generated based on the current parameters and currently executing JVM's");
            System.out.println("Please ask the System Admin to execute the script (AzulInspectorScript.sh)");
            System.out.println("and return the file AzulInspectorScript.log for analysis.");
            System.out.println();
        }
    }
}

