/*
 * Decompiled with CFR 0.152.
 */
package azulinspector.utils;

import azulinspector.AzulInspector;
import azulinspector.output.LineFilter;
import azulinspector.output.OutputBuffer;
import azulinspector.process.AbstractProcessBuilder;
import azulinspector.process.LocalProcessBuilder;
import azulinspector.process.ProcessInfo;
import azulinspector.process.ProcessUtils;
import azulinspector.process.RemoteProcessBuilder;
import azulinspector.remote.RemoteConnectionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Utilities {
    private static final AtomicReference<ThreadFactory> daemonThreadFactory = new AtomicReference<Object>(null);
    private static final ConcurrentLinkedQueue<ExecutorService> execServices = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outResourceFile(PrintWriter out, String filename) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(Utilities.class.getResourceAsStream("/azulinspector/resources/" + filename)));
            while ((line = br.readLine()) != null) {
                out.println(line);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utilities.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Utilities.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static String fixupJavaHome(String ... choices) {
        String java_home = null;
        for (String c : choices) {
            if (c == null || c.isEmpty()) continue;
            java_home = c;
            break;
        }
        if (java_home == null) {
            return null;
        }
        int length = java_home.length();
        if (java_home.endsWith("/jre")) {
            java_home = java_home.substring(0, length - 4);
        } else if (java_home.endsWith("/bin")) {
            java_home = java_home.substring(0, length - 4);
        } else if (java_home.endsWith("/bin/java")) {
            java_home = java_home.substring(0, length - 9);
        } else if (java_home.endsWith("/bin/java6")) {
            java_home = java_home.substring(0, length - 10);
        } else if (java_home.endsWith("/bin/java7")) {
            java_home = java_home.substring(0, length - 10);
        } else if (java_home.endsWith("/bin/java8")) {
            java_home = java_home.substring(0, length - 10);
        }
        return java_home;
    }

    public static final String toString(String[] arr, String delim) {
        StringBuilder sb = new StringBuilder();
        for (String elem : arr) {
            sb.append(elem).append(delim);
        }
        sb.setLength(Math.max(0, sb.lastIndexOf(delim)));
        return sb.toString();
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        ScheduledExecutorService result = Executors.newScheduledThreadPool(corePoolSize, Utilities.getDaemonThreadsFactory());
        execServices.add(result);
        return result;
    }

    public static ExecutorService newCachedThreadPool() {
        ExecutorService result = Executors.newCachedThreadPool(Utilities.getDaemonThreadsFactory());
        execServices.add(result);
        return result;
    }

    private static ThreadFactory getDaemonThreadsFactory() {
        boolean updated;
        ThreadFactory result = daemonThreadFactory.get();
        if (result == null) {
            result = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            };
        }
        return (updated = daemonThreadFactory.compareAndSet(null, result)) ? result : daemonThreadFactory.get();
    }

    public static Collection<ProcessInfo> findZingProcesses(PrintWriter writer) {
        final PrintWriter output = writer == null ? AzulInspector.out : writer;
        final ArrayList result = new ArrayList();
        RemoteConnectionInfo connectionInfo = RemoteConnectionInfo.get();
        AbstractProcessBuilder pb = connectionInfo == null ? new LocalProcessBuilder("zing-ps", "--comma") : new RemoteProcessBuilder(connectionInfo, "zing-ps", "--comma");
        final AtomicInteger cnt = new AtomicInteger(0);
        output.println("Locating Zing instances");
        ProcessUtils.execute(pb, new OutputBuffer().accept(".*java.*").filter(new LineFilter(){

            @Override
            public String filter(String line) {
                String[] data = line.split(",", 3);
                if (data.length == 3) {
                    output.println("Found = [" + cnt.incrementAndGet() + "] " + line.trim());
                    result.add(ProcessUtils.getLocalProcessInfo(data[1].trim()));
                }
                return null;
            }
        }), new OutputBuffer().redirect(AzulInspector.err));
        output.println("Found " + cnt.get() + " Java instances");
        return Collections.unmodifiableCollection(result);
    }

    public static Collection<ProcessInfo> findJavaProcesses(PrintWriter writer) {
        final PrintWriter output = writer == null ? AzulInspector.out : writer;
        final ArrayList result = new ArrayList();
        Object[] args = new String[]{"-c", "for i in $(ls -l /proc/*/exe 2> /dev/null | grep -e java -e jsvc | awk 'BEGIN{FS=\"[/]\"}{print $3}') ; do ps -f -q $i --no-heading 2> /dev/null ; done"};
        final RemoteConnectionInfo connectionInfo = RemoteConnectionInfo.get();
        AbstractProcessBuilder pb = connectionInfo == null ? new LocalProcessBuilder("/bin/bash", (String[])args) : new RemoteProcessBuilder(connectionInfo, "/bin/bash", (String[])args);
        System.out.println("args=[" + Arrays.toString(args) + "]");
        final AtomicInteger cnt = new AtomicInteger(0);
        output.println("Locating Java instances");
        ProcessUtils.execute(pb, new OutputBuffer().filter(new LineFilter(){

            @Override
            public String filter(String line) {
                String[] data = line.split("[ \t]+", 3);
                if (data.length == 3) {
                    output.println("Found = [" + cnt.getAndIncrement() + "] " + line.trim());
                    result.add(ProcessUtils.getProcessInfo(connectionInfo, data[1]));
                }
                return null;
            }
        }), new OutputBuffer().redirect(writer));
        output.println("Found " + cnt.get() + " Java instances");
        return Collections.unmodifiableCollection(result);
    }

    private static void outProcesses(Collection<ProcessInfo> info) {
        for (ProcessInfo i : info) {
            AzulInspector.out.println(i.getPID() + ": " + i.getExe());
            AzulInspector.out.incOffset();
            for (String arg : i.getCmd()) {
                AzulInspector.out.println(arg);
            }
            AzulInspector.out.decOffset();
            AzulInspector.out.println();
        }
    }

    public static String locateExecutable(String exec, List<String> extra_paths) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder extra = new StringBuilder();
        if (extra_paths != null && !extra_paths.isEmpty()) {
            for (String path : extra_paths) {
                extra.append(path).append(':');
            }
            extra.setLength(extra.length() - 1);
            args.add("-i");
            args.add("PATH=" + extra.toString());
        }
        args.add("/usr/bin/which");
        args.add(exec);
        RemoteConnectionInfo connectionInfo = RemoteConnectionInfo.get();
        AbstractProcessBuilder pb = connectionInfo == null ? new LocalProcessBuilder("/usr/bin/env", args.toArray(new String[args.size()])) : new RemoteProcessBuilder(connectionInfo, "/usr/bin/env", args.toArray(new String[args.size()]));
        OutputBuffer output = new OutputBuffer(1024);
        ProcessUtils.execute(pb, output, new OutputBuffer().redirect(AzulInspector.err));
        return output.getLinesCount() > 0 ? output.asString() : exec;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                for (ExecutorService execService : execServices) {
                    execService.shutdownNow();
                    try {
                        boolean terminated = execService.awaitTermination(3L, TimeUnit.SECONDS);
                        if (terminated) continue;
                        System.err.println("One or more tasks failed to terminate in 10 seconds - some data may be lost.");
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ProcessUtils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }));
    }
}

