/*
 * Decompiled with CFR 0.152.
 */
package aicheck;

import java.io.BufferedReader;
import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static FileChannel filenameIn;
    public static List<String> myList;
    private static int result;
    private static int foundline;
    public static String[] az;
    public static String temp;
    public static int offset;
    public static boolean db;
    public static String dbquery;
    public static String dbfilename;
    public static boolean dbdelete;
    public static String dbmerge;
    public static boolean dblist;
    public static boolean dbwithhost;
    public static boolean dboverride;
    public static boolean dbvalues;
    public static boolean dbkey;
    public static boolean dbupdate;
    public static String dbcustomer;
    public static boolean dbcompareexisting;
    public static boolean interactive;
    public static boolean interactive_load;
    public static boolean customermode;
    public static HashMap<String, Integer> dbcommon;
    public static Hashtable dbname;
    public static HashMap dbhost;
    public static HashMap dbparm;
    static String filename;
    static String filename1;
    public static boolean verbose;
    public static boolean addsearch;
    public static String addfile;
    public static boolean compare;
    public static String rulename;
    public static boolean ruleexec;
    public static boolean printextract;
    static HashMap aidata;
    static HashMap aidataFound;
    static HashMap aidataList;
    public static int searchStringsMax;
    public static long[] querystats_;
    public static String querystats_common;
    static String[] junk;
    static String[][] eyecatcher;
    static String[][] searchStrings;

    public static void main(String[] args) throws IOException {
        int key;
        System.out.println("Azul Systems, Inc. AzulInspector Check version 3.0");
        System.out.println("\nCopyright Azul Systems Inc. 2015");
        System.out.println("Please refer to the License file for terms of use.");
        System.out.println("\nStarting " + new Date());
        verbose = Boolean.parseBoolean(System.getProperty("verbose", "false"));
        addsearch = Boolean.parseBoolean(System.getProperty("addsearch", "false"));
        addfile = System.getProperty("addfile", "");
        compare = Boolean.parseBoolean(System.getProperty("compare", "false"));
        ruleexec = Boolean.parseBoolean(System.getProperty("ruleexec", "false"));
        printextract = Boolean.parseBoolean(System.getProperty("printextract", "false"));
        rulename = System.getProperty("rulename", "");
        db = Boolean.parseBoolean(System.getProperty("db", "false"));
        dbfilename = System.getProperty("dbfilename", "");
        dbquery = System.getProperty("dbquery", "");
        dbdelete = Boolean.parseBoolean(System.getProperty("dbdelete", "false"));
        dblist = Boolean.parseBoolean(System.getProperty("dblist", "false"));
        dbwithhost = Boolean.parseBoolean(System.getProperty("dbwithhost", "false"));
        dboverride = Boolean.parseBoolean(System.getProperty("dboverride", "false"));
        dbvalues = Boolean.parseBoolean(System.getProperty("dboverride", "false"));
        dbcompareexisting = Boolean.parseBoolean(System.getProperty("dbcompareexisting", "false"));
        dbkey = Boolean.parseBoolean(System.getProperty("dbkey", "false"));
        dbupdate = Boolean.parseBoolean(System.getProperty("dbupdate", "false"));
        dbcustomer = System.getProperty("dbcustomer", "");
        dbmerge = System.getProperty("dbmerge", "");
        interactive = Boolean.parseBoolean(System.getProperty("interactive", "false"));
        String usertype = System.getenv("aicheck");
        if (usertype != null && usertype.matches(".*runCheckResults.*")) {
            if (verbose) {
                System.out.println("Customer mode enabled");
            }
            customermode = true;
        }
        if (args.length == 0 & !db & !interactive & !customermode) {
            System.out.println("\nThis prgram processes the output on AzulInspector's SystemQualification Mode");
            System.out.println("\nSynatax:");
            System.out.println("java -jar aicheck.jar azulinspector-systemqual-file.log");
            System.out.println("\n");
            System.out.println("-Dverbose=true|false, Diagnostic output, default false ");
            System.out.println("-Daddsearch=true|false, Reads file aicheck.search in the current directory. This provides a way to add custom search strings for processing (see additional help), default false ");
            System.out.println("-Daddfile=filename, Reads file aicheck.<filename> in the current directory. This provides a way to add custom search strings for processing (see additional help), default search ");
            System.out.println("-Druleexec=true|false, Execute a specfic set of rules rather than the complete set, default false ");
            System.out.println("-Drulename=string-comma-seperated, List of rule names to execute, default all if not specified ");
            System.out.println("-Dprintextract=true|false, Print the extacted data from the AzulInspector log before running rules, default false ");
            System.out.println("-Dcompare=true|false, Compares Linux and JVM Args between two AzulInspector logs, default false");
            System.out.println("-Ddb=true|false, Uses the database to load and save this inspection to the db, default false");
            System.out.println("-Ddbquery=string, Looks up the string in the database, default none");
            System.out.println("-Ddbfilename=string, custom database file name, default none");
            System.out.println("-Ddbwithhost=true|false, report query results with hostname, default none");
            System.out.println("-Ddbdelete=true|false, removes this system from the DB and reduces the associated parameter counters, default false");
            System.out.println("-Ddbmerge=string, add this DB to the default or custom DB, default none");
            System.out.println("-Ddblist=true|false, display what systems are included in the DB and the original azulinspector file, default none");
            System.out.println("-Ddbvalues=true|false, display parameter value ranges and differences on a add/update request, default false");
            System.out.println("-Ddbcompareexisting=true|false, compare AzulInspector log to existing DB entry for the same host, default false");
            System.out.println("-Ddbkey=true|false, use mnemmonic rather than eyecatcher in query, default false");
            System.out.println("-Ddbcustomer=string, expression string match host and filename lookup, default blank");
            System.out.println("-Ddbupdate=true|false, update existing server in the database, default false");
            System.out.println("-Dinteractive=true|false, Run in interactive mode, default false ");
            System.out.println("\n");
            System.out.println("Available mnemonics available when -Ddbkey=true is used with a query:");
            for (int n = 0; n < eyecatcher.length; ++n) {
                System.out.print(eyecatcher[n][0] + " ");
            }
            System.out.println("\n");
            return;
        }
        if (args.length > 0) {
            filename = args[0];
            filename1 = "";
            if (compare) {
                filename1 = args[1];
            }
            for (key = 0; key < searchStrings.length; ++key) {
                if (customermode) {
                    if (verbose) {
                        System.out.println("Customer Mode " + searchStrings[key][5] + " Key " + key);
                    }
                    if (searchStrings[key][5].matches("azul")) {
                        for (int move = key; move < searchStrings.length - 1 && !searchStrings[key][0].isEmpty(); ++move) {
                            for (int field = 0; field < 6; ++field) {
                                Main.searchStrings[move][field] = searchStrings[move + 1][field];
                            }
                        }
                    }
                }
                if (!searchStrings[key][0].isEmpty()) continue;
                searchStringsMax = key;
                break;
            }
        }
        if (interactive) {
            for (key = 0; key < searchStrings.length; ++key) {
                if (!searchStrings[key][0].isEmpty()) continue;
                searchStringsMax = key;
                break;
            }
            if (addsearch) {
                Main.AddSearchStrings();
            }
            Main.dbload();
            Main.interactive();
            return;
        }
        if (db) {
            Main.dbload();
            if (!dbquery.isEmpty()) {
                Main.dbquery();
                return;
            }
            if (dblist) {
                Main.dblist();
                return;
            }
        }
        if (!dbmerge.isEmpty()) {
            System.out.println("DBMerge ");
            System.out.println("Merge file " + dbmerge + " to " + dbfilename);
            Main.dbmerge();
            Main.dbwrite();
            return;
        }
        if (verbose) {
            System.out.println("SearchString Initialized size " + searchStringsMax + " Max Size " + searchStrings.length);
        }
        if (addsearch) {
            Main.AddSearchStrings();
        }
        if (compare) {
            Main.compare(filename, filename1);
            System.out.println("Completed " + new Date());
            return;
        }
        if (verbose) {
            Main.SearchStringsDump();
        }
        Main.ReadFile(filename);
        if (myList.size() == 0) {
            return;
        }
        Main.ProcessFile();
        if (printextract) {
            Main.PrintData();
        }
        if (dbcompareexisting) {
            Main.dbcompareexisiting();
            return;
        }
        if (dbupdate) {
            Main.dbupdate();
            System.out.println("\nSystem " + aidata.get("hostname") + " updated");
            return;
        }
        Main.ExecRules();
        if (db) {
            Main.dbrecord();
            Main.dbwrite();
        }
        System.out.println("\nCompleted " + new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ReadFile(String filename) throws IOException {
        if (verbose) {
            System.out.println(new Date() + " Reading file " + filename);
        }
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(filename));
            while ((str = in.readLine()) != null) {
                if (!Main.checkjunk(str)) continue;
                if (verbose) {
                    System.out.println("ReadFile: Adding line from file");
                }
                myList.add(str);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("\nFile " + filename + " not found, verify name and path.");
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
                if (verbose) {
                    System.out.println(new Date() + " Completed file " + filename + " Size of Arrary " + myList.size());
                }
            }
        }
    }

    public static int Find(int a, int b) {
        String pattern;
        Pattern r;
        Matcher m;
        int i;
        if (verbose) {
            System.out.println(new Date() + " Locating " + searchStrings[a][1] + " Search size " + myList.size() + " Starting position " + b);
        }
        for (i = b; i < myList.size() && !(searchStrings[a][1].contains("\\") ? (m = (r = Pattern.compile(pattern = searchStrings[a][1])).matcher(myList.get(i))).find() : myList.get(i).contains(searchStrings[a][1])); ++i) {
        }
        if (verbose) {
            System.out.println(new Date() + " Located item at " + i);
        }
        foundline = i;
        if (i == myList.size()) {
            i = -1;
            if (verbose) {
                System.out.println(new Date() + "Item not found");
            }
            return i;
        }
        if (myList.get(i).contains("No such file or directory") || myList.get(i + 1).contains("No such file or directory") || myList.get(i + 1).contains("Command not found or incorrect user privileges")) {
            i = -2;
            if (verbose) {
                System.out.println(new Date() + " Command not found" + i);
            }
        } else if (myList.get(i + 1).isEmpty() && myList.get(i).contains("] 0")) {
            if (verbose) {
                System.out.println(new Date() + "Next time empty " + myList.get(i) + "\n" + myList.get(i + 1));
            }
            i = -2;
        }
        if (i > 0) {
            if (searchStrings[a][2].equals("nextline")) {
                aidataFound.put(searchStrings[a][0], 1);
                ++i;
            }
            if (searchStrings[a][2].equals("nextlineall")) {
                int n;
                if (aidataFound.get(searchStrings[a][0]) == null) {
                    n = 1;
                } else {
                    n = (Integer)aidataFound.get(searchStrings[a][0]);
                    ++n;
                }
                aidataFound.put(searchStrings[a][0], n);
                ++i;
            }
            if (searchStrings[a][2].equals("sameline")) {
                aidataFound.put(searchStrings[a][0], 1);
            }
            if (searchStrings[a][2].equals("samelineall")) {
                int n;
                if (aidataFound.get(searchStrings[a][0]) == null) {
                    n = 1;
                } else {
                    n = (Integer)aidataFound.get(searchStrings[a][0]);
                    ++n;
                }
                aidataFound.put(searchStrings[a][0], n);
            }
        }
        return i;
    }

    public static void SearchStringsDump() {
        System.out.println("Search Strings size " + searchStrings.length + " initalized " + searchStringsMax);
        for (int a1 = 0; a1 < searchStringsMax; ++a1) {
            System.out.print("(" + a1 + ")");
            for (int a2 = 0; a2 < 6; ++a2) {
                System.out.print(" (" + a2 + ")");
                System.out.print("  " + searchStrings[a1][a2]);
            }
            System.out.println();
        }
    }

    public static void PrintData() {
        for (int a = 0; a < searchStringsMax; ++a) {
            int n;
            System.out.println("[" + a + "] " + searchStrings[a][0] + " = " + aidata.get(searchStrings[a][0]));
            if (aidataFound.get(searchStrings[a][0]) == null || (n = ((Integer)aidataFound.get(searchStrings[a][0])).intValue()) <= 1) continue;
            System.out.println(" elements " + n);
            for (int m = 1; m < n; ++m) {
                String key = searchStrings[a][0] + "" + m;
                System.out.println(m + " " + aidataList.get(key));
            }
        }
    }

    public static void ProcessFile() {
        for (int a = 0; a < searchStringsMax; ++a) {
            int c = 0;
            while (c <= myList.size()) {
                result = Main.Find(a, c);
                if (verbose) {
                    System.out.println("Find Result: " + result);
                }
                if (result > 0) {
                    c = result + 1;
                    temp = myList.get(result);
                    az = temp.split(searchStrings[a][3], 10);
                    if (verbose) {
                        System.out.println("created " + az.length + " elements take:" + searchStrings[a][4]);
                        System.out.println("Line: " + temp);
                        for (int b = 0; b < az.length; ++b) {
                            System.out.println(b + " = " + az[b]);
                        }
                    }
                    int n = aidataFound.get(searchStrings[a][0]) != null ? (Integer)aidataFound.get(searchStrings[a][0]) : 1;
                    String key = searchStrings[a][0] + "" + n;
                    offset = Integer.parseInt(searchStrings[a][4]);
                    if (offset >= az.length) {
                        aidata.put(searchStrings[a][0], az[0]);
                        if (!searchStrings[a][2].equals("samelineall")) continue;
                        aidataList.put(key, az[0]);
                        continue;
                    }
                    aidata.put(searchStrings[a][0], az[Integer.parseInt(searchStrings[a][4])]);
                    if (!searchStrings[a][2].equals("samelineall")) continue;
                    aidataList.put(key, az[Integer.parseInt(searchStrings[a][4])]);
                    continue;
                }
                c = result == -1 ? myList.size() + 1 : foundline + 2;
                if (!verbose) continue;
                System.out.println("Search resuming at " + c);
            }
        }
    }

    private static void AddSearchStrings() {
        String cfgfile = "";
        cfgfile = addfile.isEmpty() ? "aicheck.search" : "aicheck." + addfile;
        System.out.println("Adding search criteria from file " + cfgfile);
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(cfgfile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int n = searchStringsMax;
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("#")) continue;
                az = strLine.split(",");
                if (verbose) {
                    System.out.println("Line: " + strLine);
                    System.out.println("Line contains " + az.length + " elements SearchStrings Size " + searchStrings.length + " Initalized " + n);
                }
                for (int b = 0; b < az.length; ++b) {
                    Main.az[b] = az[b].trim();
                    if (verbose) {
                        System.out.println(b + " = " + az[b]);
                    }
                    Main.searchStrings[n][b] = az[b];
                }
                ++n;
            }
            fstream.close();
            in.close();
            br.close();
            System.out.println("Total search strings loaded from file " + (n - searchStringsMax));
            searchStringsMax = n;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String CheckRuleResult(String string, int i) {
        String[] a = string.split("\\s+");
        if (i > a.length) {
            i = 0;
        }
        return a[i];
    }

    private static int CheckRules(String string) {
        int n = 0;
        int a = -1;
        for (a = 0; a < searchStrings.length && !searchStrings[a][0].matches(string); ++a) {
        }
        if (a < 0) {
            return 0;
        }
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        bundleresult = Main.bundleresult(".*", airesults);
        n = Integer.parseInt(bundleresult[0]);
        return n;
    }

    private static void CheckRulesPrint(String string) {
        int n = 0;
        int a = -1;
        for (a = 0; a < searchStrings.length && !searchStrings[a][0].matches(string); ++a) {
        }
        if (a < 0) {
            return;
        }
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        bundleresult = Main.bundleresult(".*", airesults);
        n = Integer.parseInt(bundleresult[0]);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            Main.printbundle(bundleresult);
        }
    }

    private static void ExecRules() {
        for (int a = 0; a < searchStringsMax; ++a) {
            try {
                Object o;
                Method m;
                Class<?> c;
                if (ruleexec) {
                    if (rulename.contains(searchStrings[a][0])) {
                        if (verbose) {
                            System.out.println("selective rule exec:" + searchStrings[a][0]);
                        }
                        c = Class.forName("aicheck.Main");
                        m = c.getDeclaredMethod(searchStrings[a][0], Integer.TYPE);
                        m.setAccessible(true);
                        o = m.invoke((Object)m, a);
                        if (dbvalues) {
                            Main.dbmatchcommon(searchStrings[a][1]);
                        }
                    }
                } else {
                    if (verbose) {
                        System.out.println("Invoking rule:" + searchStrings[a][0]);
                    }
                    c = Class.forName("aicheck.Main");
                    m = c.getDeclaredMethod(searchStrings[a][0], Integer.TYPE);
                    m.setAccessible(true);
                    o = m.invoke((Object)m, a);
                    if (dbvalues) {
                        Main.dbmatchcommon(searchStrings[a][1]);
                    }
                }
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Main.genricRule(a);
            }
            catch (SecurityException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!dbvalues) continue;
            Main.dbmatchcommon(searchStrings[a][1]);
        }
    }

    public static String[] bundleresult(String bundlestring, List airesults) {
        String[] brdata = new String[airesults.size() + 1];
        String[] br = bundlestring.split("\\|");
        String[] bresult = new String[airesults.size() + 1];
        int i = 1;
        int brsize = 0;
        String temp = "ERROR";
        if (verbose) {
            System.out.println("[BundleResult] - Start (brdata)" + brdata.length + " (br)" + br.length + " (brstring)" + bundlestring);
        }
        ListIterator airesultsI = airesults.listIterator();
        while (airesultsI.hasNext()) {
            if (airesults.toString() != null) {
                temp = airesultsI.next().toString();
            }
            if (Arrays.asList(brdata).indexOf(temp) == -1) {
                brdata[i] = temp;
                ++i;
                if (verbose) {
                    System.out.println("[BundleResult] Add: " + temp);
                }
            } else if (verbose) {
                System.out.println("[BundleResult] Dedupe Bundle: " + brdata[Arrays.asList(brdata).indexOf(temp)] + " Add: " + temp + " Index: " + Arrays.asList(brdata).indexOf(temp));
            }
            brsize = i;
        }
        if (verbose) {
            System.out.println("[BundleResult] result size " + brsize);
            for (int y = 0; y < brsize; ++y) {
                System.out.println("[BundleResult] [" + y + "]=" + brdata[y]);
            }
            System.out.println("[BundleResult] search string " + bundlestring);
        }
        i = 1;
        for (int b = 0; b < br.length; ++b) {
            for (int c = 1; c < brsize; ++c) {
                if (verbose) {
                    System.out.println("[BundleResult] B:" + b + " C:" + c + " BRSize:" + brsize);
                    System.out.println("[BundleResult] String >" + br[b] + "< Data >" + brdata[c] + "<");
                }
                if (!brdata[c].matches(br[b])) continue;
                if (verbose) {
                    System.out.println("[BundleResult] " + br[b] + " Found " + brdata[c]);
                }
                bresult[i] = brdata[c];
                ++i;
            }
        }
        i = i > 1 ? --i : 0;
        bresult[0] = Integer.toString(i);
        if (verbose) {
            System.out.println("[BundleResult] Result: " + bresult[0]);
        }
        return bresult;
    }

    private static boolean checkjunk(String str) {
        boolean a = true;
        if (verbose) {
            System.out.println("CheckJunk: Checking line");
        }
        for (int i = 0; i < junk.length; ++i) {
            if (!str.matches(junk[i])) continue;
            a = false;
            if (!verbose) break;
            System.out.println("CheckJunk: Found Junk [i]" + i + " " + str);
            break;
        }
        return a;
    }

    private static List collectresults(int a) {
        LinkedList results = new LinkedList();
        if (verbose) {
            System.out.println("[CollectResults] (a)" + a + " = " + aidata.get(searchStrings[a][1]) + " Find " + searchStrings[a][1]);
        }
        if (interactive && !interactive_load) {
            if (verbose) {
                System.out.println("Interactive mode collect results for " + searchStrings[a][1]);
            }
            dbquery = searchStrings[a][1];
            return Main.dbquery(a);
        }
        if (aidata.containsKey(searchStrings[a][0])) {
            int n;
            results.add(aidata.get(searchStrings[a][0]));
            if (aidataFound.get(searchStrings[a][0]) != null && (n = ((Integer)aidataFound.get(searchStrings[a][0])).intValue()) > 1) {
                if (verbose) {
                    System.out.println("[CollectResults] located " + n + " additional elements");
                }
                for (int m = 1; m < n; ++m) {
                    String key = searchStrings[a][0] + "" + m;
                    if (verbose) {
                        System.out.println("[CollectResults] " + m + " ADD: " + aidataList.get(searchStrings[a][0] + "" + m));
                    }
                    results.add(aidataList.get(key));
                }
            }
        }
        return results;
    }

    private static void compare(String filename, String filename1) {
        int f;
        if (verbose) {
            System.out.println("[Compare] Starting");
        }
        ArrayList<String> comp0 = new ArrayList<String>();
        ArrayList<String> comp1 = new ArrayList<String>();
        ArrayList compRem = new ArrayList();
        String[] filenames = new String[]{filename, filename1};
        for (f = 0; f < filenames.length; ++f) {
            if (verbose) {
                System.out.println("[Compare] Loading file " + filenames[f]);
            }
            try {
                myList.clear();
                Main.ReadFile(filenames[f]);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (f == 0) {
                for (String fileline : myList) {
                    if (!fileline.matches("^\\[1\\].*|^\\[4\\].*|^\\[11\\].*|^\\[12\\].*|^\\[23\\].*|^\\[25\\].*|^\\[26\\].*|^\\[29\\].*|^\\[33\\].*|^\\[37\\].*|^\\[38\\] clock-delta.*|^\\[45\\].*|^\\[60\\].*|^\\[61\\].*|^\\[JCMD 11\\].*=.*|.*JVM Args.*")) continue;
                    comp0.add(fileline);
                }
                System.out.println("Found entries " + comp0.size());
            }
            if (f != 1) continue;
            for (String fileline : myList) {
                if (!fileline.matches("^\\[1\\].*|^\\[4\\].*|^\\[11\\].*|^\\[12\\].*|^\\[23\\].*|^\\[25\\].*|^\\[26\\].*|^\\[29\\].*|^\\[33\\].*|^\\[37\\].*|^\\[38\\] clock-delta.*|^\\[45\\].*|^\\[60\\].*|^\\[61\\].*|^\\[JCMD 11\\].*=.*|.*JVM Args.*")) continue;
                comp1.add(fileline);
            }
            System.out.println("Found entries " + comp1.size());
        }
        for (int f0 = 0; f0 < comp0.size(); ++f0) {
            for (int f1 = 0; f1 < comp1.size(); ++f1) {
                if (!((String)comp0.get(f0)).equals(comp1.get(f1))) continue;
                compRem.add(comp0.get(f0));
            }
        }
        System.out.println("\n");
        comp0.removeAll(compRem);
        comp1.removeAll(compRem);
        System.out.println("Settings that are different from: " + filename);
        for (f = 0; f < comp0.size(); ++f) {
            System.out.println((String)comp0.get(f));
        }
        System.out.println("Settings that are different from: " + filename1);
        for (f = 0; f < comp1.size(); ++f) {
            System.out.println((String)comp1.get(f));
        }
    }

    private static void dbcompareexisiting() {
        System.out.println("\nComparing existing host " + aidata.get("hostname"));
        System.out.println("Database data from " + dbname.get(aidata.get("hostname")) + " Found " + dbhost.containsValue(aidata.get("hostname")));
        System.out.println("Comparison from AzulInspector file " + filename);
        ArrayList dbkeys = new ArrayList(dbhost.keySet());
        ArrayList<String> keep = new ArrayList<String>();
        for (String infile : myList) {
            if (!infile.matches("^\\[1\\].*|^\\[2\\].*|^\\[3\\].*|^\\[4\\].*|^\\[11\\].*|^\\[12\\].*|^\\[19\\].*|^\\[23\\].*|^\\[25\\].*|^\\[26\\].*|^\\[29\\].*|^\\[33\\].*|^\\[37\\].*|^\\[38\\] clock-delta.*|^\\[45\\].*|^\\[60\\].*|^\\[61\\].*|^\\[70\\].*") || dbkeys.contains(infile)) continue;
            keep.add(infile);
        }
        System.out.println("\nDifferences between Database version and AzulInspector file");
        for (String value : keep) {
            System.out.println(value);
        }
    }

    private static void dblist() {
        System.out.println("\nThe following systems are in this database");
        Object[] a = dbname.keySet().toArray();
        if (a.length <= 0) {
            System.out.println("Error no systems are in the database, are the aicheck*.db files in the current directory");
            System.out.println("Did mean to use a specific database, use -Ddbfilename=<dbfilename> for a custom DB.");
            return;
        }
        Arrays.sort(a, 1, a.length);
        System.out.println(String.format("%-15s%s", "Hostname", " AzulInspector File"));
        for (int n = 0; n < a.length; ++n) {
            System.out.print(String.format("%-15s", a[n]));
            System.out.println(" " + dbname.get(a[n]));
        }
        System.out.println("\nNumber of systems in database " + a.length);
    }

    private static void dbload() {
        String[] filenames = new String[]{"aicheck.dbcommon.db", "aicheck.dbname.db", "aicheck.dbparm.db", "aicheck.dbhost.db"};
        try {
            for (int f = 0; f < filenames.length; ++f) {
                if (!dbfilename.isEmpty()) {
                    if (dbfilename.contains("/")) {
                        String path = filenames[f].substring(8);
                        filenames[f] = filenames[f].replaceFirst("aicheck", dbfilename);
                    } else {
                        filenames[f] = filenames[f].replaceFirst("aicheck", "aicheck." + dbfilename);
                    }
                    if (verbose) {
                        System.out.println("[dbload] Loading custom database file " + filenames[f]);
                    }
                }
                if (verbose) {
                    System.out.println("[dbload] starting load from " + filenames[f]);
                }
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(filenames[f]));
                switch (f) {
                    case 0: {
                        dbcommon.clear();
                        dbcommon = (HashMap)in.readObject();
                        break;
                    }
                    case 1: {
                        dbname.clear();
                        dbname = (Hashtable)in.readObject();
                        break;
                    }
                    case 2: {
                        dbparm.clear();
                        dbparm = (HashMap)in.readObject();
                        break;
                    }
                    case 3: {
                        dbhost.clear();
                        dbhost = (HashMap)in.readObject();
                    }
                }
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.print("DB initalizing new file");
        }
        catch (Exception e) {
            System.out.println("DB Error during Load");
            e.printStackTrace();
        }
    }

    private static void dbmerge() {
        String[] filenames = new String[]{"aicheck.dbcommon.db", "aicheck.dbname.db", "aicheck.dbparm.db", "aicheck.dbhost.db"};
        HashMap dbcommonM = new HashMap();
        Hashtable dbnameM = new Hashtable();
        HashMap dbparmM = new HashMap();
        HashMap dbhostM = new HashMap();
        System.out.println("[dmgerge] starting common " + dbcommon.size());
        System.out.println("[dmgerge] starting name " + dbname.size());
        System.out.println("[dmgerge] starting parm " + dbparm.size());
        System.out.println("[dmgerge] starting host " + dbhost.size());
        try {
            for (int f = 0; f < filenames.length; ++f) {
                if (!dbmerge.isEmpty()) {
                    filenames[f] = filenames[f].replaceFirst("aicheck", "aicheck." + dbmerge);
                    if (verbose) {
                        System.out.println("[dbmerge] Loading custom database file " + filenames[f]);
                    }
                }
                if (verbose) {
                    System.out.println("[dbmerge] starting load from " + filenames[f]);
                }
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(filenames[f]));
                switch (f) {
                    case 0: {
                        dbcommonM = (HashMap)in.readObject();
                        break;
                    }
                    case 1: {
                        dbnameM = (Hashtable)in.readObject();
                        break;
                    }
                    case 2: {
                        dbparmM = (HashMap)in.readObject();
                        break;
                    }
                    case 3: {
                        dbhostM = (HashMap)in.readObject();
                    }
                }
                in.close();
            }
            System.out.println("[dmgerge] merge common " + dbcommonM.size());
            System.out.println("[dmgerge] merge name " + dbnameM.size());
            System.out.println("[dmgerge] merge parm " + dbparmM.size());
            System.out.println("[dmgerge] merge host " + dbhostM.size());
            Object[] keyset = dbcommonM.keySet().toArray();
            for (int key = 0; key < keyset.length; ++key) {
                if (dbcommon.get(keyset[key]) == null) {
                    dbcommon.put((String)keyset[key], (Integer)dbcommonM.get(keyset[key]));
                    continue;
                }
                int original = dbcommon.get(keyset[key]);
                int merge = (Integer)dbcommonM.get(keyset[key]);
                int newvalue = original + merge;
                dbcommon.put((String)keyset[key], newvalue);
            }
            Set set = dbnameM.entrySet();
            for (Map.Entry me : set) {
                if (dbname.containsKey(me.getKey())) continue;
                dbname.put(me.getKey(), me.getValue());
            }
            set = dbparmM.entrySet();
            for (Map.Entry me : set) {
                if (dbparm.containsKey(me.getKey())) continue;
                dbparm.put(me.getKey(), me.getValue());
            }
            set = dbhostM.entrySet();
            for (Map.Entry me : set) {
                if (dbhost.containsKey(me.getKey())) continue;
                dbhost.put(me.getKey(), me.getValue());
            }
        }
        catch (Exception e) {
            System.out.println("DB Error during merge");
            e.printStackTrace();
            return;
        }
        System.out.println("[dmgerge] completed common " + dbcommon.size());
        System.out.println("[dmgerge] completed name " + dbname.size());
        System.out.println("[dmgerge] completed parm " + dbparm.size());
        System.out.println("[dmgerge] completed name " + dbhost.size());
    }

    private static void dbmatchcommon(String dbmatch) {
        if (verbose) {
            System.out.println("[DBMatchCommon] ");
        }
        Object[] keyset = dbcommon.keySet().toArray();
        if (dbmatch.matches("^\\[.\\].*")) {
            dbmatch = dbmatch.substring(dbmatch.indexOf("]") + 1);
        }
        if (verbose) {
            System.out.println("[DBMatchCommon] Result from bundle " + dbmatch);
        }
        int showheader = 0;
        for (int key = 0; key < keyset.length; ++key) {
            if (!keyset[key].toString().matches(".*" + dbmatch + ".*")) continue;
            if (++showheader == 1) {
                System.out.println("\nComparing this systems parameters to other systems in the database");
            }
            System.out.println(keyset[key] + " from " + dbcommon.get(keyset[key]) + " system profiles");
        }
    }

    private static void dbquery() {
        if (dbkey) {
            Main.dbquerykey();
        }
        System.out.println("");
        if (verbose) {
            System.out.println("[DBQuery] " + dbquery);
        }
        Object[] keyset = dbcommon.keySet().toArray();
        Object[] customerFile = dbname.keySet().toArray();
        Main.querystats_[0] = 0L;
        Main.querystats_[1] = 0L;
        Main.querystats_[2] = 0L;
        querystats_common = "";
        if (verbose) {
            System.out.println("[DBMatchCommon] Result from bundle " + dbquery);
        }
        int found = 0;
        String[] searchkey = dbquery.split("\\|");
        if (verbose) {
            System.out.print("[DBQuery(a) number of search keys " + searchkey.length);
        }
        for (int k = 0; k < searchkey.length; ++k) {
            dbquery = searchkey[k];
            if (verbose) {
                System.out.println("[DBQuery(a) key (k)" + k + " (dbquery)" + dbquery);
            }
            for (int key = 0; key < keyset.length; ++key) {
                if (!keyset[key].toString().matches(".*" + dbquery + ".*")) continue;
                if (!dbcustomer.isEmpty()) {
                    for (int name = 0; name < customerFile.length; ++name) {
                        if (verbose) {
                            System.out.println(keyset[key] + " " + dbcustomer + "**** Key:" + key + " Name:" + customerFile[name] + " name " + dbname.get(customerFile[name]));
                        }
                        if (!customerFile[name].toString().matches(".*" + dbcustomer + ".*") && !dbname.get(customerFile[name]).toString().matches(".*" + dbcustomer + ".*")) continue;
                        if (verbose) {
                            System.out.println(keyset[key] + " from " + dbcommon.get(keyset[key]) + " system profiles " + customerFile[name] + " " + dbname.get(customerFile[name]) + " dbhost " + dbhost.get(keyset[key]));
                        }
                        if (!dbhost.get(keyset[key]).toString().matches(".*" + dbcustomer + ".*")) continue;
                        System.out.println(keyset[key] + " from " + dbcommon.get(keyset[key]) + " system profiles " + customerFile[name] + " " + dbname.get(customerFile[name]));
                        Main.querystats(keyset[key], dbcommon.get(keyset[key]));
                        ++found;
                    }
                    continue;
                }
                System.out.print(keyset[key] + " from " + dbcommon.get(keyset[key]) + " system profiles");
                Main.querystats(keyset[key], dbcommon.get(keyset[key]));
                ++found;
                if (dbwithhost) {
                    System.out.println(" on host " + dbhost.get(keyset[key]));
                    continue;
                }
                System.out.println();
            }
        }
        System.out.print("\nFound " + found + " matches");
        if (!dbcustomer.isEmpty()) {
            System.out.print(" restricted to customer " + dbcustomer);
        } else {
            System.out.print("");
        }
        System.out.print(" common setting (" + querystats_[2] + ") = " + querystats_common);
        System.out.println(" minimum value " + querystats_[0] + " maximum value " + querystats_[1]);
    }

    private static List dbquery(int a) {
        if (dbkey) {
            Main.dbquerykey();
        }
        if (verbose) {
            System.out.println("[DBQuery(a)] " + dbquery);
        }
        LinkedList<String> results = new LinkedList<String>();
        Object[] keyset = dbcommon.keySet().toArray();
        Object[] customerFile = dbname.keySet().toArray();
        String[] searchkey = dbquery.split("\\|");
        if (verbose) {
            System.out.print("[DBQuery(a) number of search keys " + searchkey.length);
        }
        for (int k = 0; k < searchkey.length; ++k) {
            dbquery = searchkey[k];
            if (verbose) {
                System.out.println("[DBQuery(a) key (k)" + k + " (dbquery)" + dbquery);
            }
            for (int key = 0; key < keyset.length; ++key) {
                if (!keyset[key].toString().matches(".*" + dbquery + ".*")) continue;
                results.add(keyset[key] + " from " + dbcommon.get(keyset[key]) + " system profiles");
            }
        }
        return results;
    }

    private static void dbquerykey() {
        String newquery = null;
        for (int n = 0; n < eyecatcher.length; ++n) {
            if (!eyecatcher[n][0].matches(dbquery)) continue;
            newquery = eyecatcher[n][1];
            break;
        }
        if (newquery != null) {
            dbquery = newquery;
        }
    }

    private static void dbrecord() {
        if (dbdelete) {
            if (verbose) {
                System.out.println("[dbrecord] Deleting system and parameters");
            }
            dbname.remove(aidata.get("hostname"));
        } else {
            if (dbname.containsKey(aidata.get("hostname")) && !dboverride) {
                System.out.println("\nThis system is already in the database, exiting without adding system. ");
                System.out.println("System: " + aidata.get("hostname"));
                return;
            }
            dbname.put(aidata.get("hostname"), filename);
            if (verbose) {
                System.out.println("[DBRECORD] " + aidata.get("hostname") + " AS " + dbname);
            }
        }
        ArrayList<String> comp0 = new ArrayList<String>();
        ArrayList compRem = new ArrayList();
        for (String fileline : myList) {
            if (!fileline.matches("^\\[1\\].*|^\\[2\\].*|^\\[3\\].*|^\\[4\\].*|^\\[11\\].*|^\\[12\\].*|^\\[19\\].*|^\\[23\\].*|^\\[25\\].*|^\\[26\\].*|^\\[29\\].*|^\\[33\\].*|^\\[37\\].*|^\\[38\\] clock-delta.*|^\\[45\\].*|^\\[60\\].*|^\\[61\\].*|^\\[70\\].*")) continue;
            comp0.add(fileline);
        }
        System.out.println("Found db keys " + comp0.size() + " Common " + dbcommon.size());
        for (int f0 = 0; f0 < comp0.size(); ++f0) {
            Object a;
            int count;
            if (!dbcommon.containsKey(comp0.get(f0))) continue;
            if (verbose) {
                System.out.println("DBRecord Match:" + (String)comp0.get(f0) + " Data:" + dbcommon.get(comp0.get(f0)));
            }
            compRem.add(comp0.get(f0));
            if (dbcommon.containsKey(comp0.get(f0))) {
                count = dbcommon.get(comp0.get(f0));
                ++count;
            } else {
                count = 1;
            }
            if (dbdelete) {
                if (--count <= 1) {
                    dbcommon.remove(comp0.get(f0));
                    dbhost.remove(comp0.get(f0));
                } else {
                    dbcommon.put((String)comp0.get(f0), count);
                    a = dbhost.get(comp0.get(f0));
                    a = a.toString().replaceFirst((String)aidata.get("hostname"), "");
                    dbhost.put(comp0.get(f0), a);
                }
                if (!verbose) continue;
                System.out.println("DBRecords delete reduce count Data:" + dbcommon.get(comp0.get(f0)));
                continue;
            }
            dbcommon.put((String)comp0.get(f0), count);
            a = null;
            Object b = aidata.get("hostname");
            if (dbhost.size() > 0) {
                a = dbhost.get(comp0.get(f0));
                if (a.toString().matches(".*" + b + ".*")) continue;
                dbhost.put(comp0.get(f0), a + " " + b);
                continue;
            }
            dbhost.put(comp0.get(f0), b);
        }
        comp0.removeAll(compRem);
        if (dbdelete) {
            System.out.println("\nSystem " + aidata.get("hostname") + " deleted");
            return;
        }
        if (verbose || dbvalues) {
            System.out.println("Settings that are missing based on common settings " + comp0.size());
        }
        int count = 1;
        for (int f = 0; f < comp0.size(); ++f) {
            if (verbose || dbvalues) {
                System.out.println((String)comp0.get(f));
            }
            dbcommon.put((String)comp0.get(f), count);
            dbhost.put(comp0.get(f), aidata.get("hostname"));
        }
    }

    private static void dbupdate() {
        System.out.println("\nUpdate existing host " + aidata.get("hostname"));
        System.out.println("Database data from " + dbname.get(aidata.get("hostname")));
        System.out.println("Updates from AzulInspector file " + filename);
        if (!dbhost.containsValue(aidata.get("hostname"))) {
            System.out.println("Server not found in database.");
            return;
        }
        dbname.put(aidata.get("hostname"), filename);
        String hostname = (String)aidata.get("hostname");
        ArrayList dbkeys = new ArrayList(dbhost.keySet());
        myList.clear();
        for (String infile : dbkeys) {
            if (!dbhost.get(infile).toString().contains(hostname)) continue;
            myList.add(infile);
        }
        System.out.println("\n[dbupdate] starting common " + dbcommon.size());
        System.out.println("[dbupdate] starting name " + dbname.size());
        System.out.println("[dbupdate] starting parm " + dbparm.size());
        System.out.println("[dbupdate] starting host " + dbhost.size() + "\n");
        dbdelete = true;
        Main.dbrecord();
        dbdelete = false;
        System.out.println("[dbupdate] delete common " + dbcommon.size());
        System.out.println("[dbupdate] delete name " + dbname.size());
        System.out.println("[dbupdate] delete parm " + dbparm.size());
        System.out.println("[dbupdate] delete host " + dbhost.size() + "\n");
        try {
            Main.ReadFile(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        Main.ProcessFile();
        Main.dbrecord();
        Main.dbwrite();
        System.out.println("[dbupdate] complete common " + dbcommon.size());
        System.out.println("[dbupdate] complete name " + dbname.size());
        System.out.println("[dbupdate] complete parm " + dbparm.size());
        System.out.println("[dbupdate] complete host " + dbhost.size());
    }

    private static void dbwrite() {
        String[] filenames = new String[]{"aicheck.dbcommon.db", "aicheck.dbname.db", "aicheck.dbparm.db", "aicheck.dbhost.db"};
        try {
            for (int f = 0; f < filenames.length; ++f) {
                if (!dbfilename.isEmpty()) {
                    if (dbfilename.contains("/")) {
                        String path = filenames[f].substring(8);
                        filenames[f] = filenames[f].replaceFirst("aicheck", dbfilename);
                    } else {
                        filenames[f] = filenames[f].replaceFirst("aicheck", "aicheck." + dbfilename);
                    }
                    if (verbose) {
                        System.out.println("[dbwrite] Saving custom database file " + filenames[f]);
                    }
                }
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filenames[f]));
                switch (f) {
                    case 0: {
                        out.writeObject(dbcommon);
                        break;
                    }
                    case 1: {
                        out.writeObject(dbname);
                        break;
                    }
                    case 2: {
                        out.writeObject(dbparm);
                        break;
                    }
                    case 3: {
                        out.writeObject(dbhost);
                    }
                }
                out.close();
                if (!verbose) continue;
                System.out.println("Serialized data is saved " + filenames[f]);
            }
        }
        catch (IOException i) {
            i.printStackTrace();
        }
    }

    private static void genricRule(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        String filenameTrue = "aicheck." + searchStrings[a][0] + ".true";
        String filenameFalse = "aicheck." + searchStrings[a][0] + ".false";
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking " + searchStrings[a][0] + " using generic rule");
            Main.printbundle(bundleresult);
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(filenameTrue);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    System.out.println(strLine);
                }
                System.out.println("\n");
                fstream.close();
                in.close();
                br.close();
            }
            catch (Exception e) {}
        } else {
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(filenameFalse);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    System.out.println(strLine);
                }
                System.out.println("\n");
                fstream.close();
                in.close();
                br.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void interactive() {
        Console cnsl = null;
        String cmd = null;
        boolean cmdfound = false;
        System.out.println("Interactive Mode");
        while (cmd != "quit") {
            cmdfound = false;
            try {
                cnsl = System.console();
                if (cnsl != null) {
                    cmd = cnsl.readLine("AI:> ", new Object[0]);
                    if (cmd.matches("quit|q|end|exit")) {
                        return;
                    }
                    if (cmd.matches("query.*")) {
                        cmdfound = true;
                        dbquery = cmd.substring(6);
                        System.out.println("Query: " + dbquery);
                        Main.dbquery();
                    }
                    if (cmd.matches("key.*enable")) {
                        cmdfound = true;
                        dbkey = true;
                        System.out.println("Database mnemonics mode enabled");
                    }
                    if (cmd.matches("key disable")) {
                        cmdfound = true;
                        dbkey = false;
                        System.out.println("Database mnemonics mode disabled");
                    }
                    if (cmd.matches("customer enable .*")) {
                        cmdfound = true;
                        dbcustomer = cmd.substring(16);
                        System.out.println("restricting results to customer " + dbcustomer);
                    }
                    if (cmd.matches("customer disable")) {
                        cmdfound = true;
                        dbcustomer = "";
                        System.out.println("showing all results ");
                    }
                    if (cmd.matches("host enable")) {
                        cmdfound = true;
                        dbwithhost = true;
                        System.out.println("query will return hostnames");
                    }
                    if (cmd.matches("host disable")) {
                        cmdfound = true;
                        dbwithhost = false;
                        System.out.println("query will not return hostnames");
                    }
                    if (cmd.matches("interactive enable")) {
                        cmdfound = true;
                        interactive = true;
                        System.out.println("interactive mode enabled");
                    }
                    if (cmd.matches("interactive disable")) {
                        cmdfound = true;
                        interactive = false;
                        System.out.println("interactive mode disabled");
                    }
                    if (cmd.matches("key disable")) {
                        cmdfound = true;
                        dbkey = false;
                        System.out.println("Database mnemonics mode disabled");
                    }
                    if (cmd.matches("list")) {
                        cmdfound = true;
                        Main.dblist();
                    }
                    if (cmd.matches("load.*")) {
                        cmdfound = true;
                        interactive_load = true;
                        Main.ReadFile(cmd.substring(5));
                        Main.ProcessFile();
                        Main.ExecRules();
                        interactive_load = false;
                    }
                    if (cmd.matches("dbload.*")) {
                        cmdfound = true;
                        dbfilename = cmd.length() > 7 ? cmd.substring(7) : "";
                        Main.dbload();
                    }
                    if (cmd.matches("run.*")) {
                        cmdfound = true;
                        ruleexec = true;
                        if (cmd.length() > 3) {
                            rulename = cmd.substring(4);
                            System.out.println("Run rule " + rulename + " on AzulInspector file");
                        } else {
                            System.out.println("Reset rule to default list");
                            ruleexec = false;
                            rulename = "";
                        }
                        Main.ExecRules();
                    }
                    if (cmd.matches("rules")) {
                        cmdfound = true;
                        System.out.println("Available rules to execute\n");
                        for (int a = 0; a < searchStringsMax; ++a) {
                            System.out.println(searchStrings[a][0]);
                        }
                    }
                    if (cmd.matches("dbrun.*")) {
                        cmdfound = true;
                        ruleexec = true;
                        if (cmd.length() > 5) {
                            rulename = cmd.substring(6);
                            System.out.println("Run rule " + rulename + " on database");
                        } else {
                            System.out.println("Reset rule to default list");
                            ruleexec = false;
                            rulename = "";
                        }
                        Main.ExecRules();
                    }
                    if (cmd.matches("verbose on")) {
                        cmdfound = true;
                        verbose = true;
                        System.out.println("Verbose logging enabled");
                    }
                    if (cmd.matches("verbose off")) {
                        cmdfound = true;
                        verbose = false;
                        System.out.println("Verbose logging disabled");
                    }
                    if (cmd.matches("process files.*")) {
                        cmdfound = true;
                        String filenamepattern = null;
                        filenamepattern = cmd.length() > 13 ? cmd.substring(14) : ".*AzulSystemQual.*log";
                        System.out.println("Loading files using filename pattern " + filenamepattern + " Current Size " + myList.size());
                        File directory = new File(".");
                        File[] files = directory.listFiles();
                        for (int n = 0; n < files.length; ++n) {
                            Boolean a = files[n].getName().matches(filenamepattern);
                            if (!a.booleanValue()) continue;
                            System.out.println("Found " + files[n]);
                            Main.ReadFile(files[n].getName());
                        }
                        interactive = false;
                        System.out.println("Files loaded, Current Size " + myList.size());
                        Main.ProcessFile();
                        System.out.println("Processing files completed. Data Size " + aidata.size());
                        interactive = true;
                    }
                    if (cmd.matches("file query.*")) {
                        cmdfound = true;
                        String query = cmd.substring(11);
                        System.out.println("Running query " + query + " against loaded files");
                        for (int i = 0; i < myList.size(); ++i) {
                            if (myList.get(i).matches(query)) {
                                System.out.println(myList.get(i));
                            }
                            if (!verbose) continue;
                            System.out.println(i + " " + myList.get(i));
                        }
                    }
                    if (cmd.matches("help")) {
                        cmdfound = true;
                        System.out.println("Help: available commands");
                        System.out.println("quit|q|end|exit - exit interactive mode and terminate the program");
                        System.out.println("query string - execute query on the loaded database");
                        System.out.println("key enable|disable - enable or disable use of query mnemonics");
                        System.out.println("list - display list of available servers in database");
                        System.out.println("customer enable|disable string - use data for only this customer/server name");
                        System.out.println("host enable|disable - return hostnames with query results");
                        System.out.println("dbload custom-dbname - load alternative DB");
                        System.out.println("load AzulInspectorFile - load azulinspector file and run rules");
                        System.out.println("run rulename|blank- execute rule against loaded AzulInspector file");
                        System.out.println("rules - lists available rules including custom rules loaded via -Daddsearch");
                        System.out.println("dbrun rulename - execute rule against *stored* database values.");
                        System.out.println("process files pattern - load Azulinspector files into memory for rules processing");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (cmdfound) continue;
            System.out.println("Invalid command, type help for list of available commands");
        }
    }

    private static void printbundle(String[] bundleresult) {
        int bundleresultcount = Integer.parseInt(bundleresult[0]);
        if (verbose) {
            System.out.println("[PrintBundle] Result from bundle " + bundleresultcount);
        }
        if (bundleresultcount > 0) {
            for (int b = 1; b <= bundleresultcount; ++b) {
                System.out.println(bundleresult[b]);
            }
        }
    }

    private static void dedupe() {
        if (verbose) {
            System.out.println("Dedupe Starting");
        }
        String key = null;
        String compdata = null;
        int p = 0;
        for (int a = 0; a < searchStringsMax; ++a) {
            int n;
            System.out.println("[" + a + "] " + searchStrings[a][0] + " = " + aidata.get(searchStrings[a][0]) + " Count " + aidataFound.get(searchStrings[a][0]));
            if (aidataFound.get(searchStrings[a][0]) == null || (n = ((Integer)aidataFound.get(searchStrings[a][0])).intValue()) <= 1) continue;
            System.out.println(" elements " + n);
            for (int m = 1; m < n; ++m) {
                if (m == 1) {
                    key = searchStrings[a][0];
                    compdata = (String)aidata.get(key);
                    p = 1;
                } else {
                    key = searchStrings[a][0] + "" + m;
                    compdata = (String)aidataList.get(key);
                    p = m + 1;
                }
                String key1 = searchStrings[a][0] + "" + p;
                System.out.println("COMPARE:" + m + " >" + compdata + "< and " + p + " >" + aidataList.get(key1) + "<");
                if (!compdata.equals(aidataList.get(key1))) continue;
                System.out.println(m + " " + compdata + " same as " + p + " " + aidataList.get(key1));
            }
        }
    }

    private static void CheckNumaInterleave(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nRunning CheckNumaInterleave logic ");
            System.out.println("If more cores are online, than cores listed on the numactl output");
            System.out.println("then the BIOS may have interleave enabled, consider disabling it. The system may also be virtualized, if virtualized then no need to disable the BIOS setting.");
            Main.printbundle(bundleresult);
            if (Main.CheckRules("onlinecores") > 0) {
                System.out.print("Total online cores ");
                Main.CheckRulesPrint("onlinecores");
            }
            if (Main.CheckRules("hypervisor") > 0) {
                System.out.println("The system may be running on a hypervisor ! ");
                Main.CheckRulesPrint("hypervisor");
            }
        }
    }

    private static void kernel(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nRunning the kernel logic ");
            System.out.println("The following kernel strings have been found");
            Main.printbundle(bundleresult);
        }
        if (db) {
            String c = bundleresult[1];
            Main.dbmatchcommon(c);
        }
    }

    private static void hostname(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking hostname");
            System.out.println("The following hostname strings have been found");
            Main.printbundle(bundleresult);
        }
    }

    private static void minfree(int a) {
        System.out.println("\nChecking Linux min free settings");
        try {
            int n;
            int b = Integer.parseInt((String)aidata.get(searchStrings[a][0]));
            if (b < 0x100000) {
                System.out.println(searchStrings[a][1] + " " + aidata.get(searchStrings[a][0]) + " is below the recommended value of 1048576");
            }
            if (b > 0x100000) {
                System.out.println(searchStrings[a][1] + " " + aidata.get(searchStrings[a][0]) + " is above the recommended value of 1048576");
            }
            if (b == 0x100000) {
                System.out.println(searchStrings[a][1] + " " + aidata.get(searchStrings[a][0]) + " is set to the recommended value");
            }
            if (aidataFound.get(searchStrings[a][0]) != null && (n = ((Integer)aidataFound.get(searchStrings[a][0])).intValue()) > 1) {
                for (int m = 1; m < n; ++m) {
                    String key = searchStrings[a][0] + "" + m;
                    System.out.println(m + " " + aidataList.get(key));
                }
            }
            if (dbvalues) {
                String c = searchStrings[a][1];
                Main.dbmatchcommon(c);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private static void hypervisor(int a) {
        Boolean title = false;
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult("^\\[54\\].*|^\\[27\\].*Hypervisor detected.*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking Hypervisor");
            title = true;
            Main.printbundle(bundleresult);
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult("^\\[14\\].*Manufacturer.*|\\[14\\].*Product", airesults))[0]) > 0) {
            if (!title.booleanValue()) {
                System.out.println("\nChecking Hypervisor");
                title = true;
            }
            Main.printbundle(bundleresult);
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult("^\\[25\\].*", airesults))[0]) > 0) {
            if (!title.booleanValue()) {
                System.out.println("\nChecking Hypervisor");
                title = true;
            }
            System.out.println("Hypervisor memory or balloon driver detected, this should be disabled");
            Main.printbundle(bundleresult);
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult("^\\[27\\].*Boot.*bare.*|.*kvm.*", airesults))[0]) > 1) {
            if (!title.booleanValue()) {
                System.out.println("\nChecking Hypervisor");
                title = true;
            }
            System.out.println("If this reports bare hardware, this probally is not virtualized but has some of the virtual kernel modules loaded, this is not a issue.");
            Main.printbundle(bundleresult);
        }
    }

    private static void distribution(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking distribution");
            Main.printbundle(bundleresult);
        }
    }

    private static void querystats(Object object, Integer get) {
        String[] a;
        if (querystats_[2] < (long)get.intValue()) {
            Main.querystats_[2] = get.intValue();
            querystats_common = object.toString();
        }
        if ((a = object.toString().split("= ")).length < 2) {
            return;
        }
        if (a[1].matches("\\d+")) {
            long n = Long.parseLong(a[1]);
            if (querystats_[0] == 0L && querystats_[1] == 0L) {
                Main.querystats_[0] = n;
                Main.querystats_[1] = n;
            }
            if (querystats_[0] > n) {
                Main.querystats_[0] = n;
            }
            if (querystats_[1] < n) {
                Main.querystats_[1] = n;
            }
        }
    }

    private static void swaptotal(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking swaptotal");
            Main.printbundle(bundleresult);
        }
    }

    private static void osrelease(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*kernel.osrelease.*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking osrelease");
            Main.printbundle(bundleresult);
        }
    }

    private static void version(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*kernel.version.*|.*kernel.osrelease.*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking version");
            Main.printbundle(bundleresult);
            System.out.println(aidata.get("osrelease"));
        }
    }

    private static void vendors(int a) {
        List airesults = Main.collectresults(a);
        HashMap<String, Integer> venJars = new HashMap<String, Integer>();
        String[] bundleresult = Main.bundleresult(".*", airesults);
        int bundleresultcount = Integer.parseInt(bundleresult[0]);
        int count = 0;
        int cwd = 0;
        if (bundleresultcount > 0) {
            System.out.println("\nChecking Third Party Vendors");
            System.out.println("\nThese are strings from the classpath and jar files that may help identify third party vendors");
            for (int b = 1; b <= bundleresultcount; ++b) {
                String[] name = bundleresult[b].split("/|\\.jar|-|_|\\.");
                for (int l = 0; l < name.length; ++l) {
                    if (name[l].matches(".*azulinspector.*|tmp|opt|var|lib|.*[0-9].*|jre|ext|plugins|commons|modules|latest|export|webapps|logger|logging|release|XX.*|.*classpath.*|config|manager|.*=.*|runtime|EnvCheck|server|library|launcher|bootstrip|security|system|policy") || !name[l].matches(".*[aeiou].*") || name[l].length() <= 5) continue;
                    if (!venJars.containsKey(name[l])) {
                        if (!bundleresult[b].matches("\\.jar") && cwd < 3) {
                            count = 99;
                            ++cwd;
                        } else {
                            count = 1;
                        }
                    } else {
                        Object num = venJars.get(name[l]);
                        count = Integer.parseInt(num.toString());
                        ++count;
                    }
                    venJars.put(name[l], count);
                }
            }
            Iterator iterator = venJars.keySet().iterator();
            int col = 0;
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                Object value = venJars.get(key);
                int val = Integer.parseInt(value.toString());
                if (val <= 1) continue;
                System.out.print(String.format("%-20s", key));
                if (++col != 3) continue;
                col = 0;
                System.out.println();
            }
        }
        System.out.println();
    }

    private static void swappiness(int a) {
        System.out.println("\nChecking swappiness");
        try {
            int b = Integer.parseInt((String)aidata.get(searchStrings[a][0]));
            if (b > 0) {
                System.out.println(searchStrings[a][1] + " is above the recommended value (" + b + ") consider setting this to 0");
            } else {
                System.out.println(searchStrings[a][1] + " is correctly set (" + b + ")");
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private static void overcommit(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*[1-9].*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking overcommit");
            System.out.println("The linux system has memory overcommit set, this may cause issues");
            System.out.print(searchStrings[a][1] + " ");
            Main.printbundle(bundleresult);
        }
    }

    private static void oomkiller(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*[1-99].*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking oomkiller");
            System.out.println("The Linux system has the out of memory killer enabled.");
            System.out.print(searchStrings[a][1] + " ");
            Main.printbundle(bundleresult);
            System.out.println("Either disable this at a system or process level, as a Zing JVM, typically is the largest running process, so Zing will get killed is Linux triggers the OOM.");
        }
    }

    private static void oomkillercalled(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult("invoked oom-killer", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking oomkillercalled");
            System.out.println("The Linux out of memory killer (OOM-Killer) has been invoked for the following process");
            Main.printbundle(bundleresult);
            System.out.println("Investiagte these issues, as installing a large ZST may aggrevate this situation");
        }
    }

    private static void mlocked(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*[1-99999].*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking mlocked");
            System.out.println("The Linux server has some locked memory.");
            Main.printbundle(bundleresult);
            System.out.println("Investigate what process is using this memory and if its the target Zing application, can it be configured to use the heap");
        }
    }

    private static void maxcstate(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*processor.max_cstate=1.*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking processor.max_cstate");
            System.out.println("The server has a cstate setting that can cause system wide delays.");
            Main.printbundle(bundleresult);
            System.out.println("This should be changed to processor.max_cstate=0 in the /boot/grub/menu.lst");
        }
    }

    private static void x11(int a) {
        List airesults = Main.collectresults(a);
        Boolean title = false;
        String[] bundleresult = Main.bundleresult(".*[Xx]11.*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking x11");
            title = true;
            System.out.println("Some X11 graphic modules are installed, verify that the System does not run a GUI ");
            System.out.println("A total of " + bundleresult[0] + " packages were found");
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult(".*\\[43\\].*id\\:5\\:initdefault.*", airesults))[0]) > 0) {
            if (!title.booleanValue()) {
                System.out.println("\nChecking x11");
                title = true;
            }
            System.out.println("This system is running in GUI MODE ! This increases Jitter and uses valuable Linux Memory! ");
            System.out.println("Change /etc/inittab line:  id:5:initdefault to  id:3:initdefault then reboot if you dont need a GUI");
        }
        System.out.println();
    }

    private static void nics(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*Link is Up.*|.*Link is up.*|.*link up.*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking Nics");
            System.out.println("A total of " + bundleresult[0] + " interfaces were found");
            Main.printbundle(bundleresult);
            for (int m = 1; m < Integer.parseInt(bundleresult[0]) + 1; ++m) {
                if (bundleresult[m].contains(" 10000 Mbps")) {
                    System.out.println("High speed GB connection detected, verify if driver is configured to use huge pages, as this may help in performance");
                    System.out.println("Consider using affinity settings so the JVM and interface interrupts are on the same socket ");
                    continue;
                }
                if (bundleresult[m].contains(" 1000 Mbps")) continue;
                System.out.println("Interfaces might not be running at full speed");
            }
        } else {
            System.out.print("No full duplex 1000+ Mbps interfaces were found ");
        }
    }

    private static void Packages(int a) {
        Boolean title = false;
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nChecking Packages");
            title = true;
            System.out.println("A total of " + bundleresult[0] + " packages were found");
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult(".*zing.*", airesults))[0]) > 0) {
            if (!title.booleanValue()) {
                System.out.println("\nChecking Packages");
                title = true;
            }
            System.out.println("A total of " + bundleresult[0] + " zing packages were found");
            Main.printbundle(bundleresult);
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult(".*jdk.*", airesults))[0]) > 0) {
            if (!title.booleanValue()) {
                System.out.println("\nChecking Packages");
                title = true;
            }
            System.out.println("A total of " + bundleresult[0] + " JDK packages were found");
            Main.printbundle(bundleresult);
        }
    }

    private static void MemoryCheck(int a) {
        int b;
        String[] c;
        int bn;
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nRunning MemoryCheck logic ");
            Main.printbundle(bundleresult);
            System.out.println("If the results show both large amounts of HugePages and AnonHugePages the system may be short on memory.");
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult(".*AnonHugePages.*", airesults))[0]) > 0 && (bn = Integer.parseInt((c = bundleresult[b = Integer.parseInt(bundleresult[0])].split("\\s+"))[2])) > 0) {
            System.out.println("AnonHugePages is set to " + bn + " it should be 0, make sure transparent_hugepage=never is specified on the kernel boot args.");
        }
    }

    private static void OnloadHugePageSupport(int a) {
        List airesults;
        String[] bundleresult;
        if (Main.CheckRules("solarflare") > 0) {
            int n = (Integer)aidataFound.get("solarflare");
            System.out.println("The system has a SolarFlare card installed ");
        }
        if (Integer.parseInt((bundleresult = Main.bundleresult(".*", airesults = Main.collectresults(a)))[0]) > 0) {
            System.out.println("\nRunning OnloadHugePageSupport logic ");
            System.out.println("It appears that the NIC driver may work better, if a small (200) number of huge pages are configured.");
            System.out.println("Add vm.nr_hugepages=200 to /etc/sysctl.conf");
            Main.printbundle(bundleresult);
        }
    }

    private static void cpuspeed(int a) {
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nRunning cpuspeed logic ");
            System.out.println("The cpuspeed service is enabled, this can cause latency spikes as the cpu frequencies change or as cores power down.");
            System.out.println("Use command chkconfig --level 0123456 cpuspeed off to disable this option");
            Main.printbundle(bundleresult);
        }
    }

    private static void cputype(int a) {
        int socket = 0;
        int siblings = 0;
        int cores = 0;
        String model = "";
        List airesults = Main.collectresults(a);
        String[] bundleresult = Main.bundleresult(".*", airesults);
        if (Integer.parseInt(bundleresult[0]) > 0) {
            System.out.println("\nRunning cpu type logic ");
            for (int n = 0; n < 1 + Integer.parseInt(bundleresult[0]); ++n) {
                if (bundleresult[n].matches(".*physical id.*")) {
                    ++socket;
                }
                if (bundleresult[n].matches(".*siblings.*")) {
                    siblings = Integer.parseInt(Main.CheckRuleResult(bundleresult[n], 3));
                }
                if (bundleresult[n].matches(".*cpu cores.*")) {
                    cores = Integer.parseInt(Main.CheckRuleResult(bundleresult[n], 4));
                }
                if (!bundleresult[n].matches(".*model name.*")) continue;
                if (!model.matches(bundleresult[n]) && interactive) {
                    System.out.println("New model " + bundleresult[n]);
                }
                model = bundleresult[n];
            }
        }
        System.out.println("This is a " + model);
        System.out.print("This is a " + socket + " socket server, with " + cores + " cores per socket, " + siblings + " cores with hyperthreading ");
        if (cores == siblings) {
            System.out.println("disbled.");
        } else {
            System.out.println("enabled.");
        }
        if (Main.CheckRules("onlinecores") > 0) {
            System.out.print("Total online cores ");
            Main.CheckRulesPrint("onlinecores");
        }
    }

    static {
        myList = new ArrayList<String>();
        dbcommon = new HashMap();
        dbname = new Hashtable();
        dbhost = new HashMap();
        dbparm = new HashMap();
        aidata = new HashMap();
        aidataFound = new HashMap();
        aidataList = new HashMap();
        searchStringsMax = 0;
        querystats_ = new long[]{0L, 0L, 0L};
        junk = new String[]{"^\\[.*\\] Command not found or incorrect user privileges", "^\\[.*\\] .* No such file or directory", "^\\[.*\\] 127", "^\\[.*\\] 0", "^\\[.*\\] 1", "^\\[.*\\] .* Permission denied", "^\\[.*\\] .* command not found"};
        eyecatcher = new String[][]{{"hostname", "^\\[0\\]"}, {"uname", "^\\[1\\]"}, {"system-release, redhat-release, release,kernel.release,SuSe-release,lsb_release, debian_version", "^\\[2\\]|^\\[3\\]|^\\[19\\]|^\\[36\\]|^\\[70\\]"}, {"sysctl", "^\\[4\\]"}, {"lsof", "^\\[5\\]"}, {"rpm, packages, dpkg", "^\\[33\\]|^\\[46\\]"}, {"cpu, cores, sockets", "^\\[11\\]"}, {"memory, meminfo", "^\\[12\\]"}, {"swap, page, paging, swapping", "^\\[23\\]"}, {"lsmod, modules", "^\\[25\\]"}, {"ulimit", "^\\[26\\]"}, {"numa, numactl, numastat", "^\\[29\\]|^\\[32\\]"}, {"apic, powersetting, power, bios", "^\\[37\\]"}, {"clock-delta, clock, delta", "^\\[38\\]"}, {"grub, menu, menu.lst, kernel, boot", "^\\[45\\]"}};
        searchStrings = new String[][]{{"kernel", "\\[1\\] uname -a", "nextline", "\\s+", "3", "both"}, {"distribution", "\\] cat \\/etc\\/system-release", "nextline", "]\\s", "1", "both"}, {"swaptotal", "\\[12\\] SwapTotal", "sameline", "\\[12\\]\\sSwapTotal:", "1", "both"}, {"swapfree", "\\[12\\] SwapFree", "sameline", "\\[12\\]\\sSwapFree:", "1", "both"}, {"hostname", "\\[4\\] kernel.hostname|\\[1\\] Linux", "samelineall", "\\[4\\]\\skernel.hostname = |\\b\\s", "1", "both"}, {"uptime", "\\[42\\] uptime", "nextline", ",", "0", "both"}, {"onlinecores", "\\[27\\] Brought up", "sameline", "\\s+", "3", "both"}, {"osrelease", "\\[4\\] kernel.osrelease", "sameline", "\\s+", "3", "both"}, {"version", "\\[4\\] kernel.version", "sameline", "\\s+", "3", "both"}, {"swappiness", "\\[4\\] vm.swappiness", "sameline", "\\s+", "3", "both"}, {"minfree", "\\[4\\] vm.min_free_kbytes", "sameline", "\\s+", "3", "both"}, {"overcommit", "\\[4\\] vm.overcommit_memory", "sameline", "\\s+", "3", "both"}, {"oomkiller", "\\[4\\] vm.oom_kill_allocating_task", "sameline", "\\s+", "3", "both"}, {"oomkillercalled", "invoked oom-killer", "sameline", ".*", "0", "both"}, {"mlocked", "\\[12\\] Mlocked:", "sameline", "\\[12\\]\\sMlocked:", "1", "both"}, {"x11", "\\[33\\].*[Xx]11|\\[43\\] id:5:initdefault", "samelineall", "\\[33\\]", "1", "both"}, {"nics", "\\[27\\].*eth.*[L|l]ink.*[U|u]p", "samelineall", "\\.\\d:|^[a-z]", "1", "both"}, {"hypervisor", "^\\[27\\].*Booting.*kernel|^\\[25\\] vmmemctl|^\\[25\\].*balloon|^\\[54\\] Hypervisor vendor|^\\[27\\].*VMware|^\\[27\\] Hypervisor detected|VMware|vmware-tools| vboxdrv |virtual box hypervisor|kvm_intel|xen_mem|^\\[31\\] vmware-tools", "samelineall", "^[.]\\s.*", "0", "both"}, {"solarflare", "^\\[25\\] onload |^\\[25\\] sfc |^\\[27\\].*onload |^\\[31\\].*onload|^\\[33\\].*onload |^\\[60\\] install", "samelineall", "^[.]\\s.*", "0", "both"}, {"HTandIdlePoll", "^\\[27\\] WARNING: polling idle and HT enabled, performance may degrade.", "samelineall", "^[.]\\s.*", "0", "both"}, {"Servername", "^\\[0\\] .*", "samelineall", "^[.]\\s.*", "0", "both"}, {"Packages", "^\\[33\\] .*", "samelineall", "^[.]\\s.*", "0", "both"}, {"OnloadHugePageSupport", "^\\[27\\].*unable to allocate huge page", "samelineall", "^[.]\\s.*", "0", "both"}, {"CheckNumaInterleave", "^\\[29\\] available.* 1 nodes|^\\[29\\] node . cpus|^\\[54\\] On-line|^\\[27\\] Brought up", "samelineall", "^[.]\\s.*", "0", "both"}, {"iTCO", "^\\[27\\] iTCO_wdt\\: unable to reset NO_REBOOT flag\\, device disabled by hardware\\/BIOS", "samelineall", "^[.]\\s.*", "0", "both"}, {"MemoryCheck", "^\\[12\\] Mem|^\\[12\\] AnonHugePages|^\\[12\\] HugePages_Total", "samelineall", "^[.]\\s.*", "0", "both"}, {"cputype", "^\\[11\\].model.name|^\\[11\\] physical id|^\\[11\\] siblings|^\\[11\\] cpu cores|^\\[11\\] cpu MHz", "samelineall", "^[.]\\s.*", "0", "both"}, {"maxcstate", "^\\[45\\].*processor.max_cstate=1", "samelineall", "^[.]\\.*", "0", "both"}, {"vendors", "\\[5\\].*\\.jar|\\[5\\].*cwd|\\[EnvCheck\\] Found.*java", "samelineall", "\\s+/", "1", "azul"}, {"LargestResourceUser", "\\[17\\].*CPU|\\[62\\].*CPU", "nextline", "^[.]\\.*", "0", "both"}, {"JVMsFound", "\\[EnvCheck\\] Found .* Java instances", "sameline", "\\s+", "2", "both"}, {"Hardware", "\\[27\\].*DMI\\: |\\[14\\].*Manufacture|\\[14\\].*Product Name", "samelineall", "[a-zA-Z]\\:", "1", "both"}, {"cpuspeed", "\\[31\\] cpuspeed.*on", "sameline", "\\[31\\] ", "1", "both"}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}, {"", "", "", "", "", ""}};
    }
}

