#!/bin/bash
#
# Environment variable $ZVROBOTPort contains the port for ZVRobot, using
# azulinspector.jar as an agent will create the environment variable.
#
# To use AzulInspector as an agent add the following JVM args:
#       -javaagent:/myfiles/AzulInspector/AzulInspector.jar="MonitorMode"
#
# The agent will always run a mini environment check at startup.
# Using the MonitorMode parameter, will run AzulInspector in MonitorMode on a
# forked JVM.  If the Application JVM has a ARTAPort specified, then a ZVRobot
# JVM will be forked.
#
# Unzip ZVRobot and create a .prop file containing the correct host and port
# details.
# Store the .prop file in the AzulInspector directory add the port to the .prop
# name, ZVRobot.nnnn.prop where nnnn is the ARTAPort
# Verify the path and filename of the jar file.
#

if [ "$ZVROBOTPort" ] ; then
  echo "Starting ZVRobot using port "$ZVROBOTPort" this will terminate after 60 minutes" >> zvrobot.$ZVROBOTPort.log
  nohup java -jar /myfiles/ZVRobot/ZVRobot-15.05.0.0-16.jar any ZVRobot.$ZVROBOTPort.prop 2>&1 >> zvrobot.$ZVROBOTPort.log &
fi

nohup java -classpath AzulInspector.jar azulinspector.MonitorMode | tee `hostname`-AzulMonitorMode.`date +%F-%H%M`.log &
