#!/bin/bash

export aicheck=$_

echo "This script will check the last AzulInspector System Qualification log"
echo ""
echo "If you would like to check a different log, pass the filename as a parameter to this script"
echo ""

if [ ! -n "$1" ]; then
  fn=`ls -1t *AzulSystemQual*.log | grep -m 1 log`
else
  fn=$1
fi

filename=`echo $fn|sed -e "s/^\(.*\)-AzulSystemQual.*/\1/"`

echo "The following results are also written to a log file "$filename"-AzulCheckResults.`date +%F-%H%M`.out"
java -jar aicheck.jar $fn | tee ${filename}-AzulCheckResults.`date +%F-%H%M`.out

unset aicheck
