#!/bin/bash
#
# Azul Systems, Inc. AzulInspector Check version 3.0
# Copyright Azul Systems, Inc. 2015
#
# AzulInspector is provided “AS IS” and without warranty of any kind, express
# or implied, including without limitation any warranty of merchantability,
# fitness for a particular purpose, or non-infringement, each of which are hereby
# expressly disclaimed.  You acknowledge and agree that any use of AzulInspector
# is at your sole risk.
#
# Azul will not be liable to you (whether under contract, tort, strict liability,
# negligence, or any other legal or equitable theory) for (i) any indirect,
# incidental, consequential, special, punitive, or reliance damages relating to
# your download, use or installation of AzulInspector (including without
# limitation any loss of or damage to data or systems) or implementation of any
# recommendations, or (ii) for any direct damages in excess of (in the aggregate)
# one hundred U.S. dollars ($100).  Some states do not allow the exclusion or
# limitation of incidental or consequential damages, so the above limitations may
# not apply to you.
#
# This is a generated script!
#
# This script can be used by the System Administrator to collect the environment
# setup information via a generated script rather than running jar file as root/sudo
#

export LC_ALL=C
GRP=
GRPID=
DONE=no

trap on_exit EXIT SIGINT SIGQUIT

on_exit() {
  [ "yes" = "$DONE" ] || echo "Warning: script execution terminated"
}

run() {
  local cmd_id=$1; shift;
  local cmd=$@
  local prefix="[${GRPID}${GRPID/*/ }${cmd_id}]"

   cat << EOF | sed "s/^/${prefix} /"
$(date); Calling ${GRP} Command: ${prefix} ${cmd}
$($cmd 2>&1)
ExitCode: $?
EOF
  echo
}

line() {
  local title="${GRP} Commands"
  local l=$(expr 80 - ${#title})
  [ $l -ge 5 ] || l=5
  echo -n "-- ${title} "; printf '%0.s-' $(seq 1 $l); echo " [ $1 $(date) ]"
  echo
}

run_group() {
  GRP=$1
  GRPID=$2

  line started
  while read cmd; do run $cmd; done
  line complete
}

LOG_FILE=${LOG_FILE:-AzulInspectorScript.log}

if [ -f "${LOG_FILE}" ]; then
   mv "${LOG_FILE}" "${LOG_FILE}.$(date +%s)"
fi

cat << EOF
##################################################
# $(date)
# Starting data collection.
# The output will be captured to the ${LOG_FILE}.
# Please return the logfile for analysis.
##################################################

EOF

exec > >(tee ${LOG_FILE}) 2>&1
