/*
 * Decompiled with CFR 0.152.
 */
package org.jhiccup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.jhiccup.internal.hdrhistogram.Histogram;
import org.jhiccup.internal.hdrhistogram.HistogramLogWriter;
import org.jhiccup.internal.hdrhistogram.SingleWriterRecorder;

public class HiccupMeter
extends Thread {
    private static final String versionString = "jHiccup version 2.0.10";
    static final String defaultHiccupLogFileName = "hiccup.%date.%pid.hlog";
    protected final PrintStream log;
    protected final HistogramLogWriter histogramLogWriter;
    protected final HiccupMeterConfiguration config;

    public HiccupMeter(String[] args, String defaultLogFileName) throws FileNotFoundException {
        this.setName("HiccupMeter");
        this.config = new HiccupMeterConfiguration(args, defaultLogFileName);
        this.log = new PrintStream(new FileOutputStream(this.config.logFileName), false);
        this.histogramLogWriter = new HistogramLogWriter(this.log);
        this.setDaemon(true);
    }

    public HiccupRecorder createHiccupRecorder(SingleWriterRecorder recorder) {
        return new HiccupRecorder(recorder, this.config.allocateObjects);
    }

    public String getVersionString() {
        return versionString;
    }

    @Override
    public void run() {
        block18: {
            HiccupRecorder hiccupRecorder;
            block17: {
                long jvmStartTime;
                SingleWriterRecorder recorder = new SingleWriterRecorder(this.config.lowestTrackableValue, this.config.highestTrackableValue, this.config.numberOfSignificantValueDigits);
                Histogram intervalHistogram = null;
                long uptimeAtInitialStartTime = ManagementFactory.getRuntimeMXBean().getUptime();
                long now = System.currentTimeMillis();
                long reportingStartTime = jvmStartTime = now - uptimeAtInitialStartTime;
                if (this.config.inputFileName == null) {
                    hiccupRecorder = this.createHiccupRecorder(recorder);
                    if (this.config.terminateWithStdInput) {
                        new TerminateWithStdInputReader();
                    }
                    if (this.config.controlProcessCommand != null) {
                        new ExecProcess(this.config.controlProcessCommand, "ControlProcess", this.log, this.config.verbose);
                    }
                } else {
                    hiccupRecorder = new InputRecorder(recorder, this.config.inputFileName);
                }
                this.histogramLogWriter.outputComment("[Logged with " + this.getVersionString() + "]");
                this.histogramLogWriter.outputLogFormatVersion();
                try {
                    long startTime;
                    if (this.config.inputFileName == null) {
                        if (this.config.startDelayMs > 0L) {
                            hiccupRecorder.start();
                            while (this.config.startDelayMs > System.currentTimeMillis() - jvmStartTime) {
                                Thread.sleep(100L);
                            }
                            hiccupRecorder.terminate();
                            hiccupRecorder.join();
                            recorder.reset();
                            hiccupRecorder = new HiccupRecorder(recorder, this.config.allocateObjects);
                        }
                        hiccupRecorder.start();
                        startTime = System.currentTimeMillis();
                        if (this.config.startTimeAtZero) {
                            reportingStartTime = startTime;
                        }
                        this.histogramLogWriter.outputStartTime(reportingStartTime);
                        this.histogramLogWriter.setBaseTime(reportingStartTime);
                    } else {
                        hiccupRecorder.start();
                        now = reportingStartTime = hiccupRecorder.getCurrentTimeMsecWithDelay(0L);
                        while (this.config.startDelayMs > now - reportingStartTime) {
                            now = hiccupRecorder.getCurrentTimeMsecWithDelay(0L);
                        }
                        startTime = now;
                        this.histogramLogWriter.outputComment("[Data read from input file \"" + this.config.inputFileName + "\" at " + new Date() + "]");
                    }
                    this.histogramLogWriter.outputLegend();
                    long nextReportingTime = startTime + this.config.reportingIntervalMs;
                    long intervalStartTimeMsec = 0L;
                    while (now >= 0L && (this.config.runTimeMs == 0L || this.config.runTimeMs >= now - startTime)) {
                        now = hiccupRecorder.getCurrentTimeMsecWithDelay(nextReportingTime);
                        if (now < nextReportingTime) continue;
                        intervalHistogram = recorder.getIntervalHistogram(intervalHistogram);
                        while (now >= nextReportingTime) {
                            nextReportingTime += this.config.reportingIntervalMs;
                        }
                        if (this.config.inputFileName != null) {
                            intervalHistogram.setStartTimeStamp(intervalStartTimeMsec);
                            intervalHistogram.setEndTimeStamp(now);
                            intervalStartTimeMsec = now;
                        }
                        if (intervalHistogram.getTotalCount() <= 0L) continue;
                        this.histogramLogWriter.outputIntervalHistogram(intervalHistogram);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.config.verbose) break block17;
                    this.log.println("# HiccupMeter terminating...");
                }
            }
            try {
                hiccupRecorder.terminate();
                hiccupRecorder.join();
            }
            catch (InterruptedException e) {
                if (!this.config.verbose) break block18;
                this.log.println("# HiccupMeter terminate/join interrupted");
            }
        }
    }

    public static HiccupMeter commonMain(String[] args, boolean exitOnError) {
        HiccupMeter hiccupMeter = null;
        try {
            hiccupMeter = new HiccupMeter(args, defaultHiccupLogFileName);
            if (hiccupMeter.config.attachToProcess) {
                String[] errorMessage = "Cannot use -p option with HiccupMeter (use HiccupMeterAttacher instead)";
                if (exitOnError) {
                    System.err.println((String)errorMessage);
                    System.exit(1);
                } else {
                    throw new RuntimeException("Error: " + (String)errorMessage);
                }
            }
            if (hiccupMeter.config.error) {
                if (exitOnError) {
                    System.exit(1);
                } else {
                    throw new RuntimeException("Error: " + hiccupMeter.config.errorMessage);
                }
            }
            if (hiccupMeter.config.verbose) {
                hiccupMeter.log.print("# Executing: HiccupMeter");
                for (String arg : args) {
                    hiccupMeter.log.print(" " + arg);
                }
                hiccupMeter.log.println("");
            }
            hiccupMeter.start();
        }
        catch (FileNotFoundException e) {
            System.err.println("HiccupMeter: Failed to open log file.");
        }
        return hiccupMeter;
    }

    public static void agentmain(String argsString, Instrumentation inst) {
        String[] args = argsString != null && !argsString.equals("") ? argsString.split("[ ,;]+") : new String[]{};
        String avoidRecursion = System.getProperty("org.jhiccup.avoidRecursion");
        if (avoidRecursion != null) {
            return;
        }
        HiccupMeter.commonMain(args, false);
    }

    public static void premain(String argsString, Instrumentation inst) {
        String[] args = argsString != null && !argsString.equals("") ? argsString.split("[ ,;]+") : new String[]{};
        String avoidRecursion = System.getProperty("org.jhiccup.avoidRecursion");
        if (avoidRecursion != null) {
            return;
        }
        HiccupMeter.commonMain(args, true);
    }

    public static void main(String[] args) {
        block3: {
            HiccupMeter hiccupMeter = HiccupMeter.commonMain(args, true);
            if (hiccupMeter != null) {
                try {
                    hiccupMeter.join();
                }
                catch (InterruptedException e) {
                    if (!hiccupMeter.config.verbose) break block3;
                    hiccupMeter.log.println("# HiccupMeter main() interrupted");
                }
            }
        }
    }

    class InputRecorder
    extends HiccupRecorder {
        final Scanner scanner;
        long prevTimeMsec;
        long inputLineTimeMsec;
        long msecThatPrecedesInputLine;
        double inputLineHiccupTimeMsec;
        boolean reportedAfterTerminate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputRecorder(SingleWriterRecorder recorder, String inputFileName) {
            super(recorder, false);
            this.prevTimeMsec = 0L;
            this.inputLineTimeMsec = 0L;
            this.msecThatPrecedesInputLine = -1L;
            this.inputLineHiccupTimeMsec = -1.0;
            this.reportedAfterTerminate = false;
            Scanner newScanner = null;
            try {
                newScanner = new Scanner(new File(inputFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("HiccupMeter: Failed to open input file \"" + inputFileName + "\"");
                System.exit(-1);
            }
            finally {
                this.scanner = newScanner;
            }
        }

        long processInputLine(Scanner scanner, SingleWriterRecorder recorder) {
            if (scanner.hasNextLine()) {
                try {
                    this.inputLineTimeMsec = (long)scanner.nextDouble();
                    this.inputLineHiccupTimeMsec = scanner.nextDouble();
                    long l = this.msecThatPrecedesInputLine = HiccupMeter.this.config.fillInZerosInInputFile ? this.inputLineTimeMsec - (long)Math.ceil(this.inputLineHiccupTimeMsec) : this.inputLineTimeMsec;
                    if (this.inputLineTimeMsec < this.prevTimeMsec) {
                        return -1L;
                    }
                    return this.inputLineTimeMsec;
                }
                catch (NoSuchElementException e) {
                    return -1L;
                }
            }
            return -1L;
        }

        @Override
        public long getCurrentTimeMsecWithDelay(long nextReportingTime) throws InterruptedException {
            long numberOfTicksBeforeNextReportingTime;
            do {
                if (nextReportingTime < this.msecThatPrecedesInputLine) {
                    numberOfTicksBeforeNextReportingTime = (long)((double)(nextReportingTime - this.prevTimeMsec) / HiccupMeter.this.config.resolutionMs);
                    if (HiccupMeter.this.config.fillInZerosInInputFile && numberOfTicksBeforeNextReportingTime > 0L) {
                        this.recorder.recordValueWithCount(0L, numberOfTicksBeforeNextReportingTime);
                    }
                    this.prevTimeMsec = nextReportingTime;
                    return nextReportingTime;
                }
                if (this.msecThatPrecedesInputLine < this.prevTimeMsec) continue;
                long numberOfTicksBeforeInputHiccup = (long)((double)(this.msecThatPrecedesInputLine - this.prevTimeMsec) / HiccupMeter.this.config.resolutionMs);
                if (HiccupMeter.this.config.fillInZerosInInputFile && numberOfTicksBeforeInputHiccup > 0L) {
                    this.recorder.recordValueWithCount(0L, numberOfTicksBeforeInputHiccup);
                }
                long hiccupTimeNsec = (long)(this.inputLineHiccupTimeMsec * 1000000.0);
                this.recorder.recordValueWithExpectedInterval(hiccupTimeNsec, (long)(HiccupMeter.this.config.resolutionMs * 1000000.0));
                this.prevTimeMsec = this.inputLineTimeMsec;
            } while (this.processInputLine(this.scanner, this.recorder) >= 0L);
            if (!this.reportedAfterTerminate) {
                numberOfTicksBeforeNextReportingTime = (long)((double)(nextReportingTime - this.prevTimeMsec) / HiccupMeter.this.config.resolutionMs);
                if (HiccupMeter.this.config.fillInZerosInInputFile && numberOfTicksBeforeNextReportingTime > 0L) {
                    this.recorder.recordValueWithCount(0L, numberOfTicksBeforeNextReportingTime);
                }
                this.reportedAfterTerminate = true;
                return nextReportingTime;
            }
            return -1L;
        }

        @Override
        public void run() {
            block3: {
                try {
                    while (this.doRun) {
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    if (!HiccupMeter.this.config.verbose) break block3;
                    HiccupMeter.this.log.println("# HiccupRecorder interrupted/terminating...");
                }
            }
        }
    }

    public class HiccupRecorder
    extends Thread {
        public volatile boolean doRun;
        private final boolean allocateObjects;
        public volatile Long lastSleepTimeObj;
        protected final SingleWriterRecorder recorder;

        public HiccupRecorder(SingleWriterRecorder recorder, boolean allocateObjects) {
            this.setDaemon(true);
            this.setName("HiccupRecorder");
            this.recorder = recorder;
            this.allocateObjects = allocateObjects;
            this.doRun = true;
        }

        public void terminate() {
            this.doRun = false;
        }

        public long getCurrentTimeMsecWithDelay(long nextReportingTime) throws InterruptedException {
            long now = System.currentTimeMillis();
            if (now < nextReportingTime) {
                Thread.sleep(nextReportingTime - now);
            }
            return now;
        }

        @Override
        public void run() {
            block6: {
                long resolutionNsec = (long)(HiccupMeter.this.config.resolutionMs * 1000.0 * 1000.0);
                try {
                    long shortestObservedDeltaTimeNsec = Long.MAX_VALUE;
                    long timeBeforeMeasurement = Long.MAX_VALUE;
                    while (this.doRun) {
                        if (HiccupMeter.this.config.resolutionMs != 0.0) {
                            TimeUnit.NANOSECONDS.sleep(resolutionNsec);
                            if (this.allocateObjects) {
                                this.lastSleepTimeObj = new Long(timeBeforeMeasurement);
                            }
                        }
                        long timeAfterMeasurement = System.nanoTime();
                        long deltaTimeNsec = timeAfterMeasurement - timeBeforeMeasurement;
                        timeBeforeMeasurement = timeAfterMeasurement;
                        if (deltaTimeNsec < 0L) continue;
                        if (deltaTimeNsec < shortestObservedDeltaTimeNsec) {
                            shortestObservedDeltaTimeNsec = deltaTimeNsec;
                        }
                        long hiccupTimeNsec = deltaTimeNsec - shortestObservedDeltaTimeNsec;
                        this.recorder.recordValueWithExpectedInterval(hiccupTimeNsec, resolutionNsec);
                    }
                }
                catch (InterruptedException e) {
                    if (!HiccupMeter.this.config.verbose) break block6;
                    HiccupMeter.this.log.println("# HiccupRecorder interrupted/terminating...");
                }
            }
        }
    }

    class TerminateWithStdInputReader
    extends Thread {
        TerminateWithStdInputReader() {
            this.setDaemon(true);
            this.setName("terminateWithStdInputReader");
            this.start();
        }

        @Override
        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
                System.exit(1);
            }
            catch (Exception e) {
                System.exit(1);
            }
        }
    }

    public static class ExecProcess
    extends Thread {
        final String processName;
        final String command;
        final boolean verbose;
        final PrintStream log;

        public ExecProcess(String command, String processName, PrintStream log, boolean verbose) {
            this.setDaemon(true);
            this.setName(processName + "ExecThread");
            this.command = command;
            this.processName = processName;
            this.log = log;
            this.verbose = verbose;
            this.start();
        }

        @Override
        public void run() {
            try {
                if (this.verbose) {
                    this.log.println("# HiccupMeter Executing " + this.processName + " command: " + this.command);
                }
                Process p = Runtime.getRuntime().exec(this.command);
                p.waitFor();
            }
            catch (Exception e) {
                System.err.println("HiccupMeter: " + this.processName + " terminated.");
            }
        }
    }

    protected static class HiccupMeterConfiguration {
        public boolean terminateWithStdInput = false;
        public double resolutionMs = 1.0;
        public long runTimeMs = 0L;
        public long reportingIntervalMs = 5000L;
        public long startDelayMs = 0L;
        public boolean startDelayMsExplicitlySpecified = false;
        public boolean verbose = false;
        public boolean allocateObjects = false;
        public String logFileName;
        public boolean logFileExplicitlySpecified = false;
        public String inputFileName = null;
        public boolean fillInZerosInInputFile = false;
        public boolean logFormatCsv = false;
        public boolean launchControlProcess = false;
        public long launchControlProcessHeapSizeMBFilter = 0L;
        public String controlProcessLogFileName = null;
        public String controlProcessCommand = null;
        public boolean controlProcessJvmArgsExplicitlySpecified = false;
        public String controlProcessJvmArgs;
        public boolean attachToProcess = false;
        public String pidOfProcessToAttachTo = null;
        public String agentJarFileName = null;
        public String agentArgs = null;
        public boolean startTimeAtZero = false;
        public long lowestTrackableValue = 20000L;
        public long highestTrackableValue = 2592000000000000L;
        public int numberOfSignificantValueDigits = 2;
        public boolean error = false;
        public String errorMessage = "";

        String fillInPidAndDate(String logFileName) {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            String processID = processName.split("@")[0];
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd.HHmm");
            String formattedDate = formatter.format(new Date());
            logFileName = logFileName.replaceAll("%pid", processID);
            logFileName = logFileName.replaceAll("%date", formattedDate);
            return logFileName;
        }

        public HiccupMeterConfiguration(String[] args, String defaultLogFileName) {
            this.logFileName = defaultLogFileName;
            try {
                MemoryMXBean mxbean;
                MemoryUsage memoryUsage;
                long estimatedHeapMB;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-v")) {
                        this.verbose = true;
                        continue;
                    }
                    if (args[i].equals("-0")) {
                        this.startTimeAtZero = true;
                        continue;
                    }
                    if (args[i].equals("-a")) {
                        this.allocateObjects = true;
                        continue;
                    }
                    if (args[i].equals("-p")) {
                        this.attachToProcess = true;
                        this.pidOfProcessToAttachTo = args[++i];
                        continue;
                    }
                    if (args[i].equals("-j")) {
                        this.agentJarFileName = args[++i];
                        continue;
                    }
                    if (args[i].equals("-terminateWithStdInput")) {
                        this.terminateWithStdInput = true;
                        continue;
                    }
                    if (args[i].equals("-i")) {
                        this.reportingIntervalMs = Long.parseLong(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-t")) {
                        this.runTimeMs = Long.parseLong(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-d")) {
                        this.startDelayMs = Long.parseLong(args[++i]);
                        this.startDelayMsExplicitlySpecified = true;
                        continue;
                    }
                    if (args[i].equals("-r")) {
                        this.resolutionMs = Double.parseDouble(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-s")) {
                        this.numberOfSignificantValueDigits = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-l")) {
                        this.logFileName = args[++i];
                        this.logFileExplicitlySpecified = true;
                        continue;
                    }
                    if (args[i].equals("-f")) {
                        this.inputFileName = args[++i];
                        this.lowestTrackableValue = 1L;
                        continue;
                    }
                    if (args[i].equals("-fz")) {
                        this.fillInZerosInInputFile = true;
                        continue;
                    }
                    if (args[i].equals("-c")) {
                        this.launchControlProcess = true;
                        continue;
                    }
                    if (args[i].equals("-cfmb")) {
                        this.launchControlProcessHeapSizeMBFilter = Long.parseLong(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-x")) {
                        this.controlProcessJvmArgs = args[++i];
                        this.controlProcessJvmArgsExplicitlySpecified = true;
                        continue;
                    }
                    if (args[i].equals("-o")) {
                        this.logFormatCsv = true;
                        continue;
                    }
                    throw new Exception("Invalid args: " + args[i]);
                }
                this.logFileName = this.fillInPidAndDate(this.logFileName);
                if (this.attachToProcess) {
                    if (!this.startDelayMsExplicitlySpecified) {
                        this.startDelayMs = 0L;
                    }
                    if (this.agentJarFileName == null) {
                        throw new Exception("Invalid args, missing agent jar file name, specify with -j option");
                    }
                    this.agentArgs = "-d " + this.startDelayMs + " -i " + this.reportingIntervalMs + (this.startTimeAtZero ? " -0" : "") + " -s " + this.numberOfSignificantValueDigits + " -r " + this.resolutionMs;
                    if (this.runTimeMs != 0L) {
                        this.agentArgs = this.agentArgs + " -t " + this.runTimeMs;
                    }
                    if (this.logFileExplicitlySpecified) {
                        this.agentArgs = this.agentArgs + " -l " + this.logFileName;
                    }
                    if (this.launchControlProcess) {
                        this.agentArgs = this.agentArgs + " -c";
                    }
                    if (this.controlProcessJvmArgsExplicitlySpecified) {
                        this.agentArgs = this.agentArgs + " -x " + this.controlProcessJvmArgs;
                    }
                    if (this.verbose) {
                        this.agentArgs = this.agentArgs + " -v";
                    }
                    if (this.logFormatCsv) {
                        this.agentArgs = this.agentArgs + " -o";
                    }
                }
                if (this.launchControlProcess && this.launchControlProcessHeapSizeMBFilter > 0L && (estimatedHeapMB = (memoryUsage = (mxbean = ManagementFactory.getMemoryMXBean()).getHeapMemoryUsage()).getMax() / 0x100000L) < this.launchControlProcessHeapSizeMBFilter) {
                    this.launchControlProcess = false;
                }
                if (this.launchControlProcess) {
                    File filePath = new File(this.logFileName);
                    String parentFileNamePart = filePath.getParent();
                    String childFileNamePart = filePath.getName();
                    File controlFilePath = new File(parentFileNamePart, childFileNamePart + ".c");
                    this.controlProcessLogFileName = controlFilePath.getPath();
                    CodeSource agentCodeSource = HiccupMeter.class.getProtectionDomain().getCodeSource();
                    String agentPath = new File(agentCodeSource.getLocation().toURI()).getPath();
                    this.controlProcessCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (this.controlProcessJvmArgsExplicitlySpecified ? " " + this.controlProcessJvmArgs : "") + " -cp " + agentPath + " -Dorg.jhiccup.avoidRecursion=true " + HiccupMeter.class.getCanonicalName() + " -l " + this.controlProcessLogFileName + " -i " + this.reportingIntervalMs + " -d " + this.startDelayMs + (this.startTimeAtZero ? " -0" : "") + (this.logFormatCsv ? " -o" : "") + " -s " + this.numberOfSignificantValueDigits + " -r " + this.resolutionMs + " -terminateWithStdInput";
                }
                if (this.resolutionMs < 0.0) {
                    System.err.println("resolutionMs must be positive.");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                this.error = true;
                this.errorMessage = "Error: launched with the following args:\n";
                for (String arg : args) {
                    this.errorMessage = this.errorMessage + arg + " ";
                }
                this.errorMessage = this.errorMessage + "\nWhich was parsed as an error, indicated by the following exception:\n" + e;
                System.err.println(this.errorMessage);
                String validArgs = "\"[-v] [-c] [-x controlProcessArgs] [-o] [-0] [-n] [-p pidOfProcessToAttachTo] [-j jHiccupJarFileName] [-i reportingIntervalMs] [-h] [-t runTimeMs] [-d startDelayMs] [-l logFileName] [-r resolutionMs] [-terminateWithStdInput] [-f inputFileName]\"\n";
                System.err.println("valid arguments = " + validArgs);
                System.err.println(" [-h]                        help\n [-v]                        verbose\n [-l logFileName]            Log hiccup information into logFileName and logFileName.hgrm\n                             (will replace occurrences of %pid and %date with appropriate information)\n [-o]                        Output log files in CSV format\n [-c]                        Launch a control process in a separate JVM\n                             logging hiccup data into logFileName.c and logFileName.c.hgrm\n [-cfmb controlProcessArgs]  Control process filter heap size (in MB): only launch control proc if\n                             this process's heap size is larger than the -cfmb parameter\n [-x controlProcessArgs]     Pass additional args to the control process JVM\n [-p pidOfProcessToAttachTo] Attach to the process with given pid and inject jHiccup as an agent\n [-j jHiccupJarFileName]     File name for the jHiccup.jar file, and required with [-p] option above\n [-d startDelayMs]           Delay the beginning of hiccup measurement by\n                             startDelayMs milliseconds [default 0]\n [-0]                        Start timestamps at 0 (as opposed to at JVM runtime at start point)\n [-a]                        Allocate a throwaway object on every sample [default false]\n [-i reportingIntervalMs]    Set reporting interval [default 5000]\n [-r resolutionMs]           Set sampling resolution in milliseconds [default 1]\n [-t runTimeMs]              Limit measurement time [default 0, for infinite]\n [-terminateWithStdInput]    Take over standard input, and terminate process when\n                             standard input is severed (useful for control\n                             processes that wish to terminate when their launching\n                             parent does).\n [-f inputFileName]          Read timestamp and latency data from input file\n                             instead of sampling it directly\n [-fz]                       (applies only in conjunction with -f) fill in blank time ranges                             with zero values. Useful e.g. when processing GC-log derived input.\n [-s numberOfSignificantValueDigits]\n");
            }
        }
    }
}

