/*
 * Decompiled with CFR 0.152.
 */
package org.jhiccup;

import java.io.FileNotFoundException;

public class Idle
extends Thread {
    IdleConfiguration config = new IdleConfiguration();

    public Idle() throws FileNotFoundException {
    }

    public Idle(String[] args) throws FileNotFoundException {
        this.config.parseArgs(args);
    }

    public void terminate() {
        this.interrupt();
    }

    @Override
    public void run() {
        block5: {
            if (this.config.useIdleReader) {
                new IdleReader();
            }
            try {
                if (this.config.verbose) {
                    System.out.println("Idling for " + this.config.runTimeMs + "msec...");
                }
                long startTime = System.currentTimeMillis();
                while (this.config.runTimeMs == 0L || this.config.runTimeMs > System.currentTimeMillis() - startTime) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                if (!this.config.verbose) break block5;
                System.out.println("Idle terminating...");
            }
        }
    }

    public static void main(String[] args) {
        try {
            Idle idler = new Idle(args);
            if (idler.config.verbose) {
                System.out.print("Executing: idler");
                for (String arg : args) {
                    System.out.print(" " + arg);
                }
                System.out.println("");
            }
            idler.start();
            try {
                idler.join();
            }
            catch (InterruptedException e) {
                if (idler.config.verbose) {
                    System.out.println("idler main() interrupted");
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Failed to open log file.");
        }
    }

    class IdleReader
    extends Thread {
        IdleReader() {
            this.setDaemon(true);
            this.setName("IdleReader");
            this.start();
        }

        @Override
        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
                System.exit(1);
            }
            catch (Exception e) {
                System.exit(1);
            }
        }
    }

    class IdleConfiguration {
        public long runTimeMs = 10000L;
        public boolean verbose = false;
        public boolean useIdleReader = true;

        IdleConfiguration() {
        }

        public void parseArgs(String[] args) {
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-v")) {
                        Idle.this.config.verbose = true;
                        continue;
                    }
                    if (args[i].equals("-n")) {
                        Idle.this.config.useIdleReader = false;
                        continue;
                    }
                    if (args[i].equals("-t")) {
                        this.runTimeMs = Long.parseLong(args[++i]);
                        continue;
                    }
                    throw new Exception("Invalid args");
                }
            }
            catch (Exception e) {
                System.err.println("Usage: java Idle [-v] [-n] [-t runTimeMs]");
                System.exit(1);
            }
        }
    }
}

