/*
 * Decompiled with CFR 0.152.
 */
package org.jhiccup.internal.hdrhistogram;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;

public class WriterReaderPhaser {
    private volatile long startEpoch = 0L;
    private volatile long evenEndEpoch = 0L;
    private volatile long oddEndEpoch = Long.MIN_VALUE;
    private final ReentrantLock readerLock = new ReentrantLock();
    private static final AtomicLongFieldUpdater<WriterReaderPhaser> startEpochUpdater = AtomicLongFieldUpdater.newUpdater(WriterReaderPhaser.class, "startEpoch");
    private static final AtomicLongFieldUpdater<WriterReaderPhaser> evenEndEpochUpdater = AtomicLongFieldUpdater.newUpdater(WriterReaderPhaser.class, "evenEndEpoch");
    private static final AtomicLongFieldUpdater<WriterReaderPhaser> oddEndEpochUpdater = AtomicLongFieldUpdater.newUpdater(WriterReaderPhaser.class, "oddEndEpoch");

    public long writerCriticalSectionEnter() {
        return startEpochUpdater.getAndIncrement(this);
    }

    public void writerCriticalSectionExit(long criticalValueAtEnter) {
        if (criticalValueAtEnter < 0L) {
            oddEndEpochUpdater.getAndIncrement(this);
        } else {
            evenEndEpochUpdater.getAndIncrement(this);
        }
    }

    public void readerLock() {
        this.readerLock.lock();
    }

    public void readerUnlock() {
        this.readerLock.unlock();
    }

    public void flipPhase(long yieldTimeNsec) {
        long initialStartValue;
        boolean nextPhaseIsEven;
        if (!this.readerLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("flipPhase() can only be called while holding the readerLock()");
        }
        boolean bl = nextPhaseIsEven = this.startEpoch < 0L;
        if (nextPhaseIsEven) {
            initialStartValue = 0L;
            evenEndEpochUpdater.lazySet(this, initialStartValue);
        } else {
            initialStartValue = Long.MIN_VALUE;
            oddEndEpochUpdater.lazySet(this, initialStartValue);
        }
        long startValueAtFlip = startEpochUpdater.getAndSet(this, initialStartValue);
        boolean caughtUp = false;
        do {
            if (nextPhaseIsEven) {
                caughtUp = this.oddEndEpoch == startValueAtFlip;
            } else {
                boolean bl2 = caughtUp = this.evenEndEpoch == startValueAtFlip;
            }
            if (caughtUp) continue;
            if (yieldTimeNsec == 0L) {
                Thread.yield();
                continue;
            }
            try {
                TimeUnit.NANOSECONDS.sleep(yieldTimeNsec);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!caughtUp);
    }

    public void flipPhase() {
        this.flipPhase(0L);
    }
}

